/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ChaincodeEventPackage;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.shim.Chaincode;

public final class ChaincodeMessageFactory {
    private ChaincodeMessageFactory() {
    }

    protected static ChaincodeShim.ChaincodeMessage newGetPrivateDataHashEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_PRIVATE_DATA_HASH, channelId, txId, ChaincodeShim.GetState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newGetStateEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_STATE, channelId, txId, ChaincodeShim.GetState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newGetStateMetadataEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_STATE_METADATA, channelId, txId, ChaincodeShim.GetStateMetadata.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newPutStateEventMessage(String channelId, String txId, String collection, String key, ByteString value) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.PUT_STATE, channelId, txId, ChaincodeShim.PutState.newBuilder().setCollection(collection).setKey(key).setValue(value).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newPutStateMetadataEventMessage(String channelId, String txId, String collection, String key, String metakey, ByteString value) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.PUT_STATE_METADATA, channelId, txId, ChaincodeShim.PutStateMetadata.newBuilder().setCollection(collection).setKey(key).setMetadata(ChaincodeShim.StateMetadata.newBuilder().setMetakey(metakey).setValue(value).build()).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newDeleteStateEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.DEL_STATE, channelId, txId, ChaincodeShim.DelState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeShim.ChaincodeMessage newErrorEventMessage(String channelId, String txId, Throwable throwable) {
        return ChaincodeMessageFactory.newErrorEventMessage(channelId, txId, ChaincodeMessageFactory.printStackTrace(throwable));
    }

    protected static ChaincodeShim.ChaincodeMessage newErrorEventMessage(String channelId, String txId, String message) {
        return ChaincodeMessageFactory.newErrorEventMessage(channelId, txId, message, null);
    }

    protected static ChaincodeShim.ChaincodeMessage newErrorEventMessage(String channelId, String txId, String message, ChaincodeEventPackage.ChaincodeEvent event) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.ERROR, channelId, txId, ByteString.copyFromUtf8((String)message), event);
    }

    protected static ChaincodeShim.ChaincodeMessage newCompletedEventMessage(String channelId, String txId, Chaincode.Response response, ChaincodeEventPackage.ChaincodeEvent event) {
        ChaincodeShim.ChaincodeMessage message = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.COMPLETED, channelId, txId, ChaincodeMessageFactory.toProtoResponse(response).toByteString(), event);
        return message;
    }

    protected static ChaincodeShim.ChaincodeMessage newInvokeChaincodeMessage(String channelId, String txId, ByteString payload) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.INVOKE_CHAINCODE, channelId, txId, payload, null);
    }

    protected static ChaincodeShim.ChaincodeMessage newRegisterChaincodeMessage(Chaincode.ChaincodeID chaincodeId) {
        return ChaincodeShim.ChaincodeMessage.newBuilder().setType(ChaincodeShim.ChaincodeMessage.Type.REGISTER).setPayload(chaincodeId.toByteString()).build();
    }

    protected static ChaincodeShim.ChaincodeMessage newEventMessage(ChaincodeShim.ChaincodeMessage.Type type, String channelId, String txId, ByteString payload) {
        return ChaincodeMessageFactory.newEventMessage(type, channelId, txId, payload, null);
    }

    protected static ChaincodeShim.ChaincodeMessage newEventMessage(ChaincodeShim.ChaincodeMessage.Type type, String channelId, String txId, ByteString payload, ChaincodeEventPackage.ChaincodeEvent event) {
        ChaincodeShim.ChaincodeMessage.Builder builder = ChaincodeShim.ChaincodeMessage.newBuilder().setType(type).setChannelId(channelId).setTxid(txId).setPayload(payload);
        if (event != null) {
            builder.setChaincodeEvent(event);
        }
        return builder.build();
    }

    private static ProposalResponsePackage.Response toProtoResponse(Chaincode.Response response) {
        ProposalResponsePackage.Response.Builder builder = ProposalResponsePackage.Response.newBuilder();
        builder.setStatus(response.getStatus().getCode());
        if (response.getMessage() != null) {
            builder.setMessage(response.getMessage());
        }
        if (response.getPayload() != null) {
            builder.setPayload(ByteString.copyFrom((byte[])response.getPayload()));
        }
        return builder.build();
    }

    private static String printStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter buffer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }
}

