/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.impl.ChaincodeMessageFactory;
import org.hyperledger.fabric.shim.impl.InvocationStubImpl;

public class ChaincodeInvocationTask
implements Callable<ChaincodeShim.ChaincodeMessage> {
    private static Logger logger = Logger.getLogger(ChaincodeInvocationTask.class.getName());
    private static Logger perfLogger = Logger.getLogger("org.hyperledger.Performance");
    private final String key;
    private final ChaincodeShim.ChaincodeMessage.Type type;
    private final String txId;
    private final Consumer<ChaincodeShim.ChaincodeMessage> outgoingMessageConsumer;
    private final ArrayBlockingQueue<ChaincodeShim.ChaincodeMessage> postbox = new ArrayBlockingQueue(2, true);
    private final ChaincodeShim.ChaincodeMessage message;
    private final Chaincode chaincode;

    public ChaincodeInvocationTask(ChaincodeShim.ChaincodeMessage message, ChaincodeShim.ChaincodeMessage.Type type, Consumer<ChaincodeShim.ChaincodeMessage> outgoingMessage, Chaincode chaincode) {
        this.key = message.getChannelId() + message.getTxid();
        this.type = type;
        this.outgoingMessageConsumer = outgoingMessage;
        this.txId = message.getTxid();
        this.chaincode = chaincode;
        this.message = message;
    }

    @Override
    public ChaincodeShim.ChaincodeMessage call() {
        ChaincodeShim.ChaincodeMessage finalResponseMessage;
        try {
            perfLogger.fine(() -> "> task:start TX::" + this.txId);
            InvocationStubImpl stub = new InvocationStubImpl(this.message, this);
            perfLogger.fine(() -> "> task:invoke TX::" + this.txId);
            Chaincode.Response result = this.type.equals((Object)ChaincodeShim.ChaincodeMessage.Type.INIT) ? this.chaincode.init(stub) : this.chaincode.invoke(stub);
            perfLogger.fine(() -> "< task:invoke TX::" + this.txId);
            if (result.getStatus().getCode() >= Chaincode.Response.Status.INTERNAL_SERVER_ERROR.getCode()) {
                logger.severe(() -> String.format("[%-8.8s] Invoke failed with error code %d. Sending %s", this.message.getTxid(), result.getStatus().getCode(), ChaincodeShim.ChaincodeMessage.Type.ERROR));
                finalResponseMessage = ChaincodeMessageFactory.newErrorEventMessage(this.message.getChannelId(), this.message.getTxid(), result.getMessage(), stub.getEvent());
            } else {
                logger.fine(() -> String.format("[%-8.8s] Invoke succeeded. Sending %s", this.message.getTxid(), ChaincodeShim.ChaincodeMessage.Type.COMPLETED));
                finalResponseMessage = ChaincodeMessageFactory.newCompletedEventMessage(this.message.getChannelId(), this.message.getTxid(), result, stub.getEvent());
            }
        }
        catch (InvalidProtocolBufferException | RuntimeException e) {
            logger.severe(() -> this.lambda$call$5((Exception)e));
            finalResponseMessage = ChaincodeMessageFactory.newErrorEventMessage(this.message.getChannelId(), this.message.getTxid(), e);
        }
        this.outgoingMessageConsumer.accept(finalResponseMessage);
        perfLogger.fine(() -> "< task:end TX::" + this.txId);
        return null;
    }

    public String getTxKey() {
        return this.key;
    }

    public boolean equals(ChaincodeInvocationTask task) {
        return this.key.equals(task.getTxKey());
    }

    public void postMessage(ChaincodeShim.ChaincodeMessage msg) throws InterruptedException {
        this.postbox.put(msg);
    }

    protected ByteString invoke(ChaincodeShim.ChaincodeMessage message) {
        ChaincodeShim.ChaincodeMessage response;
        logger.fine(() -> "Task Sending message to the peer " + message.getTxid());
        this.outgoingMessageConsumer.accept(message);
        try {
            perfLogger.fine(() -> "> task:answer TX::" + message.getTxid());
            response = this.postbox.take();
            perfLogger.fine(() -> "< task:answer TX::" + message.getTxid());
        }
        catch (InterruptedException e) {
            logger.severe(() -> "Interrupted exchanging messages ");
            throw new RuntimeException(String.format("[%-8.8s]InterruptedException received.", this.txId), e);
        }
        switch (response.getType()) {
            case RESPONSE: {
                logger.fine(() -> String.format("[%-8.8s] Successful response received.", this.txId));
                return response.getPayload();
            }
            case ERROR: {
                logger.severe(() -> String.format("[%-8.8s] Unsuccessful response received.", this.txId));
                throw new RuntimeException(String.format("[%-8.8s]Unsuccessful response received.", this.txId));
            }
        }
        logger.severe(() -> String.format("[%-8.8s] Unexpected %s response received. Expected %s or %s.", this.txId, response.getType(), ChaincodeShim.ChaincodeMessage.Type.RESPONSE, ChaincodeShim.ChaincodeMessage.Type.ERROR));
        throw new RuntimeException(String.format("[%-8.8s] Unexpected %s response received. Expected %s or %s.", this.txId, response.getType(), ChaincodeShim.ChaincodeMessage.Type.RESPONSE, ChaincodeShim.ChaincodeMessage.Type.ERROR));
    }

    private /* synthetic */ String lambda$call$5(Exception e) {
        return String.format("[%-8.8s] Invoke failed. Sending %s: %s", this.message.getTxid(), ChaincodeShim.ChaincodeMessage.Type.ERROR, e);
    }
}

