/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.ext.sbe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface StateBasedEndorsement {
    public byte[] policy();

    public void addOrgs(RoleType var1, String ... var2);

    public void delOrgs(String ... var1);

    public List<String> listOrgs();

    public static enum RoleType {
        RoleTypeMember("MEMBER"),
        RoleTypePeer("PEER");

        private final String val;
        private static Map<String, RoleType> reverseLookup;

        private RoleType(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }

        public static RoleType forVal(String val) {
            if (!reverseLookup.containsKey(val)) {
                throw new IllegalArgumentException("role type " + val + " does not exist");
            }
            return reverseLookup.get(val);
        }

        static {
            reverseLookup = new HashMap<String, RoleType>();
            for (RoleType item : RoleType.values()) {
                reverseLookup.put(item.getVal(), item);
            }
        }
    }
}

