/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ChaincodeException;

public final class ResponseUtils {
    private static Logger logger = Logger.getLogger(ResponseUtils.class.getName());

    private ResponseUtils() {
    }

    public static Chaincode.Response newSuccessResponse(String message, byte[] payload) {
        return new Chaincode.Response(Chaincode.Response.Status.SUCCESS, message, payload);
    }

    public static Chaincode.Response newSuccessResponse() {
        return ResponseUtils.newSuccessResponse(null, null);
    }

    public static Chaincode.Response newSuccessResponse(String message) {
        return ResponseUtils.newSuccessResponse(message, null);
    }

    public static Chaincode.Response newSuccessResponse(byte[] payload) {
        return ResponseUtils.newSuccessResponse(null, payload);
    }

    public static Chaincode.Response newErrorResponse(String message, byte[] payload) {
        return new Chaincode.Response(Chaincode.Response.Status.INTERNAL_SERVER_ERROR, message, payload);
    }

    public static Chaincode.Response newErrorResponse() {
        return ResponseUtils.newErrorResponse(null, null);
    }

    public static Chaincode.Response newErrorResponse(String message) {
        return ResponseUtils.newErrorResponse(message, null);
    }

    public static Chaincode.Response newErrorResponse(byte[] payload) {
        return ResponseUtils.newErrorResponse(null, payload);
    }

    public static Chaincode.Response newErrorResponse(Throwable throwable) {
        logger.error(() -> logger.formatError(throwable));
        String message = null;
        byte[] payload = null;
        if (throwable instanceof ChaincodeException) {
            message = throwable.getMessage();
            payload = ((ChaincodeException)throwable).getPayload();
        } else {
            message = "Unexpected error";
        }
        return ResponseUtils.newErrorResponse(message, payload);
    }
}

