/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hyperledger.fabric.Logging;
import org.hyperledger.fabric.contract.ContractRouter;
import org.hyperledger.fabric.metrics.Metrics;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.hyperledger.fabric.shim.ResponseUtils;
import org.hyperledger.fabric.shim.impl.ChaincodeSupportClient;
import org.hyperledger.fabric.shim.impl.InvocationTaskManager;

public abstract class ChaincodeBase
implements Chaincode {
    public static final String CORE_CHAINCODE_LOGGING_SHIM = "CORE_CHAINCODE_LOGGING_SHIM";
    public static final String CORE_CHAINCODE_LOGGING_LEVEL = "CORE_CHAINCODE_LOGGING_LEVEL";
    private static final Logger LOGGER = Logger.getLogger(ChaincodeBase.class.getName());
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 7051;
    private String host = "127.0.0.1";
    private int port = 7051;
    private boolean tlsEnabled = false;
    private String tlsClientKeyPath;
    private String tlsClientCertPath;
    private String tlsClientRootCertPath;
    private String id;
    private String localMspId = "";
    private static final String CORE_CHAINCODE_ID_NAME = "CORE_CHAINCODE_ID_NAME";
    private static final String CORE_PEER_ADDRESS = "CORE_PEER_ADDRESS";
    private static final String CORE_PEER_TLS_ENABLED = "CORE_PEER_TLS_ENABLED";
    private static final String CORE_PEER_TLS_ROOTCERT_FILE = "CORE_PEER_TLS_ROOTCERT_FILE";
    private static final String ENV_TLS_CLIENT_KEY_PATH = "CORE_TLS_CLIENT_KEY_PATH";
    private static final String ENV_TLS_CLIENT_CERT_PATH = "CORE_TLS_CLIENT_CERT_PATH";
    private static final String CORE_PEER_LOCALMSPID = "CORE_PEER_LOCALMSPID";
    private Properties props;
    private Level logLevel;
    private CCState state = CCState.CREATED;

    @Override
    public abstract Chaincode.Response init(ChaincodeStub var1);

    @Override
    public abstract Chaincode.Response invoke(ChaincodeStub var1);

    public void start(String[] args) {
        try {
            this.processEnvironmentOptions();
            this.processCommandLineOptions(args);
            this.initializeLogging();
            Properties props = this.getChaincodeConfig();
            Metrics.initialize(props);
            this.validateOptions();
            this.connectToPeer();
        }
        catch (Exception e) {
            LOGGER.severe(() -> "Chaincode could not start" + Logging.formatError(e));
        }
    }

    protected final void connectToPeer() throws IOException {
        Chaincode.ChaincodeID chaincodeId = Chaincode.ChaincodeID.newBuilder().setName(this.id).build();
        ManagedChannelBuilder<?> channelBuilder = this.newChannelBuilder();
        ChaincodeSupportClient chaincodeSupportClient = new ChaincodeSupportClient(channelBuilder);
        InvocationTaskManager itm = InvocationTaskManager.getManager(this, chaincodeId);
        chaincodeSupportClient.start(itm);
    }

    protected final void initializeLogging() {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tH:%1$tM:%1$tS:%1$tL %4$-7.7s %2$-80.80s %5$s%6$s%n");
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(Level.ALL);
            handler.setFormatter(new SimpleFormatter(){

                @Override
                public synchronized String format(LogRecord record) {
                    return Thread.currentThread() + " " + super.format(record);
                }
            });
        }
        rootLogger.info("Updated all handlers the format");
        Level chaincodeLogLevel = this.mapLevel(System.getenv(CORE_CHAINCODE_LOGGING_LEVEL));
        Package chaincodePackage = this.getClass().getPackage();
        if (chaincodePackage != null) {
            Logger.getLogger(chaincodePackage.getName()).setLevel(chaincodeLogLevel);
        } else {
            Logger.getLogger("").setLevel(chaincodeLogLevel);
        }
        Level shimLogLevel = this.mapLevel(System.getenv(CORE_CHAINCODE_LOGGING_SHIM));
        Logger.getLogger(ChaincodeBase.class.getPackage().getName()).setLevel(shimLogLevel);
        Logger.getLogger(ContractRouter.class.getPackage().getName()).setLevel(chaincodeLogLevel);
    }

    private Level mapLevel(String level) {
        if (level != null) {
            switch (level.toUpperCase().trim()) {
                case "CRITICAL": 
                case "ERROR": {
                    return Level.SEVERE;
                }
                case "WARNING": 
                case "WARN": {
                    return Level.WARNING;
                }
                case "INFO": {
                    return Level.INFO;
                }
                case "NOTICE": {
                    return Level.CONFIG;
                }
                case "DEBUG": {
                    return Level.FINEST;
                }
            }
        }
        return Level.INFO;
    }

    protected final void validateOptions() {
        if (this.id == null) {
            throw new IllegalArgumentException(String.format("The chaincode id must be specified using either the -i or --i command line options or the %s environment variable.", CORE_CHAINCODE_ID_NAME));
        }
        if (this.tlsEnabled) {
            if (this.tlsClientCertPath == null) {
                throw new IllegalArgumentException(String.format("Client key certificate chain (%s) was not specified.", ENV_TLS_CLIENT_CERT_PATH));
            }
            if (this.tlsClientKeyPath == null) {
                throw new IllegalArgumentException(String.format("Client key (%s) was not specified.", ENV_TLS_CLIENT_KEY_PATH));
            }
            if (this.tlsClientRootCertPath == null) {
                throw new IllegalArgumentException(String.format("Peer certificate trust store (%s) was not specified.", CORE_PEER_TLS_ROOTCERT_FILE));
            }
        }
    }

    protected final void processCommandLineOptions(String[] args) {
        Options options = new Options();
        options.addOption("a", "peer.address", true, "Address of peer to connect to");
        options.addOption(null, "peerAddress", true, "Address of peer to connect to");
        options.addOption("i", "id", true, "Identity of chaincode");
        try {
            CommandLine cl = new DefaultParser().parse(options, args);
            if (cl.hasOption("peerAddress") || cl.hasOption('a')) {
                String hostAddrStr = cl.hasOption('a') ? cl.getOptionValue('a') : cl.getOptionValue("peerAddress");
                String[] hostArr = hostAddrStr.split(":");
                if (hostArr.length == 2) {
                    this.port = Integer.valueOf(hostArr[1].trim());
                    this.host = hostArr[0].trim();
                } else {
                    String msg = String.format("peer address argument should be in host:port format, current %s in wrong", hostAddrStr);
                    LOGGER.severe(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            if (cl.hasOption('i')) {
                this.id = cl.getOptionValue('i');
            }
        }
        catch (Exception e) {
            LOGGER.warning(() -> "cli parsing failed with exception" + Logging.formatError(e));
        }
        LOGGER.info("<<<<<<<<<<<<<CommandLine options>>>>>>>>>>>>");
        LOGGER.info("CORE_CHAINCODE_ID_NAME: " + this.id);
        LOGGER.info("CORE_PEER_ADDRESS: " + this.host + ":" + this.port);
        LOGGER.info("CORE_PEER_TLS_ENABLED: " + this.tlsEnabled);
        LOGGER.info("CORE_PEER_TLS_ROOTCERT_FILE: " + this.tlsClientRootCertPath);
        LOGGER.info("CORE_TLS_CLIENT_KEY_PATH: " + this.tlsClientKeyPath);
        LOGGER.info("CORE_TLS_CLIENT_CERT_PATH: " + this.tlsClientCertPath);
    }

    protected final void processEnvironmentOptions() {
        if (System.getenv().containsKey(CORE_CHAINCODE_ID_NAME)) {
            this.id = System.getenv(CORE_CHAINCODE_ID_NAME);
        }
        if (System.getenv().containsKey(CORE_PEER_ADDRESS)) {
            String[] hostArr = System.getenv(CORE_PEER_ADDRESS).split(":");
            if (hostArr.length == 2) {
                this.port = Integer.valueOf(hostArr[1].trim());
                this.host = hostArr[0].trim();
            } else {
                String msg = String.format("peer address argument should be in host:port format, ignoring current %s", System.getenv(CORE_PEER_ADDRESS));
                LOGGER.severe(msg);
            }
        }
        if (System.getenv().containsKey(CORE_PEER_LOCALMSPID)) {
            this.localMspId = System.getenv(CORE_PEER_LOCALMSPID);
        }
        this.tlsEnabled = Boolean.parseBoolean(System.getenv(CORE_PEER_TLS_ENABLED));
        if (this.tlsEnabled) {
            this.tlsClientRootCertPath = System.getenv(CORE_PEER_TLS_ROOTCERT_FILE);
            this.tlsClientKeyPath = System.getenv(ENV_TLS_CLIENT_KEY_PATH);
            this.tlsClientCertPath = System.getenv(ENV_TLS_CLIENT_CERT_PATH);
        }
        LOGGER.info("<<<<<<<<<<<<<Environment options>>>>>>>>>>>>");
        LOGGER.info("CORE_CHAINCODE_ID_NAME: " + this.id);
        LOGGER.info("CORE_PEER_ADDRESS: " + this.host);
        LOGGER.info("CORE_PEER_TLS_ENABLED: " + this.tlsEnabled);
        LOGGER.info("CORE_PEER_TLS_ROOTCERT_FILE: " + this.tlsClientRootCertPath);
        LOGGER.info("CORE_TLS_CLIENT_KEY_PATH: " + this.tlsClientKeyPath);
        LOGGER.info("CORE_TLS_CLIENT_CERT_PATH: " + this.tlsClientCertPath);
        LOGGER.info("CORE_PEER_LOCALMSPID: " + this.localMspId);
        LOGGER.info("LOGLEVEL: " + this.logLevel);
    }

    public Properties getChaincodeConfig() {
        if (this.props == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.props = new Properties();
            try (InputStream inStream = cl.getResourceAsStream("config.props");){
                if (inStream != null) {
                    this.props.load(inStream);
                }
            }
            catch (IOException e) {
                LOGGER.warning(() -> "Can not open the properties file for input " + Logging.formatError(e));
            }
            this.props.setProperty(CORE_CHAINCODE_ID_NAME, this.id);
            this.props.setProperty(CORE_PEER_ADDRESS, this.host);
            LOGGER.info("<<<<<<<<<<<<<Properties options>>>>>>>>>>>>");
            LOGGER.info(() -> this.props.toString());
        }
        return this.props;
    }

    final ManagedChannelBuilder<?> newChannelBuilder() throws IOException {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)this.host, (int)this.port);
        LOGGER.info("Configuring channel connection to peer.");
        if (this.tlsEnabled) {
            builder.negotiationType(NegotiationType.TLS);
            builder.sslContext(this.createSSLContext());
        } else {
            builder.usePlaintext();
        }
        return builder;
    }

    final SslContext createSSLContext() throws IOException {
        byte[] ckb = Files.readAllBytes(Paths.get(this.tlsClientKeyPath, new String[0]));
        byte[] ccb = Files.readAllBytes(Paths.get(this.tlsClientCertPath, new String[0]));
        return GrpcSslContexts.forClient().trustManager(new File(this.tlsClientRootCertPath)).keyManager((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(ccb)), (InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(ckb))).build();
    }

    @Deprecated
    protected static Chaincode.Response newSuccessResponse(String message, byte[] payload) {
        return ResponseUtils.newSuccessResponse(message, payload);
    }

    @Deprecated
    protected static Chaincode.Response newSuccessResponse() {
        return ResponseUtils.newSuccessResponse();
    }

    @Deprecated
    protected static Chaincode.Response newSuccessResponse(String message) {
        return ResponseUtils.newSuccessResponse(message);
    }

    @Deprecated
    protected static Chaincode.Response newSuccessResponse(byte[] payload) {
        return ResponseUtils.newSuccessResponse(payload);
    }

    @Deprecated
    protected static Chaincode.Response newErrorResponse(String message, byte[] payload) {
        return ResponseUtils.newErrorResponse(message, payload);
    }

    @Deprecated
    protected static Chaincode.Response newErrorResponse() {
        return ResponseUtils.newErrorResponse();
    }

    @Deprecated
    protected static Chaincode.Response newErrorResponse(String message) {
        return ResponseUtils.newErrorResponse(message);
    }

    @Deprecated
    protected static Chaincode.Response newErrorResponse(byte[] payload) {
        return ResponseUtils.newErrorResponse(payload);
    }

    @Deprecated
    protected static Chaincode.Response newErrorResponse(Throwable throwable) {
        return ResponseUtils.newErrorResponse(throwable);
    }

    final String getHost() {
        return this.host;
    }

    final int getPort() {
        return this.port;
    }

    final boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    final String getTlsClientKeyPath() {
        return this.tlsClientKeyPath;
    }

    final String getTlsClientCertPath() {
        return this.tlsClientCertPath;
    }

    final String getTlsClientRootCertPath() {
        return this.tlsClientRootCertPath;
    }

    final String getId() {
        return this.id;
    }

    public final CCState getState() {
        return this.state;
    }

    public final void setState(CCState newState) {
        this.state = newState;
    }

    public static String toJsonString(ChaincodeShim.ChaincodeMessage message) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)message);
        }
        catch (InvalidProtocolBufferException e) {
            return String.format("{ Type: %s, TxId: %s }", message.getType(), message.getTxid());
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static enum CCState {
        CREATED,
        ESTABLISHED,
        READY;

    }
}

