/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.annotation.Contract;
import org.hyperledger.fabric.contract.annotation.Info;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.ContractDefinition;
import org.hyperledger.fabric.contract.routing.DataTypeDefinition;
import org.hyperledger.fabric.contract.routing.PropertyDefinition;
import org.hyperledger.fabric.contract.routing.RoutingRegistry;
import org.hyperledger.fabric.contract.routing.TransactionType;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class MetadataBuilder {
    private static Logger logger = Logger.getLogger(MetadataBuilder.class);
    private static Map<String, HashMap<String, Serializable>> contractMap = new HashMap<String, HashMap<String, Serializable>>();
    private static Map<String, Object> overallInfoMap = new HashMap<String, Object>();
    private static Map<String, Object> componentMap = new HashMap<String, Object>();
    private static SchemaClient schemaClient = new DefaultSchemaClient();
    private static final int PADDING = 3;

    private MetadataBuilder() {
    }

    public static void validate() {
        logger.info("Running schema test validation");
        ClassLoader cl = MetadataBuilder.class.getClassLoader();
        try (InputStream contractSchemaInputStream = cl.getResourceAsStream("contract-schema.json");
             InputStream jsonSchemaInputStream = cl.getResourceAsStream("json-schema-draft-04-schema.json");){
            JSONObject rawContractSchema = new JSONObject(new JSONTokener(contractSchemaInputStream));
            JSONObject rawJsonSchema = new JSONObject(new JSONTokener(jsonSchemaInputStream));
            SchemaLoader schemaLoader = SchemaLoader.builder().schemaClient(schemaClient).schemaJson(rawContractSchema).registerSchemaByURI(URI.create("http://json-schema.org/draft-04/schema"), (Object)rawJsonSchema).build();
            Schema schema = schemaLoader.load().build();
            schema.validate((Object)MetadataBuilder.metadata());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ValidationException e) {
            logger.error(e.getMessage());
            e.getCausingExceptions().stream().map(ValidationException::getMessage).forEach(logger::info);
            logger.error(MetadataBuilder.debugString());
            throw e;
        }
    }

    public static void initialize(RoutingRegistry registry, TypeRegistry typeRegistry) {
        Collection<ContractDefinition> contractDefinitions = registry.getAllDefinitions();
        contractDefinitions.forEach(MetadataBuilder::addContract);
        Collection<DataTypeDefinition> dataTypes = typeRegistry.getAllDataTypes();
        dataTypes.forEach(MetadataBuilder::addComponent);
        logger.info("Validating schema created");
        MetadataBuilder.validate();
    }

    public static void addComponent(DataTypeDefinition datatype) {
        HashMap<String, Object> component = new HashMap<String, Object>();
        component.put("$id", datatype.getName());
        component.put("type", "object");
        component.put("additionalProperties", false);
        Map<String, TypeSchema> propertiesMap = datatype.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PropertyDefinition)e.getValue()).getSchema()));
        component.put("properties", propertiesMap);
        componentMap.put(datatype.getSimpleName(), component);
    }

    public static String addContract(ContractDefinition contractDefinition) {
        String key = contractDefinition.getName();
        Contract annotation = contractDefinition.getAnnotation();
        final Info info = annotation.info();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("title", info.title());
        infoMap.put("description", info.description());
        infoMap.put("termsOfService", info.termsOfService());
        infoMap.put("contact", new MetadataMap<String, String>(){
            {
                this.putIfNotNull("email", info.contact().email());
                this.putIfNotNull("name", info.contact().name());
                this.putIfNotNull("url", info.contact().url());
            }
        });
        infoMap.put("license", new MetadataMap<String, String>(){
            {
                this.put("name", info.license().name());
                this.putIfNotNull("url", info.license().url());
            }
        });
        infoMap.put("version", info.version());
        HashMap<String, Object> contract = new HashMap<String, Object>();
        contract.put("name", key);
        contract.put("transactions", new ArrayList());
        contract.put("info", infoMap);
        contractMap.put(key, contract);
        boolean defaultContract = true;
        overallInfoMap.putAll(infoMap);
        Collection<TxFunction> fns = contractDefinition.getTxFunctions();
        fns.forEach(txFn -> MetadataBuilder.addTransaction(txFn, key));
        return key;
    }

    public static void addTransaction(TxFunction txFunction, String contractName) {
        TypeSchema transaction = new TypeSchema();
        TypeSchema returnSchema = txFunction.getReturnSchema();
        if (returnSchema != null) {
            transaction.put("returns", returnSchema);
        }
        ArrayList<TransactionType> tags = new ArrayList<TransactionType>();
        tags.add(txFunction.getType());
        Map contract = contractMap.get(contractName);
        ArrayList txs = (ArrayList)contract.get("transactions");
        ArrayList paramsList = new ArrayList();
        txFunction.getParamsList().forEach(pd -> {
            TypeSchema paramMap = pd.getSchema();
            paramMap.put("name", pd.getName());
            paramsList.add(paramMap);
        });
        transaction.put("parameters", paramsList);
        if (tags.size() != 0) {
            transaction.put("tags", tags.toArray());
            transaction.put("name", txFunction.getName());
            txs.add(transaction);
        }
    }

    public static String getMetadata() {
        return MetadataBuilder.metadata().toString();
    }

    public static String debugString() {
        return MetadataBuilder.metadata().toString(3);
    }

    private static JSONObject metadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("$schema", "https://fabric-shim.github.io/release-1.4/contract-schema.json");
        metadata.put("info", overallInfoMap);
        metadata.put("contracts", contractMap);
        metadata.put("components", Collections.singletonMap("schemas", componentMap));
        JSONObject joMetadata = new JSONObject(metadata);
        return joMetadata;
    }

    public static Map<?, ?> getComponents() {
        return componentMap;
    }

    static class MetadataMap<K, V>
    extends HashMap<K, V> {
        MetadataMap() {
        }

        V putIfNotNull(K key, V value) {
            logger.info(key + " " + value);
            if (value != null && !value.toString().isEmpty()) {
                return this.put(key, value);
            }
            return null;
        }
    }
}

