/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.SerializerInterface;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.DataTypeDefinition;
import org.hyperledger.fabric.contract.routing.PropertyDefinition;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Serializer
public class JSONTransactionSerializer
implements SerializerInterface {
    private static Logger logger = Logger.getLogger(JSONTransactionSerializer.class.getName());
    private final TypeRegistry typeRegistry = TypeRegistry.getRegistry();

    @Override
    public byte[] toBuffer(Object value, TypeSchema ts) {
        logger.debug(() -> "Schema to convert is " + ts);
        byte[] buffer = null;
        if (value != null) {
            String type = ts.getType();
            if (type != null) {
                switch (type) {
                    case "array": {
                        JSONArray array = this.normalizeArray(new JSONArray(value), ts);
                        buffer = array.toString().getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    case "string": {
                        String format = ts.getFormat();
                        if (format != null && format.contentEquals("uint16")) {
                            buffer = Character.valueOf(((Character)value).charValue()).toString().getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        buffer = ((String)value).getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    default: {
                        buffer = value.toString().getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                }
            } else {
                DataTypeDefinition dtd = this.typeRegistry.getDataType(ts);
                Set<String> keySet = dtd.getProperties().keySet();
                String[] propNames = keySet.toArray(new String[keySet.size()]);
                JSONObject obj = new JSONObject(new JSONObject(value), propNames);
                buffer = obj.toString().getBytes(StandardCharsets.UTF_8);
            }
        }
        return buffer;
    }

    private JSONArray normalizeArray(JSONArray jsonArray, TypeSchema ts) {
        JSONArray normalizedArray;
        TypeSchema items = ts.getItems();
        String type = items.getType();
        if (type != null && type != "array") {
            normalizedArray = jsonArray;
        } else if (type != null && type == "array") {
            normalizedArray = new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                normalizedArray.put(i, (Object)this.normalizeArray(jsonArray.getJSONArray(i), items));
            }
        } else {
            DataTypeDefinition dtd = this.typeRegistry.getDataType(items);
            Set<String> keySet = dtd.getProperties().keySet();
            String[] propNames = keySet.toArray(new String[keySet.size()]);
            normalizedArray = new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = new JSONObject(jsonArray.getJSONObject(i), propNames);
                normalizedArray.put(i, (Object)obj);
            }
        }
        return normalizedArray;
    }

    @Override
    public Object fromBuffer(byte[] buffer, TypeSchema ts) {
        try {
            String stringData = new String(buffer, StandardCharsets.UTF_8);
            Object value = null;
            value = this.convert(stringData, ts);
            return value;
        }
        catch (IllegalAccessException | InstantiationException e) {
            ContractRuntimeException cre = new ContractRuntimeException(e);
            throw cre;
        }
    }

    private Class<?> mapPrimitive(Class<?> primitive) {
        boolean isArray = primitive.isArray();
        String primitiveType = isArray ? primitive.getComponentType().getName() : primitive.getName();
        switch (primitiveType) {
            case "int": {
                return isArray ? Integer[].class : Integer.class;
            }
            case "long": {
                return isArray ? Long[].class : Long.class;
            }
            case "float": {
                return isArray ? Float[].class : Float.class;
            }
            case "double": {
                return isArray ? Double[].class : Double.class;
            }
            case "short": {
                return isArray ? Short[].class : Short.class;
            }
            case "byte": {
                return isArray ? Byte[].class : Byte.class;
            }
            case "char": {
                return isArray ? Character[].class : Character.class;
            }
            case "boolean": {
                return isArray ? Boolean[].class : Boolean.class;
            }
        }
        return primitive;
    }

    private Object convert(String stringData, TypeSchema ts) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        logger.debug(() -> "Schema to convert is " + ts);
        String type = ts.getType();
        String format = null;
        Object value = null;
        if (type == null) {
            type = "object";
            String ref = ts.getRef();
            format = ref.substring(ref.lastIndexOf("/") + 1);
        }
        if (type.contentEquals("string")) {
            String strformat = ts.getFormat();
            value = strformat != null && strformat.contentEquals("uint16") ? Character.valueOf(stringData.charAt(0)) : stringData;
        } else if (type.contentEquals("integer")) {
            String intFormat;
            switch (intFormat = ts.getFormat()) {
                case "int32": {
                    value = Integer.parseInt(stringData);
                    break;
                }
                case "int8": {
                    value = Byte.parseByte(stringData);
                    break;
                }
                case "int16": {
                    value = Short.parseShort(stringData);
                    break;
                }
                case "int64": {
                    value = Long.parseLong(stringData);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown format for integer " + intFormat);
                }
            }
        } else if (type.contentEquals("number")) {
            String numFormat = ts.getFormat();
            value = numFormat.contentEquals("float") ? (Number)Float.valueOf(Float.parseFloat(stringData)) : (Number)Double.parseDouble(stringData);
        } else if (type.contentEquals("boolean")) {
            value = Boolean.parseBoolean(stringData);
        } else if (type.contentEquals("object")) {
            value = this.createComponentInstance(format, stringData, ts);
        } else if (type.contentEquals("array")) {
            JSONArray jsonArray = new JSONArray(stringData);
            TypeSchema itemSchema = ts.getItems();
            Object[] data = (Object[])Array.newInstance(this.mapPrimitive(itemSchema.getTypeClass(this.typeRegistry)), jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object convertedData;
                data[i] = convertedData = this.convert(jsonArray.get(i).toString(), itemSchema);
            }
            value = data;
        }
        return value;
    }

    Object createComponentInstance(String format, String jsonString, TypeSchema ts) {
        Object obj;
        DataTypeDefinition dtd = this.typeRegistry.getDataType(format);
        try {
            obj = dtd.getTypeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
            throw new ContractRuntimeException("Unable to to create new instance of type", e1);
        }
        JSONObject json = new JSONObject(jsonString);
        ts.validate(json);
        try {
            Map<String, PropertyDefinition> fields = dtd.getProperties();
            for (PropertyDefinition prop : fields.values()) {
                Field f = prop.getField();
                f.setAccessible(true);
                Object newValue = this.convert(json.get(prop.getName()).toString(), prop.getSchema());
                f.set(obj, newValue);
            }
            return obj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | JSONException e) {
            throw new ContractRuntimeException("Unable to convert JSON to object", e);
        }
    }
}

