/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract;

import java.util.Properties;
import java.util.logging.Logger;
import org.hyperledger.fabric.Logging;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.ExecutionFactory;
import org.hyperledger.fabric.contract.execution.ExecutionService;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.contract.execution.SerializerInterface;
import org.hyperledger.fabric.contract.metadata.MetadataBuilder;
import org.hyperledger.fabric.contract.routing.ContractDefinition;
import org.hyperledger.fabric.contract.routing.RoutingRegistry;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.hyperledger.fabric.contract.routing.impl.RoutingRegistryImpl;
import org.hyperledger.fabric.contract.routing.impl.SerializerRegistryImpl;
import org.hyperledger.fabric.metrics.Metrics;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ChaincodeBase;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.hyperledger.fabric.shim.ResponseUtils;

public final class ContractRouter
extends ChaincodeBase {
    private static Logger logger = Logger.getLogger(ContractRouter.class.getName());
    private final RoutingRegistry registry;
    private final TypeRegistry typeRegistry;
    private final SerializerRegistryImpl serializers;

    public ContractRouter(String[] args) {
        super.processEnvironmentOptions();
        super.processCommandLineOptions(args);
        Properties props = super.getChaincodeConfig();
        Metrics.initialize(props);
        super.validateOptions();
        logger.fine("ContractRouter<init>");
        this.registry = new RoutingRegistryImpl();
        this.typeRegistry = TypeRegistry.getRegistry();
        this.serializers = new SerializerRegistryImpl();
        try {
            this.serializers.findAndSetContents();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ContractRuntimeException cre = new ContractRuntimeException("Unable to locate Serializers", e);
            logger.severe(() -> Logging.formatError(cre));
            throw new RuntimeException(cre);
        }
    }

    protected void findAllContracts() {
        this.registry.findAndSetContracts(this.typeRegistry);
    }

    void startRouting() {
        try {
            super.connectToPeer();
        }
        catch (Exception e) {
            ContractRuntimeException cre = new ContractRuntimeException("Unable to start routing");
            logger.severe(() -> Logging.formatError(cre));
            throw cre;
        }
    }

    private Chaincode.Response processRequest(ChaincodeStub stub) {
        logger.info(() -> "Got invoke routing request");
        try {
            if (stub.getStringArgs().size() > 0) {
                logger.info(() -> "Got the invoke request for:" + stub.getFunction() + " " + stub.getParameters());
                InvocationRequest request = ExecutionFactory.getInstance().createRequest(stub);
                TxFunction txFn = this.getRouting(request);
                SerializerInterface si = this.serializers.getSerializer(txFn.getRouting().getSerializerName(), Serializer.TARGET.TRANSACTION);
                ExecutionService executor = ExecutionFactory.getInstance().createExecutionService(si);
                logger.info(() -> "Got routing:" + txFn.getRouting());
                return executor.executeRequest(txFn, request, stub);
            }
            return ResponseUtils.newSuccessResponse();
        }
        catch (Throwable throwable) {
            return ResponseUtils.newErrorResponse(throwable);
        }
    }

    @Override
    public Chaincode.Response invoke(ChaincodeStub stub) {
        return this.processRequest(stub);
    }

    @Override
    public Chaincode.Response init(ChaincodeStub stub) {
        return this.processRequest(stub);
    }

    TxFunction getRouting(InvocationRequest request) {
        if (this.registry.containsRoute(request)) {
            return this.registry.getTxFn(request);
        }
        logger.fine(() -> "Namespace is " + request);
        ContractDefinition contract = this.registry.getContract(request.getNamespace());
        return contract.getUnknownRoute();
    }

    public static void main(String[] args) {
        ContractRouter cfc = new ContractRouter(args);
        cfc.findAllContracts();
        logger.fine(cfc.getRoutingRegistry().toString());
        MetadataBuilder.initialize(cfc.getRoutingRegistry(), cfc.getTypeRegistry());
        logger.info(() -> "Metadata follows:" + MetadataBuilder.debugString());
        cfc.startRouting();
    }

    protected TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    protected RoutingRegistry getRoutingRegistry() {
        return this.registry;
    }
}

