/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractRouter;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.json.JSONException;
import org.json.JSONObject;

public final class ClientIdentity {
    private static Logger logger = Logger.getLogger(ContractRouter.class.getName());
    private final String mspId;
    private final X509Certificate cert;
    private Map<String, String> attrs;
    private final String id;
    private static final String FABRIC_CERT_ATTR_OID = "1.2.3.4.5.6.7.8.1";

    public ClientIdentity(ChaincodeStub stub) throws CertificateException, JSONException, IOException {
        X509Certificate cert;
        byte[] signingId = stub.getCreator();
        Identities.SerializedIdentity si = Identities.SerializedIdentity.parseFrom((byte[])signingId);
        this.mspId = si.getMspid();
        byte[] idBytes = si.getIdBytes().toByteArray();
        this.cert = cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(idBytes));
        this.attrs = new HashMap<String, String>();
        byte[] extensionValue = cert.getExtensionValue(FABRIC_CERT_ATTR_OID);
        if (extensionValue != null) {
            this.attrs = this.parseAttributes(extensionValue);
        }
        this.id = "x509::" + cert.getSubjectDN().getName() + "::" + cert.getIssuerDN().getName();
    }

    public String getId() {
        return this.id;
    }

    public String getMSPID() {
        return this.mspId;
    }

    private Map<String, String> parseAttributes(byte[] extensionValue) throws IOException {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(extensionValue);
             ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)inStream);){
            ASN1Primitive derObject = asn1InputStream.readObject();
            if (derObject instanceof DEROctetString) {
                DEROctetString derOctetString = (DEROctetString)derObject;
                String attributeString = new String(derOctetString.getOctets(), StandardCharsets.UTF_8);
                JSONObject extJSON = new JSONObject(attributeString);
                JSONObject attrs = extJSON.getJSONObject("attrs");
                Iterator keys = attrs.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    attrMap.put(key, attrs.getString(key));
                }
            }
        }
        catch (JSONException error) {
            logger.error(() -> logger.formatError(error));
        }
        return attrMap;
    }

    public String getAttributeValue(String attrName) {
        if (this.attrs.containsKey(attrName)) {
            return this.attrs.get(attrName);
        }
        return null;
    }

    public boolean assertAttributeValue(String attrName, String attrValue) {
        if (!this.attrs.containsKey(attrName)) {
            return false;
        }
        return attrValue.equals(this.attrs.get(attrName));
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }
}

