/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitUtils {
    public static final String DEFAULD_REPO_NAME = "origin";
    IGitAPI git;
    TaskListener listener;
    private static final Logger LOGGER = Logger.getLogger(GitUtils.class.getName());

    public GitUtils(TaskListener listener, IGitAPI git) {
        this.git = git;
        this.listener = listener;
    }

    public Collection<Revision> getAllBranchRevisions() throws GitException, IOException {
        HashMap<ObjectId, Revision> revisions = new HashMap<ObjectId, Revision>();
        List<Branch> branches = this.git.getRemoteBranches();
        for (Branch b : branches) {
            Revision r = (Revision)revisions.get(b.getSHA1());
            if (r == null) {
                r = new Revision(b.getSHA1());
                revisions.put(b.getSHA1(), r);
            }
            r.getBranches().add(b);
        }
        return revisions.values();
    }

    public Revision getRevisionContainingBranch(String branchName) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            for (Branch b : revision.getBranches()) {
                if (!b.getName().equals(branchName)) continue;
                return revision;
            }
        }
        return null;
    }

    public Revision getRevisionForSHA1(ObjectId sha1) throws GitException, IOException {
        for (Revision revision : this.getAllBranchRevisions()) {
            if (!revision.getSha1().equals((AnyObjectId)sha1)) continue;
            return revision;
        }
        return null;
    }

    public Collection<Revision> filterTipBranches(Collection<Revision> revisions) {
        ArrayList<Revision> l = new ArrayList<Revision>(revisions);
        block0: for (int i = 0; i < l.size(); ++i) {
            for (int j = i + 1; j < l.size(); ++j) {
                Revision ri = (Revision)l.get(i);
                Revision rj = (Revision)l.get(j);
                ObjectId commonAncestor = this.git.mergeBase(ri.getSha1(), rj.getSha1());
                if (commonAncestor == null) continue;
                if (commonAncestor.equals((AnyObjectId)ri.getSha1())) {
                    LOGGER.fine("filterTipBranches: " + rj + " subsumes " + ri);
                    l.remove(i);
                    --i;
                    continue block0;
                }
                if (!commonAncestor.equals((AnyObjectId)rj.getSha1())) continue;
                LOGGER.fine("filterTipBranches: " + ri + " subsumes " + rj);
                l.remove(j);
                --j;
            }
        }
        return l;
    }

    public static EnvVars getPollEnvironment(AbstractProject p, FilePath ws, Launcher launcher, TaskListener listener, boolean pollSlaves) throws IOException, InterruptedException {
        EnvVars env;
        AbstractBuild b;
        AbstractBuild abstractBuild = b = pollSlaves ? (AbstractBuild)p.getLastBuild() : null;
        if (b != null) {
            Environment environment;
            Node lastBuiltOn = b.getBuiltOn();
            env = lastBuiltOn != null ? lastBuiltOn.toComputer().getEnvironment().overrideAll((Map)b.getCharacteristicEnvVars()) : new EnvVars(System.getenv());
            String rootUrl = Hudson.getInstance().getRootUrl();
            if (rootUrl != null) {
                env.put("HUDSON_URL", rootUrl);
                env.put("BUILD_URL", rootUrl + b.getUrl());
                env.put("JOB_URL", rootUrl + p.getUrl());
            }
            if (!env.containsKey((Object)"HUDSON_HOME")) {
                env.put("HUDSON_HOME", Hudson.getInstance().getRootDir().getPath());
            }
            if (ws != null) {
                env.put("WORKSPACE", ws.getRemote());
            }
            p.getScm().buildEnvVars(b, (Map)env);
            StreamBuildListener buildListener = new StreamBuildListener((OutputStream)listener.getLogger());
            for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
                if (environment == null) continue;
                environment.buildEnvVars((Map)env);
            }
            if (lastBuiltOn != null) {
                for (NodeProperty nodeProperty : lastBuiltOn.getNodeProperties()) {
                    environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
                    if (environment == null) continue;
                    environment.buildEnvVars((Map)env);
                }
            }
            EnvVars.resolve((Map)env);
        } else {
            env = new EnvVars(System.getenv());
        }
        return env;
    }

    public static void buildBranchEnvVar(AbstractBuild<?, ?> build, Map<String, String> env, List<RemoteConfig> repositories, List<BranchSpec> branches) {
        if (CollectionUtils.isNotEmpty(repositories) && CollectionUtils.isNotEmpty(branches)) {
            int branchesSize = branches.size();
            int repoSize = repositories.size();
            if (1 == branchesSize && 1 == repoSize) {
                String branch = GitUtils.getSingleBranch(build, repositories, branches);
                if (branch != null) {
                    env.put("GIT_BRANCH", branch);
                }
            } else if (branchesSize > 1 || repoSize > 1) {
                int repoIdx = 1;
                int branchIdx = 1;
                for (RemoteConfig repo : repositories) {
                    for (BranchSpec branchSpec : branches) {
                        String branchName = GitUtils.buildBranch(build, repo.getName(), branchSpec.getName());
                        if (null == branchName) continue;
                        String key = "GIT_BRANCH_" + repoIdx + "_" + branchIdx;
                        env.put(key, repo.getName() + "/" + branchName);
                        ++branchIdx;
                    }
                    ++repoIdx;
                    branchIdx = 1;
                }
            }
        }
    }

    public static String getSingleBranch(AbstractBuild<?, ?> build, List<RemoteConfig> repositories, List<BranchSpec> branches) {
        if (branches.size() != 1 || repositories.size() != 1) {
            return null;
        }
        String branch = branches.get(0).getName();
        String repository = repositories.get(0).getName();
        return GitUtils.buildBranch(build, repository, branch);
    }

    public static String buildBranch(AbstractBuild<?, ?> build, String repository, String branchName) {
        if (branchName.startsWith("*/")) {
            branchName = repository + branchName.substring(1);
        }
        if (branchName.contains("*")) {
            return null;
        }
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branchName = parameters.substitute(build, branchName);
        }
        return branchName;
    }

    public static String[] fixupNames(String[] names, String[] urls) {
        String[] returnNames = new String[urls.length];
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String name = names[i];
            if (name == null || name.trim().length() == 0) {
                name = DEFAULD_REPO_NAME;
            }
            String baseName = name;
            int j = 1;
            while (usedNames.contains(name)) {
                name = baseName + j++;
            }
            usedNames.add(name);
            returnNames[i] = name;
        }
        return returnNames;
    }

    public static boolean isEmpty(String[] urls) {
        if (ArrayUtils.isEmpty((Object[])urls)) {
            return true;
        }
        for (String url : urls) {
            if (!StringUtils.isNotEmpty((String)url)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualCollection(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection((Collection)c1, (Collection)c2);
    }

    public static boolean isEqualArray(Object[] o1, Object[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(Arrays.asList(o1), Arrays.asList(o2));
    }
}

