/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.thoughtworks.xstream.converters.Converter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitRepository;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.converter.ObjectIdConverter;
import hudson.plugins.git.converter.RemoteConfigConverter;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    private static final long serialVersionUID = 1L;
    static final String DEFAULT_BRANCH = "master";
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private String localBranch;
    private PreBuildMergeOptions mergeOptions;
    private boolean recursiveSubmodules;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean authorOrCommitter;
    private boolean clean;
    private boolean wipeOutWorkspace;
    private boolean pruneBranches;
    private boolean remotePoll;
    private boolean ignoreNotifyCommit;
    private transient String choosingStrategy;
    private BuildChooser buildChooser;
    private String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    @Deprecated
    private String relativeTargetDir;
    private String includedRegions;
    private String excludedRegions;
    private String excludedUsers;
    private Set<String> excludedCommits = new HashSet<String>();
    private String gitConfigName;
    private String gitConfigEmail;
    private boolean skipTag;
    private boolean useCgitClone;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    public GitSCM(String repositoryUrl) throws IOException, Descriptor.FormException {
        this(DescriptorImpl.createRepositoryConfigurations(new String[]{repositoryUrl}, new String[]{null}, new String[]{null}), Collections.singletonList(new BranchSpec("")), new PreBuildMergeOptions(), false, Collections.emptyList(), false, false, new DefaultBuildChooser(), null, null, false, null, null, null, false, false, false, null, null, false, null, false);
    }

    @Deprecated
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, boolean remotePoll, String gitConfigName, String gitConfigEmail, boolean skipTag) {
        this(repositories, branches, mergeOptions, doGenerateSubmoduleConfigurations, submoduleCfg, clean, wipeOutWorkspace, buildChooser, browser, gitTool, authorOrCommitter, excludedRegions, excludedUsers, localBranch, recursiveSubmodules, pruneBranches, remotePoll, gitConfigName, gitConfigEmail, skipTag, null, false);
        this.relativeTargetDir = relativeTargetDir;
    }

    @Deprecated
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, boolean remotePoll, String gitConfigName, String gitConfigEmail, boolean skipTag) {
        this(repositories, branches, mergeOptions, doGenerateSubmoduleConfigurations, submoduleCfg, clean, wipeOutWorkspace, buildChooser, browser, gitTool, authorOrCommitter, excludedRegions, excludedUsers, localBranch, recursiveSubmodules, pruneBranches, remotePoll, gitConfigName, gitConfigEmail, skipTag, null, false);
    }

    @Deprecated
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, boolean remotePoll, String gitConfigName, String gitConfigEmail, boolean skipTag, String includedRegions) {
        this(repositories, branches, mergeOptions, doGenerateSubmoduleConfigurations, submoduleCfg, clean, wipeOutWorkspace, buildChooser, browser, gitTool, authorOrCommitter, excludedRegions, excludedUsers, localBranch, recursiveSubmodules, pruneBranches, remotePoll, gitConfigName, gitConfigEmail, skipTag, includedRegions, false);
    }

    @DataBoundConstructor
    public GitSCM(List<RemoteConfig> repositories, List<BranchSpec> branches, PreBuildMergeOptions mergeOptions, boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String excludedRegions, String excludedUsers, String localBranch, boolean recursiveSubmodules, boolean pruneBranches, boolean remotePoll, String gitConfigName, String gitConfigEmail, boolean skipTag, String includedRegions, boolean ignoreNotifyCommit) {
        this.branches = branches;
        this.localBranch = Util.fixEmptyAndTrim((String)localBranch);
        this.remoteRepositories = repositories;
        this.browser = browser;
        this.mergeOptions = mergeOptions;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations;
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.wipeOutWorkspace = wipeOutWorkspace;
        this.configVersion = 1L;
        this.gitTool = gitTool;
        this.authorOrCommitter = authorOrCommitter;
        this.buildChooser = buildChooser;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.recursiveSubmodules = recursiveSubmodules;
        this.pruneBranches = pruneBranches;
        this.ignoreNotifyCommit = ignoreNotifyCommit;
        if (remotePoll && (branches.size() != 1 || branches.get(0).getName().contains("*") || this.getRepositories().size() != 1 || excludedRegions != null && excludedRegions.length() > 0 || submoduleCfg.size() != 0 || excludedUsers != null && excludedUsers.length() > 0)) {
            LOGGER.log(Level.WARNING, "Cannot poll remotely with current configuration.");
            this.remotePoll = false;
        } else {
            this.remotePoll = remotePoll;
        }
        this.gitConfigName = gitConfigName;
        this.gitConfigEmail = gitConfigEmail;
        this.skipTag = skipTag;
        this.includedRegions = includedRegions;
        buildChooser.gitSCM = this;
        this.excludedCommits = new HashSet<String>();
    }

    public void setUseCgitClone(boolean useCgitClone) {
        this.useCgitClone = useCgitClone;
    }

    public boolean getUseCgitClone() {
        return this.useCgitClone;
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.recursiveSubmodules = false;
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*"), ""));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec(DEFAULT_BRANCH));
            }
        }
        for (RemoteConfig remoteConfig : this.remoteRepositories) {
            ArrayList<URIish> gitUrisToAdd = new ArrayList<URIish>();
            ArrayList<URIish> urisToRemove = new ArrayList<URIish>();
            boolean needMigration = false;
            for (URIish gitUri : remoteConfig.getURIs()) {
                if (gitUri.getRawPath() == null) {
                    try {
                        gitUrisToAdd.add(gitUri.setRawPath(gitUri.getPath()));
                        needMigration = true;
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.WARNING, "Failed to set RawPath", ex);
                    }
                } else {
                    gitUrisToAdd.add(gitUri);
                }
                urisToRemove.add(gitUri);
            }
            if (!needMigration) continue;
            for (URIish gitUri : urisToRemove) {
                remoteConfig.removeURI(gitUri);
            }
            for (URIish gitUri : gitUrisToAdd) {
                remoteConfig.addURI(gitUri);
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote(this.remoteRepositories.get(0));
        }
        if (this.choosingStrategy != null && this.buildChooser == null) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.buildChooser = (BuildChooser)d.clazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        if (this.buildChooser == null) {
            this.buildChooser = new DefaultBuildChooser();
        }
        this.buildChooser.gitSCM = this;
        return this;
    }

    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return StringUtils.isBlank((String)this.includedRegions) ? null : this.includedRegions.split("[\\r\\n]+");
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public Set<String> getExcludedCommits() {
        return this.excludedCommits;
    }

    public boolean addExcludedCommit(String sha1) {
        if (this.excludedCommits == null) {
            this.excludedCommits = new HashSet<String>();
        }
        return this.excludedCommits.add(sha1);
    }

    public String[] getExcludedRegionsNormalized() {
        return StringUtils.isBlank((String)this.excludedRegions) ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getGitConfigName() {
        return this.gitConfigName;
    }

    public String getGitConfigEmail() {
        return this.gitConfigEmail;
    }

    public String getGitConfigNameToUse() {
        String globalConfigName = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigName();
        String confName = this.gitConfigName == null && StringUtils.isNotBlank((String)globalConfigName) ? globalConfigName : this.gitConfigName;
        return Util.fixEmptyAndTrim((String)confName);
    }

    public boolean isPollSlaves() {
        return ((DescriptorImpl)this.getDescriptor()).isPollSlaves();
    }

    public String getGitConfigEmailToUse() {
        String globalConfigEmail = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigEmail();
        String confEmail = this.gitConfigEmail == null && StringUtils.isNotBlank((String)globalConfigEmail) ? globalConfigEmail : this.gitConfigEmail;
        return Util.fixEmptyAndTrim((String)confEmail);
    }

    public boolean isCreateAccountBaseOnCommitterEmail() {
        DescriptorImpl gitDescriptor = (DescriptorImpl)this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isCreateAccountBaseOnCommitterEmail();
    }

    public boolean getSkipTag() {
        return this.skipTag;
    }

    public boolean getPruneBranches() {
        return this.pruneBranches;
    }

    public boolean getRemotePoll() {
        return this.remotePoll;
    }

    public boolean getWipeOutWorkspace() {
        return this.wipeOutWorkspace;
    }

    public boolean getClean() {
        return this.clean;
    }

    public BuildChooser getBuildChooser() {
        return this.buildChooser;
    }

    public boolean isIgnoreNotifyCommit() {
        return this.ignoreNotifyCommit;
    }

    public List<RemoteConfig> getParamExpandedRepos(AbstractBuild<?, ?> build) {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.newRemoteConfig(oldRepo.getName(), ((URIish)oldRepo.getURIs().get(0)).toPrivateString(), new RefSpec(this.getRefSpec(oldRepo, build)), this.getRemoteConfigTargetDir(oldRepo)));
        }
        return expandedRepos;
    }

    public boolean requiresWorkspaceForPolling() {
        return !this.remotePoll && this.isPollSlaves();
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> abstractBuild, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public RemoteConfig getSubmoduleRepository(IGitAPI parentGit, RemoteConfig orig, String name) throws GitException {
        String refUrl = parentGit.getSubmoduleUrl(name);
        return this.newRemoteConfig(name, refUrl, (RefSpec)orig.getFetchRefSpecs().get(0), "");
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        GitTool[] gitToolInstallations;
        for (GitTool t : gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()) {
            if (this.gitTool == null) {
                this.gitTool = t.getName();
            }
            if (!t.getName().equals(this.gitTool) || builtOn == null) continue;
            try {
                String s = t.forNode(builtOn, listener).getGitExe();
                return s;
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        return null;
    }

    public boolean getAuthorOrCommitter() {
        return this.authorOrCommitter;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        String confEmail;
        BuildConfig buildConfig = null;
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        int buildNumber = build.getNumber();
        String gitExe = this.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        listener.getLogger().println("Git Exe: " + gitExe);
        String internalTagName = "hudson" + "-" + build.getProject().getName() + "-" + build.getNumber();
        String internalTagComment = "Hudson Build #" + build.getNumber();
        BuildData buildData = this.getBuildData((Run)build.getPreviousBuild(), true);
        if (buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        String confName = this.getGitConfigNameToUse();
        if (StringUtils.isNotBlank((String)confName)) {
            environment.put("GIT_COMMITTER_NAME", confName);
            environment.put("GIT_AUTHOR_NAME", confName);
        }
        if (StringUtils.isNotBlank((String)(confEmail = this.getGitConfigEmailToUse()))) {
            environment.put("GIT_COMMITTER_EMAIL", confEmail);
            environment.put("GIT_AUTHOR_EMAIL", confEmail);
        }
        String singleBranch = GitUtils.getSingleBranch(build, this.getRepositories(), this.getBranches());
        String paramLocalBranch = this.getParamLocalBranch(build);
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = (BuildData)parentBuild.getAction(BuildData.class)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        List<RemoteConfig> paramRepos = this.getParamExpandedRepos(build);
        Revision parentLastBuiltRev = tempParentLastBuiltRev;
        RevisionParameterAction rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
        Map<String, List<RemoteConfig>> repoMap = this.getRemoteConfigMap(paramRepos);
        boolean result = true;
        boolean hasChanges = false;
        for (Map.Entry<String, List<RemoteConfig>> entry : repoMap.entrySet()) {
            List<RemoteConfig> repos;
            Revision revToBuild;
            FilePath workingDirectory = this.workingDirectory(workspace);
            if (StringUtils.isNotEmpty((String)entry.getKey()) && !entry.getKey().equals(".")) {
                workingDirectory = workingDirectory.child(entry.getKey());
            }
            if (!workingDirectory.exists()) {
                workingDirectory.mkdirs();
            }
            if ((revToBuild = this.gerRevisionToBuild(listener, workingDirectory, gitExe, buildData, environment, singleBranch, repos = entry.getValue(), parentLastBuiltRev, rpa)) == null) {
                listener.getLogger().println("Nothing to do");
                continue;
            }
            hasChanges = true;
            listener.getLogger().println("Commencing build of " + revToBuild);
            environment.put(GIT_COMMIT, revToBuild.getSha1String());
            if (this.mergeOptions.doMerge() && !revToBuild.containsBranchName(this.mergeOptions.getRemoteBranchName())) {
                buildConfig = this.getMergedBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, revToBuild, internalTagName, internalTagComment);
                result = result && this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
                continue;
            }
            buildConfig = this.getBuildConfig(listener, workingDirectory, buildNumber, gitExe, buildData, environment, paramLocalBranch, repos, revToBuild, internalTagName, internalTagComment);
            result = result && this.changeLogResult(buildConfig.getChangeLog(), changelogFile);
        }
        if (null != buildConfig) {
            build.addAction((Action)buildConfig.getBuildData());
        }
        if (!hasChanges) {
            return this.changeLogResult(null, changelogFile);
        }
        return result;
    }

    private BuildConfig getBuildConfig(final BuildListener listener, FilePath workingDirectory, final int buildNumber, final String gitExe, final BuildData buildData, final EnvVars environment, final String paramLocalBranch, final List<RemoteConfig> paramRepos, final Revision revToBuild, final String internalTagName, final String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<BuildConfig>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BuildConfig invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                String changeLog = null;
                try {
                    listener.getLogger().println("Checking out " + revToBuild);
                    if (GitSCM.this.getClean()) {
                        listener.getLogger().println("Cleaning workspace");
                        git.clean();
                    }
                    git.checkoutBranch(paramLocalBranch, revToBuild.getSha1().name());
                    if (git.hasGitModules()) {
                        if (!GitSCM.this.recursiveSubmodules) {
                            for (RemoteConfig remoteRepository : paramRepos) {
                                GitSCM.this.fetchSubmodulesFrom(git, localWorkspace, (TaskListener)listener, remoteRepository);
                            }
                        }
                        git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                        git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                    }
                    if (GitSCM.this.doGenerateSubmoduleConfigurations) {
                        SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, localWorkspace, GitSCM.this.submoduleCfg);
                        combinator.createSubmoduleCombinations();
                    }
                    GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                    changeLog = GitSCM.this.computeChangeLog(git, revToBuild, listener, buildData);
                    buildData.saveBuild(new Build(revToBuild, buildNumber, null));
                }
                finally {
                    git.close();
                }
                return new BuildConfig(changeLog, buildData);
            }
        });
    }

    private BuildConfig getMergedBuildConfig(final BuildListener listener, FilePath workingDirectory, final int buildNumber, final String gitExe, final BuildData buildData, final EnvVars environment, final String paramLocalBranch, final Revision revToBuild, final String internalTagName, final String internalTagComment) throws IOException, InterruptedException {
        return (BuildConfig)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<BuildConfig>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BuildConfig invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                GitAPI git = new GitAPI(gitExe, new FilePath(localWorkspace), (TaskListener)listener, environment);
                String changeLog = null;
                try {
                    listener.getLogger().println("Merging " + revToBuild + " onto " + GitSCM.this.mergeOptions.getMergeTarget());
                    ObjectId target = git.revParse(GitSCM.this.mergeOptions.getRemoteBranchName());
                    git.checkoutBranch(paramLocalBranch, target.name());
                    try {
                        git.merge(revToBuild.getSha1().name());
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Branch not suitable for integration as it does not merge cleanly");
                        git.checkoutBranch(paramLocalBranch, revToBuild.getSha1().name());
                        GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                        buildData.saveBuild(new Build(revToBuild, buildNumber, Result.FAILURE));
                        BuildConfig buildConfig = new BuildConfig(null, buildData);
                        git.close();
                        return buildConfig;
                    }
                    if (git.hasGitModules()) {
                        git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                        git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                    }
                    GitSCM.this.createInternalTag(git, internalTagName, internalTagComment);
                    changeLog = GitSCM.this.computeChangeLog(git, revToBuild, listener, buildData);
                    Build build = new Build(revToBuild, buildNumber, null);
                    buildData.saveBuild(build);
                    GitUtils gu = new GitUtils((TaskListener)listener, git);
                    build.mergeRevision = gu.getRevisionForSHA1(target);
                    if (GitSCM.this.getClean()) {
                        listener.getLogger().println("Cleaning workspace");
                        git.clean();
                        if (git.hasGitModules()) {
                            git.submoduleClean(GitSCM.this.recursiveSubmodules);
                        }
                    }
                }
                finally {
                    git.close();
                }
                return new BuildConfig(changeLog, buildData);
            }
        });
    }

    private Revision gerRevisionToBuild(final BuildListener listener, FilePath workingDirectory, final String gitExe, final BuildData buildData, final EnvVars environment, final String singleBranch, final List<RemoteConfig> paramRepos, final Revision parentLastBuiltRev, final RevisionParameterAction rpa) throws IOException, InterruptedException {
        return (Revision)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Revision>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Revision invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                FilePath ws = new FilePath(localWorkspace);
                listener.getLogger().println("Checkout:" + ws.getName() + " / " + ws.getRemote() + " - " + ws.getChannel());
                GitAPI git = new GitAPI(gitExe, ws, (TaskListener)listener, environment);
                Collection<Revision> candidates = null;
                try {
                    if (GitSCM.this.wipeOutWorkspace) {
                        listener.getLogger().println("Wiping out workspace first.");
                        try {
                            ws.deleteContents();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (git.hasGitRepo()) {
                        if (GitSCM.this.pruneBranches) {
                            listener.getLogger().println("Pruning obsolete local branches");
                            for (RemoteConfig remoteRepository : paramRepos) {
                                git.prune(remoteRepository);
                            }
                        }
                        listener.getLogger().println("Fetching changes from the remote Git repository");
                        boolean fetched = false;
                        for (RemoteConfig remoteRepository : paramRepos) {
                            if (!GitSCM.this.fetchFrom(git, (TaskListener)listener, remoteRepository)) continue;
                            fetched = true;
                        }
                        if (!fetched) {
                            listener.error("Could not fetch from any repository");
                            throw new GitException("Could not fetch from any repository");
                        }
                    } else {
                        listener.getLogger().println("Cloning the remote Git repository");
                        boolean successfullyCloned = false;
                        for (RemoteConfig rc : paramRepos) {
                            try {
                                if (GitSCM.this.useCgitClone) {
                                    git.clone_cgit(rc);
                                } else {
                                    git.clone(rc);
                                }
                                successfullyCloned = true;
                                break;
                            }
                            catch (GitException ex) {
                                ex.printStackTrace(listener.error("Error cloning remote repo '%s' ", new Object[]{rc.getName()}));
                                listener.getLogger().println("Trying next repository");
                            }
                        }
                        if (!successfullyCloned) {
                            throw new GitException("Could not clone repository");
                        }
                        boolean fetched = false;
                        for (RemoteConfig remoteRepository : paramRepos) {
                            try {
                                git.fetch(remoteRepository);
                                fetched = true;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace(listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
                            }
                        }
                        if (!fetched) {
                            throw new GitException("Could not fetch from any repository");
                        }
                        if (GitSCM.this.getClean()) {
                            listener.getLogger().println("Cleaning workspace");
                            git.clean();
                            if (git.hasGitModules()) {
                                git.submoduleClean(GitSCM.this.recursiveSubmodules);
                            }
                        }
                    }
                    if (parentLastBuiltRev != null) {
                        Revision revision = parentLastBuiltRev;
                        return revision;
                    }
                    if (rpa != null) {
                        Revision revision = rpa.toRevision(git);
                        return revision;
                    }
                    candidates = GitSCM.this.buildChooser.getCandidateRevisions(false, singleBranch, git, (TaskListener)listener, buildData);
                    if (candidates.size() == 0) {
                        Revision revision = null;
                        return revision;
                    }
                }
                finally {
                    git.close();
                }
                return candidates.iterator().next();
            }
        });
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        String commit;
        super.buildEnvVars(build, env);
        GitUtils.buildBranchEnvVar(build, env, this.getRepositories(), this.getBranches());
        BuildData bd = this.fixNull(this.getBuildData((Run)build, false));
        if (bd != null && bd.getLastBuiltRevision() != null && (commit = bd.getLastBuiltRevision().getSha1String()) != null) {
            env.put(GIT_COMMIT, commit);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getAuthorOrCommitter());
    }

    public boolean getRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null && (buildData = (BuildData)build.getAction(BuildData.class)) == null) {
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return clone ? new BuildData() : null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    public String getLocalBranch() {
        return Util.fixEmpty((String)this.localBranch);
    }

    public String getParamLocalBranch(AbstractBuild<?, ?> build) {
        String branch = this.getLocalBranch();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            branch = parameters.substitute(build, branch);
        }
        return branch;
    }

    @Deprecated
    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    protected FilePath workingDirectory(FilePath workspace) {
        if (this.relativeTargetDir == null || this.relativeTargetDir.length() == 0 || this.relativeTargetDir.equals(".")) {
            return workspace;
        }
        return workspace.child(this.relativeTargetDir);
    }

    private FilePath getLocalWorkspace(AbstractProject<?, ?> project, TaskListener listener) {
        TopLevelItem item = null;
        try {
            item = (TopLevelItem)project;
        }
        catch (ClassCastException e) {
            String msg = "Cannot poll for job type " + project.getClass().getName();
            listener.error(msg);
            LOGGER.severe(msg);
        }
        return item == null ? null : Hudson.getInstance().getWorkspaceFor(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, final TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        String gitExe;
        String singleBranch;
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        final BuildData buildData = this.fixNull(this.getBuildData((Run)lastBuild, false));
        if (buildData != null && buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        if ((singleBranch = GitUtils.getSingleBranch(lastBuild, this.getRepositories(), this.getBranches())) != null && this.remotePoll) {
            GitTool[] installations;
            String gitExe2 = "";
            for (GitTool i : installations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()) {
                if (!i.getName().equals(this.gitTool)) continue;
                gitExe2 = i.getGitExe();
                break;
            }
            EnvVars environment = GitUtils.getPollEnvironment(project, workspace, launcher, listener, this.isPollSlaves());
            GitAPI git = new GitAPI(gitExe2, workspace, listener, environment);
            try {
                String gitRepo = ((URIish)this.getParamExpandedRepos(lastBuild).get(0).getURIs().get(0)).toString();
                String headRevision = git.getHeadRev(gitRepo, this.getBranches().get(0).getName());
                String lastBuildRevision = buildData.lastBuild.getRevision().getSha1String();
                listener.getLogger().println("[poll] Head revision: " + headRevision);
                if (lastBuildRevision.equals(headRevision)) {
                    PollingResult pollingResult = PollingResult.NO_CHANGES;
                    return pollingResult;
                }
                if (this.getExcludedCommits().contains(headRevision)) {
                    listener.getLogger().println("Ignored commit " + headRevision + ": This commit has been explicitly excluded from triggering builds.");
                    for (String commit : this.getExcludedCommits()) {
                        listener.getLogger().println("[poll] Excluded commit: " + commit);
                    }
                    PollingResult pollingResult = PollingResult.NO_CHANGES;
                    return pollingResult;
                }
                PollingResult pollingResult = PollingResult.BUILD_NOW;
                return pollingResult;
            }
            finally {
                git.close();
            }
        }
        if (!this.isPollSlaves()) {
            launcher = new Launcher.LocalLauncher(null);
            workspace = this.getLocalWorkspace(project, listener);
            if (workspace == null) {
                return PollingResult.NO_CHANGES;
            }
            gitExe = this.getGitExe((Node)Hudson.getInstance(), listener);
        } else {
            Label label = project.getAssignedLabel();
            if (label != null && label.isSelfLabel()) {
                if (label.getNodes().iterator().next() != project.getLastBuiltOn()) {
                    listener.getLogger().println("Last build was not on tied node, forcing rebuild.");
                    return PollingResult.BUILD_NOW;
                }
                gitExe = this.getGitExe((Node)label.getNodes().iterator().next(), listener);
            } else {
                gitExe = this.getGitExe(project.getLastBuiltOn(), listener);
            }
        }
        listener.getLogger().println("Git Exe: " + gitExe);
        FilePath workingDirectory = this.workingDirectory(workspace);
        if (!workingDirectory.exists() && this.isPollSlaves()) {
            return PollingResult.BUILD_NOW;
        }
        final EnvVars environment = GitUtils.getPollEnvironment(project, workspace, launcher, listener, this.isPollSlaves());
        final List<RemoteConfig> paramRepos = this.getParamExpandedRepos(lastBuild);
        boolean pollChangesResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean invoke(File localWorkspace, VirtualChannel channel) throws IOException {
                Map repoMap = GitSCM.this.getRemoteConfigMap(paramRepos);
                ArrayList<Revision> candidates = new ArrayList<Revision>();
                for (Map.Entry entry : repoMap.entrySet()) {
                    FilePath workspace = new FilePath(localWorkspace);
                    if (StringUtils.isNotEmpty((String)((String)entry.getKey())) && !((String)entry.getKey()).equals(".")) {
                        workspace = workspace.child((String)entry.getKey());
                    }
                    GitAPI git = new GitAPI(gitExe, workspace, listener, environment);
                    try {
                        if (!git.hasGitRepo()) {
                            if (!GitSCM.this.isPollSlaves()) {
                                for (RemoteConfig remoteRepository : paramRepos) {
                                    if (GitSCM.this.useCgitClone) {
                                        git.clone_cgit(remoteRepository);
                                        continue;
                                    }
                                    git.clone(remoteRepository);
                                }
                                continue;
                            }
                            listener.getLogger().println("No Git repository yet, an initial checkout is required");
                            Boolean i$ = true;
                            return i$;
                        }
                        listener.getLogger().println("Fetching changes from the remote Git repositories");
                        for (RemoteConfig remoteRepository : (List)entry.getValue()) {
                            GitSCM.this.fetchFrom(git, listener, remoteRepository);
                        }
                        Collection<Revision> origCanditates = GitSCM.this.buildChooser.getCandidateRevisions(true, singleBranch, git, listener, buildData);
                        for (Revision c : origCanditates) {
                            if (GitSCM.this.isRevExcluded(git, c, listener)) continue;
                            candidates.add(c);
                        }
                    }
                    finally {
                        git.close();
                    }
                }
                return candidates.size() > 0;
            }
        });
        return pollChangesResult ? PollingResult.SIGNIFICANT : PollingResult.NO_CHANGES;
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec, String relativeTargetDir) {
        try {
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            repoConfig.setString("remote", name, "targetDir", relativeTargetDir);
            return GitRepository.getAllGitRepositories(repoConfig).get(0);
        }
        catch (Exception ex) {
            throw new GitException("Remote's configuration is invalid", ex);
        }
    }

    private boolean changeLogResult(String changeLog, File changelogFile) throws IOException {
        if (changeLog == null) {
            return false;
        }
        changelogFile.delete();
        FileOutputStream fos = new FileOutputStream(changelogFile);
        fos.write(changeLog.getBytes());
        fos.close();
        return true;
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        return this.getRegionsPatterns(included);
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        return this.getRegionsPatterns(excluded);
    }

    private Pattern[] getRegionsPatterns(String[] regions) {
        if (regions != null) {
            Pattern[] patterns = new Pattern[regions.length];
            int i = 0;
            for (String region : regions) {
                patterns[i++] = Pattern.compile(region);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    private String getRefSpec(RemoteConfig repo, AbstractBuild<?, ?> build) {
        String refSpec = ((RefSpec)repo.getFetchRefSpecs().get(0)).toString();
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            refSpec = parameters.substitute(build, refSpec);
        }
        return refSpec;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData();
    }

    private boolean fetchFrom(IGitAPI git, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository);
            return true;
        }
        catch (GitException ex) {
            ex.printStackTrace(listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchSubmodulesFrom(IGitAPI git, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        boolean fetched = true;
        try {
            git.setupSubmoduleUrls(remoteRepository.getName(), listener);
            boolean hasHead = true;
            try {
                git.revParse("HEAD");
            }
            catch (GitException e) {
                hasHead = false;
            }
            if (hasHead) {
                List<IndexEntry> submodules = git.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    try {
                        RemoteConfig submoduleRemoteRepository = this.getSubmoduleRepository(git, remoteRepository, submodule.getFile());
                        File subdir = new File(workspace, submodule.getFile());
                        listener.getLogger().println("Trying to fetch " + submodule.getFile() + " into " + subdir);
                        GitAPI subGit = new GitAPI(git.getGitExe(), new FilePath(subdir), listener, git.getEnvironment());
                        try {
                            subGit.fetch(submoduleRemoteRepository);
                        }
                        finally {
                            subGit.close();
                        }
                    }
                    catch (Exception ex) {
                        listener.getLogger().println("Problem fetching from submodule " + submodule.getFile() + " - could be unavailable. Continuing anyway");
                    }
                }
            }
        }
        catch (GitException ex) {
            ex.printStackTrace(listener.error("Problem fetching submodules from a path relative to " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
            fetched = false;
        }
        return fetched;
    }

    private void createInternalTag(IGitAPI git, String tagName, String tagComment) {
        if (!this.getSkipTag()) {
            git.tag(tagName, tagComment);
        }
    }

    private String computeChangeLog(IGitAPI git, Revision revToBuild, BuildListener listener, BuildData buildData) throws IOException {
        int histories = 0;
        StringBuilder changeLog = new StringBuilder();
        try {
            for (Branch b : revToBuild.getBranches()) {
                Build lastRevWas = this.buildChooser.prevBuildForChangelog(b.getName(), buildData, git);
                if (lastRevWas != null) {
                    if (git.isCommitInRepo(lastRevWas.getSHA1().name())) {
                        changeLog.append(this.putChangelogDiffsIntoFile(git, b.name, lastRevWas.getSHA1().name(), revToBuild.getSha1().name()));
                        ++histories;
                        continue;
                    }
                    listener.getLogger().println("Could not record history. Previous build's commit, " + lastRevWas.getSHA1().name() + ", does not exist in the current repository.");
                    continue;
                }
                listener.getLogger().println("No change to record in branch " + b.getName());
            }
        }
        catch (GitException ge) {
            changeLog.append("Unable to retrieve changeset");
        }
        if (histories > 1) {
            listener.getLogger().println("Warning : There are multiple branch changesets here");
        }
        return changeLog.toString();
    }

    private String putChangelogDiffsIntoFile(IGitAPI git, String branchName, String revFrom, String revTo) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String changeset = "Changes in branch " + branchName + ", between " + revFrom + " and " + revTo + "\n";
        fos.write(changeset.getBytes());
        git.changelog(revFrom, revTo, fos);
        fos.close();
        return fos.toString("UTF-8");
    }

    private boolean isRevExcluded(IGitAPI git, Revision r, TaskListener listener) {
        try {
            String author;
            List<String> revShow = git.showRevision(r);
            if (revShow.size() == 0) {
                return false;
            }
            if (this.excludedCommits != null && this.excludedCommits.contains(r.getSha1String())) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": This commit has been explicitly excluded from triggering builds.");
                return true;
            }
            GitChangeSet change = new GitChangeSet(revShow, this.authorOrCommitter);
            Pattern[] includedPatterns = this.getIncludedRegionsPatterns();
            Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
            Set<String> excludedUsers = this.getExcludedUsersNormalized();
            if (excludedUsers.contains(author = change.getAuthorName())) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found excluded author: " + author);
                return true;
            }
            ArrayList<String> paths = new ArrayList<String>(change.getAffectedPaths());
            if (paths.isEmpty()) {
                return false;
            }
            ArrayList<Object> includedPaths = new ArrayList();
            if (includedPatterns.length > 0) {
                block2: for (String path : paths) {
                    for (Pattern pattern : includedPatterns) {
                        if (!pattern.matcher(path).matches()) continue;
                        includedPaths.add(path);
                        continue block2;
                    }
                }
            } else {
                includedPaths = paths;
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (excludedPatterns.length > 0) {
                block4: for (String string : includedPaths) {
                    for (Pattern pattern : excludedPatterns) {
                        if (!pattern.matcher(string).matches()) continue;
                        excludedPaths.add(string);
                        continue block4;
                    }
                }
            }
            if (includedPaths.size() == excludedPaths.size()) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found only excluded paths: " + Util.join(excludedPaths, (String)", "));
                return true;
            }
        }
        catch (GitException e) {
            return false;
        }
        return false;
    }

    private Map<String, List<RemoteConfig>> getRemoteConfigMap(List<RemoteConfig> repositories) {
        HashMap<String, List<RemoteConfig>> map = new HashMap<String, List<RemoteConfig>>();
        for (RemoteConfig repo : repositories) {
            String targetDir = this.getRemoteConfigTargetDir(repo);
            ArrayList<RemoteConfig> repos = (ArrayList<RemoteConfig>)map.get(targetDir);
            if (null == repos) {
                repos = new ArrayList<RemoteConfig>();
                map.put(targetDir, repos);
            }
            repos.add(repo);
        }
        return map;
    }

    private String getRemoteConfigTargetDir(RemoteConfig remoteConfig) {
        if (remoteConfig instanceof GitRepository) {
            return ((GitRepository)remoteConfig).getRelativeTargetDir();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitSCM that = (GitSCM)o;
        if (!GitUtils.isEqualCollection(this.remoteRepositories, that.remoteRepositories)) {
            return false;
        }
        if (!GitUtils.isEqualCollection(this.branches, that.branches)) {
            return false;
        }
        if (!GitUtils.isEqualCollection(this.submoduleCfg, that.submoduleCfg)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.configVersion, (Object)that.configVersion).append((Object)this.localBranch, (Object)that.localBranch).append((Object)this.mergeOptions, (Object)that.mergeOptions).append(this.recursiveSubmodules, that.recursiveSubmodules).append(this.doGenerateSubmoduleConfigurations, that.doGenerateSubmoduleConfigurations).append(this.authorOrCommitter, that.authorOrCommitter).append(this.clean, that.clean).append(this.wipeOutWorkspace, that.wipeOutWorkspace).append(this.pruneBranches, that.pruneBranches).append((Object)this.buildChooser, (Object)that.buildChooser).append((Object)this.browser, (Object)that.browser).append((Object)this.includedRegions, (Object)that.includedRegions).append((Object)this.excludedRegions, (Object)that.excludedRegions).append((Object)this.excludedUsers, (Object)that.excludedUsers).append((Object)this.gitConfigName, (Object)that.gitConfigName).append((Object)this.gitConfigEmail, (Object)that.gitConfigEmail).append((Object)this.gitTool, (Object)that.gitTool).append(this.skipTag, that.skipTag).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.configVersion).append(this.remoteRepositories).append(this.branches).append((Object)this.localBranch).append((Object)this.mergeOptions).append(this.recursiveSubmodules).append(this.doGenerateSubmoduleConfigurations).append(this.authorOrCommitter).append(this.clean).append(this.wipeOutWorkspace).append(this.pruneBranches).append((Object)this.buildChooser).append((Object)this.browser).append(this.submoduleCfg).append((Object)this.includedRegions).append((Object)this.excludedRegions).append((Object)this.excludedUsers).append((Object)this.gitConfigName).append((Object)this.gitConfigEmail).append((Object)this.gitTool).append(this.skipTag).hashCode();
    }

    private class BuildConfig
    implements Serializable {
        private BuildData buildData;
        private String changeLog;

        public BuildConfig(String changeLog, BuildData buildData) {
            this.changeLog = changeLog;
            this.buildData = buildData;
        }

        public BuildData getBuildData() {
            return this.buildData;
        }

        public String getChangeLog() {
            return this.changeLog;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;
        private boolean createAccountBaseOnCommitterEmail;
        private boolean pollSlaves = true;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.beforeLoad();
            this.load();
        }

        public void setGlobalConfigName(String globalConfigName) {
            this.globalConfigName = globalConfigName;
        }

        public void setGlobalConfigEmail(String globalConfigEmail) {
            this.globalConfigEmail = globalConfigEmail;
        }

        public void setPollSlaves(boolean pollSlaves) {
            this.pollSlaves = pollSlaves;
        }

        public void setCreateAccountBaseOnCommitterEmail(boolean createAccountBaseOnCommitterEmail) {
            this.createAccountBaseOnCommitterEmail = createAccountBaseOnCommitterEmail;
        }

        private void beforeLoad() {
            Items.XSTREAM.alias("ObjectId", ObjectId.class);
            Items.XSTREAM.alias("RemoteConfig", RemoteConfig.class);
            Items.XSTREAM.alias("RemoteConfig", org.spearce.jgit.transport.RemoteConfig.class);
            Items.XSTREAM.alias("RemoteConfig", GitRepository.class);
            Items.XSTREAM.registerConverter((Converter)new RemoteConfigConverter(Items.XSTREAM.getMapper(), Items.XSTREAM.getReflectionProvider()));
            Run.XSTREAM.registerConverter((Converter)new ObjectIdConverter());
        }

        public String getDisplayName() {
            return "Git";
        }

        public List<BuildChooserDescriptor> getBuildChooserDescriptors() {
            return BuildChooser.all();
        }

        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return this.globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return this.globalConfigEmail;
        }

        public boolean isPollSlaves() {
            return this.pollSlaves;
        }

        public boolean isCreateAccountBaseOnCommitterEmail() {
            return this.createAccountBaseOnCommitterEmail;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        private GitRepositoryBrowser getBrowserFromRequest(StaplerRequest req, JSONObject scmData) {
            if (scmData.containsKey((Object)"browser")) {
                return (GitRepositoryBrowser)((Object)req.bindJSON(GitRepositoryBrowser.class, scmData.getJSONObject("browser")));
            }
            return null;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List<RemoteConfig> remoteRepositories;
            try {
                remoteRepositories = DescriptorImpl.createRepositoryConfigurations(req.getParameterValues("git.repo.url"), req.getParameterValues("git.repo.name"), req.getParameterValues("git.repo.refspec"), req.getParameterValues("git.repo.relativeTargetDir"));
            }
            catch (IOException e1) {
                throw new GitException(Messages.GitSCM_Repository_CreationExceptionMsg(), e1);
            }
            List<BranchSpec> branches = DescriptorImpl.createBranches(req.getParameterValues("git.branch"));
            PreBuildMergeOptions mergeOptions = DescriptorImpl.createMergeOptions(req.getParameter("git.doMerge"), req.getParameter("git.mergeRemote"), req.getParameter("git.mergeTarget"), remoteRepositories);
            ArrayList<SubmoduleConfig> submoduleCfg = new ArrayList<SubmoduleConfig>();
            GitRepositoryBrowser gitBrowser = this.getBrowserFromRequest(req, formData);
            String gitTool = req.getParameter("git.gitTool");
            GitSCM gitSCM = new GitSCM(remoteRepositories, branches, mergeOptions, req.getParameter("git.generate") != null, submoduleCfg, req.getParameter("git.clean") != null, req.getParameter("git.wipeOutWorkspace") != null, (BuildChooser)req.bindJSON(BuildChooser.class, formData.getJSONObject("buildChooser")), gitBrowser, gitTool, req.getParameter("git.authorOrCommitter") != null, req.getParameter("git.excludedRegions"), req.getParameter("git.excludedUsers"), req.getParameter("git.localBranch"), req.getParameter("git.recursiveSubmodules") != null, req.getParameter("git.pruneBranches") != null, req.getParameter("git.remotePoll") != null, req.getParameter("git.gitConfigName"), req.getParameter("git.gitConfigEmail"), req.getParameter("git.skipTag") != null, req.getParameter("git.includedRegions"), req.getParameter("git.ignoreNotifyCommit") != null);
            gitSCM.setUseCgitClone(req.getParameter("git.useCgitClone") != null);
            return gitSCM;
        }

        @Deprecated
        public static List<RemoteConfig> createRepositoryConfigurations(String[] urls, String[] repoNames, String[] refSpecs) throws IOException, Descriptor.FormException {
            return DescriptorImpl.createRepositoryConfigurations(urls, repoNames, refSpecs, new String[]{""});
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] urls, String[] repoNames, String[] refSpecs, String[] relativeTargetDirs) throws IOException, Descriptor.FormException {
            if (GitUtils.isEmpty(urls)) {
                throw new Descriptor.FormException(Messages.GitSCM_Repository_MissedRepositoryExceptionMsg(), "git.repo.url");
            }
            List<RemoteConfig> remoteRepositories = new ArrayList<RemoteConfig>();
            if (!GitUtils.isEmpty(urls)) {
                Config repoConfig = new Config();
                if ((repoNames = GitUtils.fixupNames(repoNames, urls)) != null) {
                    for (int i = 0; i < repoNames.length; ++i) {
                        String name = StringUtils.replaceChars((String)repoNames[i], (char)' ', (char)'_');
                        if (StringUtils.isEmpty((String)refSpecs[i])) {
                            refSpecs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                        }
                        repoConfig.setString("remote", name, "url", urls[i]);
                        repoConfig.setString("remote", name, "fetch", refSpecs[i]);
                        repoConfig.setString("remote", name, "targetDir", relativeTargetDirs[i]);
                    }
                }
                try {
                    remoteRepositories = GitRepository.getAllGitRepositories(repoConfig);
                }
                catch (Exception e) {
                    throw new GitException(Messages.GitSCM_Repository_CreationExceptionMsg(), e);
                }
            }
            return remoteRepositories;
        }

        public static List<BranchSpec> createBranches(String[] branchParams) {
            ArrayList<BranchSpec> branches = new ArrayList<BranchSpec>();
            if (ArrayUtils.isEmpty((Object[])branchParams)) {
                branches.add(new BranchSpec(GitSCM.DEFAULT_BRANCH));
            } else {
                for (String branchParam : branchParams) {
                    branches.add(new BranchSpec(branchParam));
                }
            }
            return branches;
        }

        public static PreBuildMergeOptions createMergeOptions(String doMerge, String pMergeRemote, String mergeTarget, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (doMerge != null && doMerge.trim().length() > 0) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = pMergeRemote.trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeTarget);
            }
            return mergeOptions;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("git.repo.url");
            String[] names = req.getParameterValues("git.repo.name");
            for (String name : names = GitUtils.fixupNames(names, urls)) {
                if (!name.equals(mergeRemoteName)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public FormValidation doCheckRepositoryUrl(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.GitSCM_Repository_IncorrectRepositoryFormatMsg());
            }
            Config repoConfig = new Config();
            repoConfig.setString("remote", "origin", "url", value);
            try {
                RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                return FormValidation.error((String)(Messages.GitSCM_Repository_IncorrectRepositoryFormatMsg() + ": " + e.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

