/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.xni;

import java.util.Arrays;
import java.util.Locale;
import org.htmlunit.cyberneko.util.FastHashMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XMLString
implements CharSequence {
    private char[] data_;
    private int length_;
    private final int growBy_;
    public static final int CAPACITY_GROWTH = 32;
    public static final int INITIAL_CAPACITY = 20;
    public static final XMLString EMPTY = new XMLString(0);
    private static final char REPLACEMENT_CHARACTER = '\ufffd';

    public XMLString() {
        this.data_ = new char[20];
        this.length_ = 0;
        this.growBy_ = 32;
    }

    public XMLString(int startSize) {
        this(startSize, 32);
    }

    public XMLString(int startSize, int growBy) {
        this.data_ = new char[startSize];
        this.length_ = 0;
        this.growBy_ = Math.max(1, growBy);
    }

    public XMLString(XMLString src) {
        this(src, 0);
    }

    public XMLString(XMLString src, int addCapacity) {
        this.data_ = Arrays.copyOf(src.data_, src.length_ + Math.max(0, addCapacity));
        this.length_ = src.length();
        this.growBy_ = Math.max(1, 32);
    }

    public XMLString(String src) {
        this.data_ = src.toCharArray();
        this.length_ = src.length();
        this.growBy_ = 32;
    }

    public XMLString(char[] ch, int offset, int length) {
        this(length);
        this.append(ch, offset, length);
    }

    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.data_.length) {
            int newSize = Math.max(minimumCapacity + this.growBy_, (this.data_.length << 1) + 2);
            this.data_ = Arrays.copyOf(this.data_, newSize);
        }
    }

    public int capacity() {
        return this.data_.length;
    }

    private void growByAtLeastOne() {
        int newSize = Math.max(this.growBy_, (this.data_.length << 1) + 2);
        this.data_ = Arrays.copyOf(this.data_, newSize);
    }

    public XMLString append(char c) {
        int oldLength = this.length_;
        if (oldLength == this.data_.length) {
            this.growByAtLeastOne();
        }
        this.data_[oldLength] = c;
        ++this.length_;
        return this;
    }

    public XMLString append(char c1, char c2) {
        if (this.length_ + 1 < this.data_.length) {
            this.data_[this.length_++] = c1;
            this.data_[this.length_++] = c2;
        } else {
            this.append(c1);
            this.append(c2);
        }
        return this;
    }

    public XMLString append(String src) {
        int start = this.length_;
        this.length_ += src.length();
        this.ensureCapacity(this.length_);
        for (int i = 0; i < src.length(); ++i) {
            this.data_[start + i] = src.charAt(i);
        }
        return this;
    }

    public XMLString append(XMLString src) {
        int start = this.length_;
        this.length_ += src.length();
        this.ensureCapacity(this.length_);
        System.arraycopy(src.data_, 0, this.data_, start, src.length_);
        return this;
    }

    public XMLString append(char[] src, int offset, int length) {
        int start = this.length_;
        this.length_ = start + length;
        this.ensureCapacity(this.length_);
        System.arraycopy(src, offset, this.data_, start, length);
        return this;
    }

    public XMLString prepend(char c) {
        int oldLength = this.length_;
        if (oldLength == this.data_.length) {
            this.growByAtLeastOne();
        }
        System.arraycopy(this.data_, 0, this.data_, 1, oldLength);
        this.data_[0] = c;
        ++this.length_;
        return this;
    }

    @Override
    public int length() {
        return this.length_;
    }

    public int getGrowBy() {
        return this.growBy_;
    }

    public XMLString clear() {
        this.length_ = 0;
        return this;
    }

    public XMLString clearAndAppend(char c) {
        this.length_ = 0;
        if (this.data_.length > 0) {
            this.data_[this.length_] = c;
            ++this.length_;
        } else {
            this.append(c);
        }
        return this;
    }

    public boolean endsWith(String s) {
        if (this.length_ < s.length()) {
            return false;
        }
        int start = this.length_ - s.length();
        for (int i = 0; i < s.length(); ++i) {
            if (this.data_[i + start] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public XMLString reduceToContent(String startMarker, String endMarker) {
        return this.trimToContent(startMarker, endMarker);
    }

    public XMLString trimToContent(String startMarker, String endMarker) {
        int ePos;
        int sPos;
        int markerLength = startMarker.length() + endMarker.length();
        if (markerLength >= this.length_) {
            return this;
        }
        for (sPos = 0; sPos < this.length_ - markerLength && Character.isWhitespace(this.data_[sPos]); ++sPos) {
        }
        for (ePos = this.length_ - 1; ePos > sPos - markerLength && Character.isWhitespace(this.data_[ePos]); --ePos) {
        }
        if (ePos - sPos + 1 < markerLength) {
            return this;
        }
        for (int i = 0; i < startMarker.length(); ++i) {
            if (startMarker.charAt(i) == this.data_[i + sPos]) continue;
            return this;
        }
        int endStartCheckPos = ePos - endMarker.length() + 1;
        for (int i = 0; i < endMarker.length(); ++i) {
            if (endMarker.charAt(i) == this.data_[endStartCheckPos + i]) continue;
            return this;
        }
        int newLength = ePos - sPos + 1 - markerLength;
        System.arraycopy(this.data_, sPos + startMarker.length(), this.data_, 0, newLength);
        this.length_ = newLength;
        return this;
    }

    public boolean isWhitespace() {
        for (int i = this.length_ - 1; i >= 0; --i) {
            if (Character.isWhitespace(this.data_[i])) continue;
            return false;
        }
        return true;
    }

    public XMLString trim() {
        return this.trimTrailing().trimLeading();
    }

    public XMLString trimLeading() {
        int sPos;
        for (sPos = 0; sPos < this.length_ && Character.isWhitespace(this.data_[sPos]); ++sPos) {
        }
        if (sPos == 0) {
            return this;
        }
        if (sPos == this.length_) {
            this.length_ = 0;
            return this;
        }
        int newLength = this.length_ - sPos;
        System.arraycopy(this.data_, sPos, this.data_, 0, newLength);
        this.length_ = newLength;
        return this;
    }

    public XMLString trimWhitespaceAtEnd() {
        return this.trimTrailing();
    }

    public XMLString trimTrailing() {
        int ePos;
        for (ePos = this.length_ - 1; ePos >= 0 && Character.isWhitespace(this.data_[ePos]); --ePos) {
        }
        this.length_ = ePos + 1;
        return this;
    }

    public XMLString shortenBy(int count) {
        int newLength = this.length_ - count;
        this.length_ = newLength < 0 ? 0 : newLength;
        return this;
    }

    public char[] getChars() {
        return Arrays.copyOf(this.data_, this.length_);
    }

    @Override
    public String toString() {
        if (this.length_ > 0) {
            return new String(this.data_, 0, this.length_);
        }
        return "";
    }

    public static String toString(XMLString seq) {
        if (seq == null) {
            return null;
        }
        if (seq.length_ > 0) {
            return new String(seq.data_, 0, seq.length_);
        }
        return "";
    }

    public String toString(FastHashMap<XMLString, String> cache) {
        String s = cache.get(this);
        if (s == null) {
            s = this.toString();
            cache.put(this.clone(), s);
        }
        return s;
    }

    public static String toString(XMLString seq, FastHashMap<XMLString, String> cache) {
        if (seq == null) {
            return null;
        }
        String s = cache.get(seq);
        if (s == null) {
            s = seq.toString();
            cache.put(seq.clone(), s);
        }
        return s;
    }

    @Override
    public char charAt(int index) {
        if (index > this.length_ - 1 || index < 0) {
            throw new IndexOutOfBoundsException("Tried to read outside of the valid buffer data");
        }
        return this.data_[index];
    }

    public char unsafeCharAt(int index) {
        return this.data_[index];
    }

    public XMLString clone() {
        return new XMLString(this);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length_) {
            throw new StringIndexOutOfBoundsException(end);
        }
        int l = end - start;
        if (l < 0) {
            throw new StringIndexOutOfBoundsException(l);
        }
        return new String(this.data_, start, l);
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            CharSequence ob = (CharSequence)o;
            if (ob.length() != this.length_) {
                return false;
            }
            for (int i = 0; i < this.length_; ++i) {
                if (ob.charAt(i) == this.data_[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(CharSequence sequence, XMLString s) {
        if (s == null) {
            return false;
        }
        return s.equals(sequence);
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.length_; ++i) {
            h = (h << 5) - h + this.data_[i];
        }
        return h;
    }

    public boolean appendCodePoint(int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            this.append((char)codePoint);
        } else if (Character.isValidCodePoint(codePoint)) {
            this.append(Character.highSurrogate(codePoint), Character.lowSurrogate(codePoint));
        } else {
            this.append('\ufffd');
            return false;
        }
        return true;
    }

    public XMLString toUpperCase(Locale locale) {
        boolean gaveUp = false;
        for (int i = 0; i < this.length_; ++i) {
            char c = this.data_[i];
            if (Character.isHighSurrogate(c)) {
                gaveUp = true;
                break;
            }
            int upperCasePoint = Character.toUpperCase((int)c);
            this.data_[i] = (char)upperCasePoint;
        }
        if (!gaveUp) {
            return this;
        }
        String s = this.toString().toUpperCase(locale);
        int newLength = s.length();
        if (this.data_.length < newLength) {
            this.data_ = new char[newLength];
        }
        for (int i = 0; i < newLength; ++i) {
            this.data_[i] = s.charAt(i);
        }
        this.length_ = newLength;
        return this;
    }

    public XMLString toLowerCase(Locale locale) {
        boolean gaveUp = false;
        for (int i = 0; i < this.length_; ++i) {
            char c = this.data_[i];
            if (Character.isHighSurrogate(c)) {
                gaveUp = true;
                break;
            }
            int lowerCasePoint = Character.toLowerCase((int)c);
            this.data_[i] = (char)lowerCasePoint;
        }
        if (!gaveUp) {
            return this;
        }
        String s = this.toString().toLowerCase(locale);
        int newLength = s.length();
        if (this.data_.length < newLength) {
            this.data_ = new char[newLength];
        }
        for (int i = 0; i < newLength; ++i) {
            this.data_[i] = s.charAt(i);
        }
        this.length_ = newLength;
        return this;
    }

    public static boolean equalsIgnoreCase(CharSequence sequence, XMLString s) {
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase(sequence);
    }

    public boolean equalsIgnoreCase(CharSequence s) {
        if (s == null || s.length() != this.length_) {
            return false;
        }
        for (int i = 0; i < this.length_; ++i) {
            char c2l;
            char c1l;
            char c2u;
            char c1u;
            char c1 = this.data_[i];
            char c2 = s.charAt(i);
            if (c1 == c2 || (c1u = Character.toUpperCase(c1)) == (c2u = Character.toUpperCase(c2)) || (c1l = Character.toLowerCase(c1)) == (c2l = Character.toLowerCase(c2))) continue;
            return false;
        }
        return true;
    }

    private static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.length_; ++i) {
            if (this.data_[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(XMLString s) {
        return s != null ? XMLString.indexOf(this.data_, 0, this.length_, s.data_, 0, s.length_, 0) : -1;
    }

    public boolean contains(XMLString s) {
        return s != null && XMLString.indexOf(this.data_, 0, this.length_, s.data_, 0, s.length_, 0) > -1;
    }

    public void characters(ContentHandler contentHandler) throws SAXException {
        contentHandler.characters(this.data_, 0, this.length_);
    }

    public void ignorableWhitespace(ContentHandler contentHandler) throws SAXException {
        contentHandler.ignorableWhitespace(this.data_, 0, this.length_);
    }

    public void comment(LexicalHandler lexicalHandler) throws SAXException {
        lexicalHandler.comment(this.data_, 0, this.length_);
    }
}

