/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2.client.simple;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.authorization.oauth2.client.AccessTokenInfo;
import org.hswebframework.web.authorization.oauth2.client.simple.OAuth2UserTokenRepository;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.oauth2.server.client.OAuth2UserTokenDao;
import org.hswebframework.web.entity.oauth2.client.OAuth2UserTokenEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.oauth2.client.OAuth2UserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="oAuth2UserTokenService")
public class SimpleOAuth2UserTokenService
extends GenericEntityService<OAuth2UserTokenEntity, String>
implements OAuth2UserTokenService,
OAuth2UserTokenRepository {
    @Autowired
    private OAuth2UserTokenDao oAuth2UserTokenDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public OAuth2UserTokenDao getDao() {
        return this.oAuth2UserTokenDao;
    }

    public AccessTokenInfo createToken() {
        return (AccessTokenInfo)this.entityFactory.newInstance(AccessTokenInfo.class);
    }

    @Cacheable(cacheNames={"oauth2-user-token-list"}, key="'s-g-t:'+#serverId+':'+#grantType")
    public List<AccessTokenInfo> findByServerIdAndGrantType(String serverId, String grantType) {
        return this.selectByServerIdAndGrantType(serverId, grantType).stream().map(this.tokenInfoMapping()).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"oauth2-user-token"}, key="'a-t:'+#accessToken")
    public AccessTokenInfo findByAccessToken(String accessToken) {
        return Optional.ofNullable(this.selectByAccessToken(accessToken)).map(this.tokenInfoMapping()).orElse(null);
    }

    protected Function<OAuth2UserTokenEntity, AccessTokenInfo> tokenInfoMapping() {
        return entity -> {
            AccessTokenInfo info = (AccessTokenInfo)this.entityFactory.newInstance(AccessTokenInfo.class, entity);
            info.setExpiresIn(entity.getExpiresIn());
            info.setAccessToken(entity.getAccessToken());
            info.setCreateTime(entity.getCreateTime());
            info.setUpdateTime(entity.getUpdateTime());
            info.setRefreshToken(entity.getRefreshToken());
            info.setServerId(entity.getServerId());
            info.setGrantType(entity.getGrantType());
            info.setScope(entity.getScope());
            return info;
        };
    }

    protected Function<AccessTokenInfo, OAuth2UserTokenEntity> entityTokenInfoMapping() {
        return info -> {
            OAuth2UserTokenEntity entity = (OAuth2UserTokenEntity)this.entityFactory.newInstance(OAuth2UserTokenEntity.class, info);
            entity.setExpiresIn(info.getExpiresIn());
            entity.setAccessToken(info.getAccessToken());
            entity.setCreateTime(info.getCreateTime());
            entity.setUpdateTime(info.getUpdateTime());
            entity.setRefreshToken(info.getRefreshToken());
            entity.setServerId(info.getServerId());
            entity.setGrantType(info.getGrantType());
            entity.setScope(info.getScope());
            return entity;
        };
    }

    @Caching(put={@CachePut(cacheNames={"oauth2-user-token"}, key="'a-t:'+#tokenInfo.accessToken")}, evict={@CacheEvict(cacheNames={"oauth2-user-token-list"}, key="'s-g-t:'+#result.serverId+':'+#result.grantType")})
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public AccessTokenInfo update(String id, AccessTokenInfo tokenInfo) {
        OAuth2UserTokenEntity entity = this.entityTokenInfoMapping().apply(tokenInfo);
        entity.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.updateByPk(id, (GenericEntity)entity);
        return tokenInfo;
    }

    @Caching(put={@CachePut(cacheNames={"oauth2-user-token"}, key="'a-t:'+#tokenInfo.accessToken")}, evict={@CacheEvict(cacheNames={"oauth2-user-token-list"}, key="'s-g-t:'+#result.serverId+':'+#result.grantType")})
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public AccessTokenInfo insert(AccessTokenInfo tokenInfo) {
        if (tokenInfo.getId() == null) {
            tokenInfo.setId((String)this.getIDGenerator().generate());
        }
        OAuth2UserTokenEntity entity = this.entityTokenInfoMapping().apply(tokenInfo);
        entity.setCreateTime(tokenInfo.getCreateTime());
        entity.setUpdateTime(tokenInfo.getUpdateTime());
        this.insert((GenericEntity)entity);
        return tokenInfo;
    }

    public List<OAuth2UserTokenEntity> selectByServerIdAndGrantType(String serverId, String grantType) {
        Assert.notNull((Object)serverId, (String)"serverId can not be null!");
        Assert.notNull((Object)grantType, (String)"grantType can not be null!");
        return ((Query)((Query)this.createQuery().where("serverId", (Object)serverId)).is("grantType", (Object)grantType)).listNoPaging();
    }

    public OAuth2UserTokenEntity selectByAccessToken(String accessToken) {
        Assert.notNull((Object)accessToken, (String)"token can not be null!");
        return (OAuth2UserTokenEntity)((Query)this.createQuery().where("accessToken", (Object)accessToken)).single();
    }
}

