/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2.client.simple;

import java.util.List;
import org.hswebframework.web.authorization.oauth2.client.OAuth2ServerConfig;
import org.hswebframework.web.authorization.oauth2.client.simple.OAuth2ServerConfigRepository;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.oauth2.server.client.OAuth2ServerConfigDao;
import org.hswebframework.web.entity.oauth2.client.OAuth2ServerConfigEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.oauth2.client.OAuth2ServerConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="oAuth2ServerConfigService")
@CacheConfig(cacheNames={"oauth2-server-config"})
public class SimpleOAuth2ServerConfigService
extends GenericEntityService<OAuth2ServerConfigEntity, String>
implements OAuth2ServerConfigService,
OAuth2ServerConfigRepository {
    @Autowired
    private OAuth2ServerConfigDao oAuth2ServerConfigDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public OAuth2ServerConfigDao getDao() {
        return this.oAuth2ServerConfigDao;
    }

    @Cacheable(key="'conf-id:'+#id")
    public OAuth2ServerConfig findById(String id) {
        OAuth2ServerConfigEntity entity = (OAuth2ServerConfigEntity)this.selectByPk(id);
        if (null == entity) {
            return null;
        }
        return (OAuth2ServerConfig)this.entityFactory.newInstance(OAuth2ServerConfig.class, (Object)entity);
    }

    @CacheEvict(key="'conf-id:'+#id")
    public int updateByPk(String id, OAuth2ServerConfigEntity entity) {
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    @CacheEvict(key="'conf-id:'+#id")
    public OAuth2ServerConfigEntity deleteByPk(String id) {
        return (OAuth2ServerConfigEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(List<OAuth2ServerConfigEntity> data) {
        return super.updateByPk(data);
    }

    @CacheEvict(key="'conf-id:'+#result")
    public String saveOrUpdate(OAuth2ServerConfigEntity entity) {
        return (String)super.saveOrUpdate((GenericEntity)entity);
    }

    @CacheEvict(key="'conf-id:'+#result.id")
    public OAuth2ServerConfig save(OAuth2ServerConfig config) {
        OAuth2ServerConfigEntity entity = (OAuth2ServerConfigEntity)this.entityFactory.newInstance(OAuth2ServerConfigEntity.class, (Object)config);
        this.saveOrUpdate(entity);
        return config;
    }
}

