/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.switcher;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import org.hswebframework.web.context.ContextKey;
import org.hswebframework.web.context.ContextUtils;
import org.hswebframework.web.datasource.switcher.Switcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSwitcher
implements Switcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultSwitcher.class);
    private String name;
    private String defaultId;
    private String type;

    public DefaultSwitcher(String name, String type) {
        this.name = "DefaultSwitcher.".concat(name);
        this.defaultId = name.concat(".").concat("_default");
        this.type = type;
    }

    protected Deque<String> getUsedHistoryQueue() {
        return (Deque)ContextUtils.currentContext().getOrDefault(ContextKey.of((String)this.name), LinkedList::new);
    }

    @Override
    public void useLast() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return;
        }
        this.getUsedHistoryQueue().removeLast();
        if (log.isDebugEnabled()) {
            String current = this.current().orElse(null);
            if (null != current) {
                log.debug("try use last {} : {}", (Object)this.type, (Object)current);
            } else {
                log.debug("try use last default {}", (Object)this.type);
            }
        }
    }

    @Override
    public void use(String id) {
        this.getUsedHistoryQueue().addLast(id);
        if (log.isDebugEnabled()) {
            log.debug("try use {} : {}", (Object)this.type, (Object)id);
        }
    }

    @Override
    public void useDefault() {
        this.getUsedHistoryQueue().addLast(this.defaultId);
        if (log.isDebugEnabled()) {
            log.debug("try use default {}", (Object)this.type);
        }
    }

    @Override
    public Optional<String> current() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return Optional.empty();
        }
        String activeId = this.getUsedHistoryQueue().getLast();
        if (this.defaultId.equals(activeId)) {
            return Optional.empty();
        }
        return Optional.of(activeId);
    }

    @Override
    public void reset() {
        this.getUsedHistoryQueue().clear();
        if (log.isDebugEnabled()) {
            log.debug("reset {} history", (Object)this.type);
        }
    }
}

