/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public enum DatabaseType {
    unknown(null, null, null, String::isEmpty),
    mysql("com.mysql.jdbc.Driver", "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource", "select 1", DatabaseType.createUrlPredicate("mysql")),
    h2("org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "select 1", DatabaseType.createUrlPredicate("h2")),
    oracle("oracle.jdbc.driver.OracleDriver", "oracle.jdbc.xa.client.OracleXADataSource", "select 1 from dual", DatabaseType.createUrlPredicate("oracle")),
    jtds_sqlserver("net.sourceforge.jtds.jdbc.Driver", "net.sourceforge.jtds.jdbcx.JtdsDataSource", "select 1 t", DatabaseType.createUrlPredicate("jtds:sqlserver")),
    sqlserver("com.microsoft.sqlserver.jdbc.SQLServerDriver", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "select 1 t", DatabaseType.createUrlPredicate("sqlserver")),
    postgresql("org.postgresql.Driver", "org.postgresql.xa.PGXADataSource", "select 1 ", DatabaseType.createUrlPredicate("postgresql"));

    private final String testQuery;
    private final String driverClassName;
    private final String xaDataSourceClassName;
    private final Predicate<String> urlPredicate;

    static Predicate<String> createUrlPredicate(String name) {
        return url -> {
            String urlWithoutPrefix = url.substring("jdbc".length()).toLowerCase();
            String prefix = ":" + name.toLowerCase() + ":";
            return urlWithoutPrefix.startsWith(prefix);
        };
    }

    private DatabaseType(String driverClassName, String xaDataSourceClassName, String testQuery, Predicate<String> urlPredicate) {
        this.driverClassName = driverClassName;
        this.testQuery = testQuery;
        this.xaDataSourceClassName = xaDataSourceClassName;
        this.urlPredicate = urlPredicate;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public static DatabaseType fromJdbcUrl(String url) {
        if (Objects.nonNull(url)) {
            return Arrays.stream(DatabaseType.values()).filter(type -> type.urlPredicate.test(url)).findFirst().orElse(unknown);
        }
        return unknown;
    }
}

