/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.util.RevengUtils;
import org.hibernate.tool.internal.util.JdbcToHibernateTypeHelper;
import org.hibernate.tool.internal.util.TableNameQualifier;
import org.jboss.logging.Logger;

public class BasicColumnProcessor {
    private static final Logger log = Logger.getLogger(BasicColumnProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processBasicColumns(RevengDialect metaDataDialect, RevengStrategy revengStrategy, String defaultSchema, String defaultCatalog, Table table) {
        String qualify = TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName());
        Iterator<Map<String, Object>> columnIterator = null;
        try {
            Map<String, Object> columnRs = null;
            log.debug((Object)("Finding columns for " + qualify));
            columnIterator = metaDataDialect.getColumns(BasicColumnProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), BasicColumnProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName(), null);
            while (columnIterator.hasNext()) {
                columnRs = columnIterator.next();
                String tableName = (String)columnRs.get("TABLE_NAME");
                int sqlType = (Integer)columnRs.get("DATA_TYPE");
                String columnName = (String)columnRs.get("COLUMN_NAME");
                String comment = (String)columnRs.get("REMARKS");
                TableIdentifier ti = RevengUtils.createTableIdentifier(table, defaultCatalog, defaultSchema);
                if (revengStrategy.excludeColumn(ti, columnName)) {
                    log.debug((Object)("Column " + ti + "." + columnName + " excluded by strategy"));
                    continue;
                }
                if (!tableName.equals(table.getName())) {
                    log.debug((Object)("Table name " + tableName + " does not match requested " + table.getName() + ". Ignoring column " + columnName + " since it either is invalid or a duplicate"));
                    continue;
                }
                int dbNullability = (Integer)columnRs.get("NULLABLE");
                boolean isNullable = true;
                switch (dbNullability) {
                    case 1: 
                    case 2: {
                        isNullable = true;
                        break;
                    }
                    case 0: {
                        isNullable = false;
                        break;
                    }
                    default: {
                        isNullable = true;
                    }
                }
                int size = (Integer)columnRs.get("COLUMN_SIZE");
                int decimalDigits = (Integer)columnRs.get("DECIMAL_DIGITS");
                Column column = new Column();
                column.setName(BasicColumnProcessor.quote(columnName, metaDataDialect));
                Column existing = table.getColumn(column);
                if (existing != null) {
                    throw new RuntimeException(column + " already exists in " + qualify);
                }
                column.setComment(comment);
                column.setSqlTypeCode(Integer.valueOf(sqlType));
                if (BasicColumnProcessor.intBounds(size)) {
                    if (JdbcToHibernateTypeHelper.typeHasLength(sqlType)) {
                        column.setLength(Integer.valueOf(size));
                    }
                    if (JdbcToHibernateTypeHelper.typeHasPrecision(sqlType)) {
                        column.setPrecision(Integer.valueOf(size));
                    }
                }
                if (BasicColumnProcessor.intBounds(decimalDigits) && JdbcToHibernateTypeHelper.typeHasScale(sqlType)) {
                    column.setScale(Integer.valueOf(decimalDigits));
                }
                column.setNullable(isNullable);
                table.addColumn(column);
            }
        }
        finally {
            if (columnIterator != null) {
                try {
                    metaDataDialect.close(columnIterator);
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception while closing iterator for column meta data", (Throwable)se);
                }
            }
        }
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static boolean intBounds(int size) {
        return size >= 0 && size != Integer.MAX_VALUE;
    }

    private static String quote(String columnName, RevengDialect metaDataDialect) {
        if (columnName == null) {
            return columnName;
        }
        if (metaDataDialect.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

