/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.internal.reveng.dialect.ResultSetIterator;
import org.jboss.logging.Logger;

public abstract class AbstractMetaDataDialect
implements RevengDialect {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Connection connection;
    private DatabaseMetaData metaData;
    private ConnectionProvider connectionProvider = null;

    @Override
    public void configure(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public void close() {
        this.metaData = null;
        if (this.connection != null) {
            try {
                this.connectionProvider.closeConnection(this.connection);
            }
            catch (SQLException e) {
                throw new RuntimeException("Problem while closing connection", e);
            }
            finally {
                this.connection = null;
            }
        }
        this.connectionProvider = null;
    }

    protected DatabaseMetaData getMetaData() {
        if (this.metaData == null) {
            try {
                this.metaData = this.getConnection().getMetaData();
            }
            catch (SQLException e) {
                throw new RuntimeException("Getting database metadata", e);
            }
        }
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDatabaseStructure(String catalog, String schema) {
        ResultSet schemaRs = null;
        ResultSet catalogRs = null;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Configured schema:").append(schema).append(nl);
        sb.append("Configured catalog:").append(catalog).append(nl);
        try {
            schemaRs = this.getMetaData().getSchemas();
            sb.append("Available schemas:").append(nl);
            while (schemaRs.next()) {
                sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
            }
        }
        catch (SQLException e2) {
            this.log.warn((Object)"Could not get schemas", (Throwable)e2);
            sb.append("  <SQLException while getting schemas>").append(nl);
        }
        finally {
            try {
                schemaRs.close();
            }
            catch (Exception e2) {}
        }
        try {
            catalogRs = this.getMetaData().getCatalogs();
            sb.append("Available catalogs:").append(nl);
            while (catalogRs.next()) {
                sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
            }
        }
        catch (SQLException e2) {
            this.log.warn((Object)"Could not get catalogs", (Throwable)e2);
            sb.append("  <SQLException while getting catalogs>").append(nl);
        }
        finally {
            try {
                catalogRs.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        return this.connection;
    }

    @Override
    public void close(Iterator<?> iterator) {
        if (iterator instanceof ResultSetIterator) {
            ((ResultSetIterator)iterator).close();
        }
    }

    @Override
    public boolean needQuote(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(45) > 0) {
            return true;
        }
        if (name.indexOf(32) > 0) {
            return true;
        }
        return name.indexOf(46) > 0;
    }

    protected String caseForSearch(String value) throws SQLException {
        if (this.needQuote(value)) {
            if (this.getMetaData().storesMixedCaseQuotedIdentifiers()) {
                return value;
            }
            if (this.getMetaData().storesUpperCaseQuotedIdentifiers()) {
                return this.toUpperCase(value);
            }
            if (this.getMetaData().storesLowerCaseQuotedIdentifiers()) {
                return this.toLowerCase(value);
            }
            return value;
        }
        if (this.getMetaData().storesMixedCaseQuotedIdentifiers()) {
            return value;
        }
        if (this.getMetaData().storesUpperCaseIdentifiers()) {
            return this.toUpperCase(value);
        }
        if (this.getMetaData().storesLowerCaseIdentifiers()) {
            return this.toLowerCase(value);
        }
        return value;
    }

    private String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    private String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public Iterator<Map<String, Object>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("TABLE_CAT", catalog);
        m.put("TABLE_SCHEMA", schema);
        m.put("TABLE_NAME", table);
        m.put("HIBERNATE_STRATEGY", null);
        ArrayList<HashMap<String, String>> l = new ArrayList<HashMap<String, String>>();
        l.add(m);
        return l.iterator();
    }
}

