/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.metadata;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Environment;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.RevengStrategyFactory;
import org.hibernate.tool.internal.reveng.RevengMetadataBuilder;

public class RevengMetadataDescriptor
implements MetadataDescriptor {
    private RevengStrategy reverseEngineeringStrategy = null;
    private Properties properties = new Properties();

    public RevengMetadataDescriptor(RevengStrategy reverseEngineeringStrategy, Properties properties) {
        this.properties.putAll((Map<?, ?>)Environment.getProperties());
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        this.reverseEngineeringStrategy = reverseEngineeringStrategy != null ? reverseEngineeringStrategy : RevengStrategyFactory.createReverseEngineeringStrategy();
        if (this.properties.get("org.hibernate.tool.api.metadata.MetadataConstants.PreferBasicCompositeIds") == null) {
            this.properties.put("org.hibernate.tool.api.metadata.MetadataConstants.PreferBasicCompositeIds", (Object)true);
        }
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    @Override
    public Metadata createMetadata() {
        return RevengMetadataBuilder.create(this.properties, this.reverseEngineeringStrategy).build();
    }
}

