/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.metadata;

import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.tool.api.metadata.MetadataDescriptor;

public class JpaMetadataDescriptor
implements MetadataDescriptor {
    private Properties properties = new Properties();
    private Metadata metadata = null;

    public JpaMetadataDescriptor(String persistenceUnit, Properties properties) {
        EntityManagerFactoryBuilderImpl entityManagerFactoryBuilder = JpaMetadataDescriptor.createEntityManagerFactoryBuilder(persistenceUnit, properties);
        EntityManagerFactory entityManagerFactory = entityManagerFactoryBuilder.build();
        this.metadata = entityManagerFactoryBuilder.getMetadata();
        properties.putAll((Map<?, ?>)entityManagerFactory.getProperties());
    }

    @Override
    public Metadata createMetadata() {
        return this.metadata;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private static EntityManagerFactoryBuilderImpl createEntityManagerFactoryBuilder(String persistenceUnit, Properties properties) {
        return new PersistenceProvider().getEntityManagerFactoryBuilder(persistenceUnit, properties);
    }

    private static class PersistenceProvider
    extends HibernatePersistenceProvider {
        private PersistenceProvider() {
        }

        public EntityManagerFactoryBuilderImpl getEntityManagerFactoryBuilder(String persistenceUnit, Properties properties) {
            EntityManagerFactoryBuilderImpl result = (EntityManagerFactoryBuilderImpl)this.getEntityManagerFactoryBuilderOrNull(persistenceUnit, properties);
            if (result == null) {
                throw new HibernateException("Persistence unit not found: '" + persistenceUnit + "'.");
            }
            return result;
        }
    }
}

