/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.internal.export.common.EntityNameFromValueVisitor;
import org.hibernate.tool.internal.export.lint.EntityModelDetector;
import org.hibernate.tool.internal.export.lint.Issue;
import org.hibernate.tool.internal.export.lint.IssueCollector;

public class BadCachingDetector
extends EntityModelDetector {
    @Override
    public String getName() {
        return "cache";
    }

    @Override
    protected void visitProperty(PersistentClass clazz, Property property, IssueCollector collector) {
        PersistentClass classMapping;
        String entityName;
        Collection col;
        Value value = property.getValue();
        if (value instanceof Collection && (col = (Collection)value).getCacheConcurrencyStrategy() != null && !col.getElement().isSimpleValue() && (entityName = (String)col.getElement().accept((ValueVisitor)new EntityNameFromValueVisitor())) != null && (classMapping = this.getMetadata().getEntityBinding(entityName)).getCacheConcurrencyStrategy() == null) {
            collector.reportIssue(new Issue("CACHE_COLLECTION_NONCACHABLE_TARGET", 100, "Entity '" + classMapping.getEntityName() + "' is referenced from the cache-enabled collection '" + col.getRole() + "' without the entity being cachable"));
        }
    }
}

