/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class SynchronizedHistogram
extends AbstractHistogram {
    long totalCount;
    final long[] counts = new long[this.countsArrayLength];
    private LongBuffer cachedDstLongBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtNormalizedIndex(int index) {
        return this.counts[index];
    }

    @Override
    synchronized void incrementCountAtNormalizedIndex(int index) {
        int n = index;
        this.counts[n] = this.counts[n] + 1L;
    }

    @Override
    synchronized void addToCountAtNormalizedIndex(int index, long value) {
        int n = index;
        this.counts[n] = this.counts[n] + value;
    }

    @Override
    void setCountAtNormalizedIndex(int index, long value) {
        this.counts[index] = value;
    }

    @Override
    synchronized void clearCounts() {
        Arrays.fill(this.counts, 0L);
        this.totalCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AbstractHistogram otherHistogram) {
        if (this.identity < otherHistogram.identity) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                AbstractHistogram abstractHistogram = otherHistogram;
                synchronized (abstractHistogram) {
                    super.add(otherHistogram);
                }
            }
        }
        AbstractHistogram abstractHistogram = otherHistogram;
        synchronized (abstractHistogram) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                super.add(otherHistogram);
            }
        }
    }

    @Override
    public synchronized void shiftValuesLeft(int numberOfBinaryOrdersOfMagnitude) {
        super.shiftValuesLeft(numberOfBinaryOrdersOfMagnitude);
    }

    @Override
    public synchronized void shiftValuesRight(int numberOfBinaryOrdersOfMagnitude) {
        super.shiftValuesRight(numberOfBinaryOrdersOfMagnitude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedHistogram copy() {
        SynchronizedHistogram copy;
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            copy = new SynchronizedHistogram(this);
        }
        copy.add(this);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            SynchronizedHistogram toHistogram = new SynchronizedHistogram(this);
            toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
            return toHistogram;
        }
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    synchronized void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    synchronized void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    synchronized void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    synchronized void updatedMaxValue(long maxValue) {
        if (maxValue > this.getMaxValue()) {
            super.updatedMaxValue(maxValue);
        }
    }

    @Override
    synchronized void updateMinNonZeroValue(long minNonZeroValue) {
        if (minNonZeroValue < this.getMinNonZeroValue()) {
            super.updateMinNonZeroValue(minNonZeroValue);
        }
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length;
    }

    public SynchronizedHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SynchronizedHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 8;
    }

    public SynchronizedHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 8;
    }

    public static SynchronizedHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    public static SynchronizedHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromCompressedByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asLongBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstLongBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstLongBuffer = buffer.asLongBuffer();
        }
        this.cachedDstLongBuffer.rewind();
        this.cachedDstLongBuffer.put(this.counts, 0, length);
    }
}

