/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.WriterReaderPhaser;

public class IntervalDoubleHistogramRecorder {
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile DoubleHistogram activeHistogram;
    private DoubleHistogram inactiveHistogram;

    public IntervalDoubleHistogramRecorder(long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
        this.activeHistogram = new DoubleHistogram(highestToLowestValueRatio, numberOfSignificantValueDigits, AtomicHistogram.class);
        this.inactiveHistogram = new DoubleHistogram(highestToLowestValueRatio, numberOfSignificantValueDigits, AtomicHistogram.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceValueIntoRange(double value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithCount(value, 0L);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValue(double value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValueWithExpectedInterval(double value, double expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized DoubleHistogram getIntervalHistogram() {
        DoubleHistogram intervalHistogram = new DoubleHistogram(this.inactiveHistogram);
        this.getIntervalHistogramInto(intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void getIntervalHistogramInto(DoubleHistogram targetHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(targetHistogram);
    }

    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        this.inactiveHistogram.reset();
        try {
            this.recordingPhaser.readerLock();
            DoubleHistogram tempHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = tempHistogram;
            long now = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(now);
            this.inactiveHistogram.setEndTimeStamp(now);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }
}

