/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.WriterReaderPhaser;

public class IntervalHistogramRecorder {
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile AtomicHistogram activeHistogram;
    private AtomicHistogram inactiveHistogram;

    public IntervalHistogramRecorder(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public IntervalHistogramRecorder(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.activeHistogram = new AtomicHistogram(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.inactiveHistogram = new AtomicHistogram(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValue(long value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized Histogram getIntervalHistogram() {
        Histogram intervalHistogram = new Histogram(this.inactiveHistogram);
        this.getIntervalHistogramInto(intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void getIntervalHistogramInto(AbstractHistogram targetHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(targetHistogram);
    }

    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        this.inactiveHistogram.reset();
        try {
            this.recordingPhaser.readerLock();
            AtomicHistogram tempHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = tempHistogram;
            long now = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(now);
            this.inactiveHistogram.setEndTimeStamp(now);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }
}

