/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ko" locale.
 */
public class LocalizedNamesImpl_ko extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KR",
        "KP",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "GH",
        "GA",
        "GY",
        "GM",
        "GG",
        "GP",
        "GT",
        "GU",
        "GD",
        "GR",
        "GL",
        "GN",
        "GW",
        "NA",
        "NR",
        "NG",
        "AQ",
        "SS",
        "ZA",
        "NL",
        "BQ",
        "NP",
        "NO",
        "NF",
        "NZ",
        "NC",
        "NU",
        "NE",
        "NI",
        "TW",
        "KR",
        "DK",
        "DM",
        "DO",
        "DE",
        "TL",
        "DG",
        "LA",
        "LR",
        "LV",
        "RU",
        "LB",
        "LS",
        "RO",
        "LU",
        "RW",
        "LY",
        "RE",
        "LT",
        "LI",
        "MG",
        "MQ",
        "MH",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "IM",
        "MX",
        "MC",
        "MA",
        "MU",
        "MR",
        "MZ",
        "ME",
        "MS",
        "MD",
        "MV",
        "MT",
        "MN",
        "US",
        "VI",
        "UM",
        "MM",
        "FM",
        "VU",
        "BH",
        "BB",
        "VA",
        "BS",
        "BD",
        "BM",
        "BJ",
        "VE",
        "VN",
        "BE",
        "BY",
        "BZ",
        "BA",
        "BW",
        "BO",
        "BI",
        "BF",
        "BV",
        "BT",
        "MP",
        "KP",
        "BG",
        "BR",
        "BN",
        "WS",
        "SA",
        "GS",
        "SM",
        "ST",
        "MF",
        "BL",
        "PM",
        "EH",
        "SN",
        "RS",
        "EA",
        "SC",
        "LC",
        "VC",
        "KN",
        "SH",
        "SO",
        "SB",
        "SD",
        "SR",
        "LK",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "ES",
        "SK",
        "SI",
        "SY",
        "SL",
        "SX",
        "SG",
        "AE",
        "AW",
        "AM",
        "AR",
        "AS",
        "IS",
        "HT",
        "IE",
        "AZ",
        "AF",
        "AD",
        "AL",
        "DZ",
        "AO",
        "AG",
        "AI",
        "AC",
        "ER",
        "EE",
        "EC",
        "ET",
        "SV",
        "GB",
        "VG",
        "IO",
        "YE",
        "OM",
        "QO",
        "AU",
        "AT",
        "HN",
        "AX",
        "WF",
        "JO",
        "UG",
        "UY",
        "UZ",
        "UA",
        "EU",
        "EZ",
        "UN",
        "IQ",
        "IR",
        "IL",
        "EG",
        "IT",
        "IN",
        "ID",
        "JP",
        "JM",
        "ZM",
        "JE",
        "GQ",
        "GE",
        "CN",
        "CF",
        "DJ",
        "GI",
        "ZW",
        "TD",
        "CZ",
        "CL",
        "IC",
        "CM",
        "CV",
        "KZ",
        "QA",
        "KH",
        "CA",
        "KE",
        "KY",
        "KM",
        "XK",
        "CR",
        "CC",
        "CI",
        "CO",
        "CG",
        "CD",
        "CU",
        "KW",
        "CK",
        "CW",
        "HR",
        "CX",
        "CP",
        "KG",
        "KI",
        "CY",
        "TJ",
        "TZ",
        "TH",
        "TC",
        "TR",
        "TG",
        "TK",
        "TO",
        "TM",
        "TV",
        "TN",
        "TT",
        "TA",
        "PA",
        "PY",
        "PK",
        "PG",
        "PW",
        "PS",
        "FO",
        "PE",
        "PT",
        "FK",
        "PL",
        "PR",
        "FR",
        "TF",
        "GF",
        "PF",
        "FJ",
        "FI",
        "PH",
        "PN",
        "HM",
        "HU",
        "HK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "세계");
    namesMap.put("002", "아프리카");
    namesMap.put("003", "북아메리카");
    namesMap.put("005", "남아메리카(남미)");
    namesMap.put("009", "오세아니아");
    namesMap.put("011", "서부 아프리카");
    namesMap.put("013", "중앙 아메리카");
    namesMap.put("014", "동부 아프리카");
    namesMap.put("015", "북부 아프리카");
    namesMap.put("017", "중부 아프리카");
    namesMap.put("018", "남부 아프리카");
    namesMap.put("019", "아메리카 대륙");
    namesMap.put("021", "북부 아메리카");
    namesMap.put("029", "카리브 제도");
    namesMap.put("030", "동아시아");
    namesMap.put("034", "남아시아");
    namesMap.put("035", "동남아시아");
    namesMap.put("039", "남유럽");
    namesMap.put("053", "오스트랄라시아");
    namesMap.put("054", "멜라네시아");
    namesMap.put("057", "미크로네시아 지역");
    namesMap.put("061", "폴리네시아");
    namesMap.put("142", "아시아");
    namesMap.put("143", "중앙 아시아");
    namesMap.put("145", "서아시아");
    namesMap.put("150", "유럽");
    namesMap.put("151", "동유럽");
    namesMap.put("154", "북유럽");
    namesMap.put("155", "서유럽");
    namesMap.put("202", "사하라 사막 이남 아프리카");
    namesMap.put("419", "라틴 아메리카");
    namesMap.put("AC", "어센션 섬");
    namesMap.put("AD", "안도라");
    namesMap.put("AE", "아랍에미리트");
    namesMap.put("AF", "아프가니스탄");
    namesMap.put("AG", "앤티가 바부다");
    namesMap.put("AI", "앵귈라");
    namesMap.put("AL", "알바니아");
    namesMap.put("AM", "아르메니아");
    namesMap.put("AO", "앙골라");
    namesMap.put("AQ", "남극 대륙");
    namesMap.put("AR", "아르헨티나");
    namesMap.put("AS", "아메리칸 사모아");
    namesMap.put("AT", "오스트리아");
    namesMap.put("AU", "오스트레일리아");
    namesMap.put("AW", "아루바");
    namesMap.put("AX", "올란드 제도");
    namesMap.put("AZ", "아제르바이잔");
    namesMap.put("BA", "보스니아 헤르체고비나");
    namesMap.put("BB", "바베이도스");
    namesMap.put("BD", "방글라데시");
    namesMap.put("BE", "벨기에");
    namesMap.put("BF", "부르키나파소");
    namesMap.put("BG", "불가리아");
    namesMap.put("BH", "바레인");
    namesMap.put("BI", "부룬디");
    namesMap.put("BJ", "베냉");
    namesMap.put("BL", "생바르텔레미");
    namesMap.put("BM", "버뮤다");
    namesMap.put("BN", "브루나이");
    namesMap.put("BO", "볼리비아");
    namesMap.put("BQ", "네덜란드령 카리브");
    namesMap.put("BR", "브라질");
    namesMap.put("BS", "바하마");
    namesMap.put("BT", "부탄");
    namesMap.put("BV", "부베섬");
    namesMap.put("BW", "보츠와나");
    namesMap.put("BY", "벨라루스");
    namesMap.put("BZ", "벨리즈");
    namesMap.put("CA", "캐나다");
    namesMap.put("CC", "코코스 제도");
    namesMap.put("CD", "콩고-킨샤사");
    namesMap.put("CF", "중앙 아프리카 공화국");
    namesMap.put("CG", "콩고-브라자빌");
    namesMap.put("CH", "스위스");
    namesMap.put("CI", "코트디부아르");
    namesMap.put("CK", "쿡 제도");
    namesMap.put("CL", "칠레");
    namesMap.put("CM", "카메룬");
    namesMap.put("CN", "중국");
    namesMap.put("CO", "콜롬비아");
    namesMap.put("CP", "클립퍼튼 섬");
    namesMap.put("CR", "코스타리카");
    namesMap.put("CU", "쿠바");
    namesMap.put("CV", "카보베르데");
    namesMap.put("CW", "퀴라소");
    namesMap.put("CX", "크리스마스섬");
    namesMap.put("CY", "키프로스");
    namesMap.put("CZ", "체코");
    namesMap.put("DE", "독일");
    namesMap.put("DG", "디에고 가르시아");
    namesMap.put("DJ", "지부티");
    namesMap.put("DK", "덴마크");
    namesMap.put("DM", "도미니카");
    namesMap.put("DO", "도미니카 공화국");
    namesMap.put("DZ", "알제리");
    namesMap.put("EA", "세우타 및 멜리야");
    namesMap.put("EC", "에콰도르");
    namesMap.put("EE", "에스토니아");
    namesMap.put("EG", "이집트");
    namesMap.put("EH", "서사하라");
    namesMap.put("ER", "에리트리아");
    namesMap.put("ES", "스페인");
    namesMap.put("ET", "에티오피아");
    namesMap.put("EU", "유럽 연합");
    namesMap.put("EZ", "유로존");
    namesMap.put("FI", "핀란드");
    namesMap.put("FJ", "피지");
    namesMap.put("FK", "포클랜드 제도");
    namesMap.put("FM", "미크로네시아");
    namesMap.put("FO", "페로 제도");
    namesMap.put("FR", "프랑스");
    namesMap.put("GA", "가봉");
    namesMap.put("GB", "영국");
    namesMap.put("GD", "그레나다");
    namesMap.put("GE", "조지아");
    namesMap.put("GF", "프랑스령 기아나");
    namesMap.put("GG", "건지");
    namesMap.put("GH", "가나");
    namesMap.put("GI", "지브롤터");
    namesMap.put("GL", "그린란드");
    namesMap.put("GM", "감비아");
    namesMap.put("GN", "기니");
    namesMap.put("GP", "과들루프");
    namesMap.put("GQ", "적도 기니");
    namesMap.put("GR", "그리스");
    namesMap.put("GS", "사우스조지아 사우스샌드위치 제도");
    namesMap.put("GT", "과테말라");
    namesMap.put("GU", "괌");
    namesMap.put("GW", "기니비사우");
    namesMap.put("GY", "가이아나");
    namesMap.put("HK", "홍콩(중국 특별행정구)");
    namesMap.put("HM", "허드 맥도널드 제도");
    namesMap.put("HN", "온두라스");
    namesMap.put("HR", "크로아티아");
    namesMap.put("HT", "아이티");
    namesMap.put("HU", "헝가리");
    namesMap.put("IC", "카나리아 제도");
    namesMap.put("ID", "인도네시아");
    namesMap.put("IE", "아일랜드");
    namesMap.put("IL", "이스라엘");
    namesMap.put("IM", "맨 섬");
    namesMap.put("IN", "인도");
    namesMap.put("IO", "영국령 인도양 식민지");
    namesMap.put("IQ", "이라크");
    namesMap.put("IR", "이란");
    namesMap.put("IS", "아이슬란드");
    namesMap.put("IT", "이탈리아");
    namesMap.put("JE", "저지");
    namesMap.put("JM", "자메이카");
    namesMap.put("JO", "요르단");
    namesMap.put("JP", "일본");
    namesMap.put("KE", "케냐");
    namesMap.put("KG", "키르기스스탄");
    namesMap.put("KH", "캄보디아");
    namesMap.put("KI", "키리바시");
    namesMap.put("KM", "코모로");
    namesMap.put("KN", "세인트키츠 네비스");
    namesMap.put("KP", "북한");
    namesMap.put("KR", "대한민국");
    namesMap.put("KW", "쿠웨이트");
    namesMap.put("KY", "케이맨 제도");
    namesMap.put("KZ", "카자흐스탄");
    namesMap.put("LA", "라오스");
    namesMap.put("LB", "레바논");
    namesMap.put("LC", "세인트루시아");
    namesMap.put("LI", "리히텐슈타인");
    namesMap.put("LK", "스리랑카");
    namesMap.put("LR", "라이베리아");
    namesMap.put("LS", "레소토");
    namesMap.put("LT", "리투아니아");
    namesMap.put("LU", "룩셈부르크");
    namesMap.put("LV", "라트비아");
    namesMap.put("LY", "리비아");
    namesMap.put("MA", "모로코");
    namesMap.put("MC", "모나코");
    namesMap.put("MD", "몰도바");
    namesMap.put("ME", "몬테네그로");
    namesMap.put("MF", "생마르탱");
    namesMap.put("MG", "마다가스카르");
    namesMap.put("MH", "마셜 제도");
    namesMap.put("MK", "마케도니아");
    namesMap.put("ML", "말리");
    namesMap.put("MM", "미얀마");
    namesMap.put("MN", "몽골");
    namesMap.put("MO", "마카오(중국 특별행정구)");
    namesMap.put("MP", "북마리아나제도");
    namesMap.put("MQ", "마르티니크");
    namesMap.put("MR", "모리타니");
    namesMap.put("MS", "몬트세라트");
    namesMap.put("MT", "몰타");
    namesMap.put("MU", "모리셔스");
    namesMap.put("MV", "몰디브");
    namesMap.put("MW", "말라위");
    namesMap.put("MX", "멕시코");
    namesMap.put("MY", "말레이시아");
    namesMap.put("MZ", "모잠비크");
    namesMap.put("NA", "나미비아");
    namesMap.put("NC", "뉴칼레도니아");
    namesMap.put("NE", "니제르");
    namesMap.put("NF", "노퍽섬");
    namesMap.put("NG", "나이지리아");
    namesMap.put("NI", "니카라과");
    namesMap.put("NL", "네덜란드");
    namesMap.put("NO", "노르웨이");
    namesMap.put("NP", "네팔");
    namesMap.put("NR", "나우루");
    namesMap.put("NU", "니우에");
    namesMap.put("NZ", "뉴질랜드");
    namesMap.put("OM", "오만");
    namesMap.put("PA", "파나마");
    namesMap.put("PE", "페루");
    namesMap.put("PF", "프랑스령 폴리네시아");
    namesMap.put("PG", "파푸아뉴기니");
    namesMap.put("PH", "필리핀");
    namesMap.put("PK", "파키스탄");
    namesMap.put("PL", "폴란드");
    namesMap.put("PM", "생피에르 미클롱");
    namesMap.put("PN", "핏케언 섬");
    namesMap.put("PR", "푸에르토리코");
    namesMap.put("PS", "팔레스타인 지구");
    namesMap.put("PT", "포르투갈");
    namesMap.put("PW", "팔라우");
    namesMap.put("PY", "파라과이");
    namesMap.put("QA", "카타르");
    namesMap.put("QO", "오세아니아 외곽");
    namesMap.put("RE", "리유니온");
    namesMap.put("RO", "루마니아");
    namesMap.put("RS", "세르비아");
    namesMap.put("RU", "러시아");
    namesMap.put("RW", "르완다");
    namesMap.put("SA", "사우디아라비아");
    namesMap.put("SB", "솔로몬 제도");
    namesMap.put("SC", "세이셸");
    namesMap.put("SD", "수단");
    namesMap.put("SE", "스웨덴");
    namesMap.put("SG", "싱가포르");
    namesMap.put("SH", "세인트헬레나");
    namesMap.put("SI", "슬로베니아");
    namesMap.put("SJ", "스발바르제도-얀마웬섬");
    namesMap.put("SK", "슬로바키아");
    namesMap.put("SL", "시에라리온");
    namesMap.put("SM", "산마리노");
    namesMap.put("SN", "세네갈");
    namesMap.put("SO", "소말리아");
    namesMap.put("SR", "수리남");
    namesMap.put("SS", "남수단");
    namesMap.put("ST", "상투메 프린시페");
    namesMap.put("SV", "엘살바도르");
    namesMap.put("SX", "신트마르턴");
    namesMap.put("SY", "시리아");
    namesMap.put("SZ", "스와질란드");
    namesMap.put("TA", "트리스탄다쿠나");
    namesMap.put("TC", "터크스 케이커스 제도");
    namesMap.put("TD", "차드");
    namesMap.put("TF", "프랑스 남부 지방");
    namesMap.put("TG", "토고");
    namesMap.put("TH", "태국");
    namesMap.put("TJ", "타지키스탄");
    namesMap.put("TK", "토켈라우");
    namesMap.put("TL", "동티모르");
    namesMap.put("TM", "투르크메니스탄");
    namesMap.put("TN", "튀니지");
    namesMap.put("TO", "통가");
    namesMap.put("TR", "터키");
    namesMap.put("TT", "트리니다드 토바고");
    namesMap.put("TV", "투발루");
    namesMap.put("TW", "대만");
    namesMap.put("TZ", "탄자니아");
    namesMap.put("UA", "우크라이나");
    namesMap.put("UG", "우간다");
    namesMap.put("UM", "미국령 해외 제도");
    namesMap.put("UN", "유엔");
    namesMap.put("US", "미국");
    namesMap.put("UY", "우루과이");
    namesMap.put("UZ", "우즈베키스탄");
    namesMap.put("VA", "바티칸 시국");
    namesMap.put("VC", "세인트빈센트그레나딘");
    namesMap.put("VE", "베네수엘라");
    namesMap.put("VG", "영국령 버진아일랜드");
    namesMap.put("VI", "미국령 버진아일랜드");
    namesMap.put("VN", "베트남");
    namesMap.put("VU", "바누아투");
    namesMap.put("WF", "왈리스-푸투나 제도");
    namesMap.put("WS", "사모아");
    namesMap.put("XK", "코소보");
    namesMap.put("YE", "예멘");
    namesMap.put("YT", "마요트");
    namesMap.put("ZA", "남아프리카");
    namesMap.put("ZM", "잠비아");
    namesMap.put("ZW", "짐바브웨");
    namesMap.put("ZZ", "알려지지 않은 지역");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "세계",
        "002": "아프리카",
        "003": "북아메리카",
        "005": "남아메리카(남미)",
        "009": "오세아니아",
        "011": "서부 아프리카",
        "013": "중앙 아메리카",
        "014": "동부 아프리카",
        "015": "북부 아프리카",
        "017": "중부 아프리카",
        "018": "남부 아프리카",
        "019": "아메리카 대륙",
        "021": "북부 아메리카",
        "029": "카리브 제도",
        "030": "동아시아",
        "034": "남아시아",
        "035": "동남아시아",
        "039": "남유럽",
        "053": "오스트랄라시아",
        "054": "멜라네시아",
        "057": "미크로네시아 지역",
        "061": "폴리네시아",
        "142": "아시아",
        "143": "중앙 아시아",
        "145": "서아시아",
        "150": "유럽",
        "151": "동유럽",
        "154": "북유럽",
        "155": "서유럽",
        "202": "사하라 사막 이남 아프리카",
        "419": "라틴 아메리카",
        "AC": "어센션 섬",
        "AD": "안도라",
        "AE": "아랍에미리트",
        "AF": "아프가니스탄",
        "AG": "앤티가 바부다",
        "AI": "앵귈라",
        "AL": "알바니아",
        "AM": "아르메니아",
        "AO": "앙골라",
        "AQ": "남극 대륙",
        "AR": "아르헨티나",
        "AS": "아메리칸 사모아",
        "AT": "오스트리아",
        "AU": "오스트레일리아",
        "AW": "아루바",
        "AX": "올란드 제도",
        "AZ": "아제르바이잔",
        "BA": "보스니아 헤르체고비나",
        "BB": "바베이도스",
        "BD": "방글라데시",
        "BE": "벨기에",
        "BF": "부르키나파소",
        "BG": "불가리아",
        "BH": "바레인",
        "BI": "부룬디",
        "BJ": "베냉",
        "BL": "생바르텔레미",
        "BM": "버뮤다",
        "BN": "브루나이",
        "BO": "볼리비아",
        "BQ": "네덜란드령 카리브",
        "BR": "브라질",
        "BS": "바하마",
        "BT": "부탄",
        "BV": "부베섬",
        "BW": "보츠와나",
        "BY": "벨라루스",
        "BZ": "벨리즈",
        "CA": "캐나다",
        "CC": "코코스 제도",
        "CD": "콩고-킨샤사",
        "CF": "중앙 아프리카 공화국",
        "CG": "콩고-브라자빌",
        "CH": "스위스",
        "CI": "코트디부아르",
        "CK": "쿡 제도",
        "CL": "칠레",
        "CM": "카메룬",
        "CN": "중국",
        "CO": "콜롬비아",
        "CP": "클립퍼튼 섬",
        "CR": "코스타리카",
        "CU": "쿠바",
        "CV": "카보베르데",
        "CW": "퀴라소",
        "CX": "크리스마스섬",
        "CY": "키프로스",
        "CZ": "체코",
        "DE": "독일",
        "DG": "디에고 가르시아",
        "DJ": "지부티",
        "DK": "덴마크",
        "DM": "도미니카",
        "DO": "도미니카 공화국",
        "DZ": "알제리",
        "EA": "세우타 및 멜리야",
        "EC": "에콰도르",
        "EE": "에스토니아",
        "EG": "이집트",
        "EH": "서사하라",
        "ER": "에리트리아",
        "ES": "스페인",
        "ET": "에티오피아",
        "EU": "유럽 연합",
        "EZ": "유로존",
        "FI": "핀란드",
        "FJ": "피지",
        "FK": "포클랜드 제도",
        "FM": "미크로네시아",
        "FO": "페로 제도",
        "FR": "프랑스",
        "GA": "가봉",
        "GB": "영국",
        "GD": "그레나다",
        "GE": "조지아",
        "GF": "프랑스령 기아나",
        "GG": "건지",
        "GH": "가나",
        "GI": "지브롤터",
        "GL": "그린란드",
        "GM": "감비아",
        "GN": "기니",
        "GP": "과들루프",
        "GQ": "적도 기니",
        "GR": "그리스",
        "GS": "사우스조지아 사우스샌드위치 제도",
        "GT": "과테말라",
        "GU": "괌",
        "GW": "기니비사우",
        "GY": "가이아나",
        "HK": "홍콩(중국 특별행정구)",
        "HM": "허드 맥도널드 제도",
        "HN": "온두라스",
        "HR": "크로아티아",
        "HT": "아이티",
        "HU": "헝가리",
        "IC": "카나리아 제도",
        "ID": "인도네시아",
        "IE": "아일랜드",
        "IL": "이스라엘",
        "IM": "맨 섬",
        "IN": "인도",
        "IO": "영국령 인도양 식민지",
        "IQ": "이라크",
        "IR": "이란",
        "IS": "아이슬란드",
        "IT": "이탈리아",
        "JE": "저지",
        "JM": "자메이카",
        "JO": "요르단",
        "JP": "일본",
        "KE": "케냐",
        "KG": "키르기스스탄",
        "KH": "캄보디아",
        "KI": "키리바시",
        "KM": "코모로",
        "KN": "세인트키츠 네비스",
        "KP": "북한",
        "KR": "대한민국",
        "KW": "쿠웨이트",
        "KY": "케이맨 제도",
        "KZ": "카자흐스탄",
        "LA": "라오스",
        "LB": "레바논",
        "LC": "세인트루시아",
        "LI": "리히텐슈타인",
        "LK": "스리랑카",
        "LR": "라이베리아",
        "LS": "레소토",
        "LT": "리투아니아",
        "LU": "룩셈부르크",
        "LV": "라트비아",
        "LY": "리비아",
        "MA": "모로코",
        "MC": "모나코",
        "MD": "몰도바",
        "ME": "몬테네그로",
        "MF": "생마르탱",
        "MG": "마다가스카르",
        "MH": "마셜 제도",
        "MK": "마케도니아",
        "ML": "말리",
        "MM": "미얀마",
        "MN": "몽골",
        "MO": "마카오(중국 특별행정구)",
        "MP": "북마리아나제도",
        "MQ": "마르티니크",
        "MR": "모리타니",
        "MS": "몬트세라트",
        "MT": "몰타",
        "MU": "모리셔스",
        "MV": "몰디브",
        "MW": "말라위",
        "MX": "멕시코",
        "MY": "말레이시아",
        "MZ": "모잠비크",
        "NA": "나미비아",
        "NC": "뉴칼레도니아",
        "NE": "니제르",
        "NF": "노퍽섬",
        "NG": "나이지리아",
        "NI": "니카라과",
        "NL": "네덜란드",
        "NO": "노르웨이",
        "NP": "네팔",
        "NR": "나우루",
        "NU": "니우에",
        "NZ": "뉴질랜드",
        "OM": "오만",
        "PA": "파나마",
        "PE": "페루",
        "PF": "프랑스령 폴리네시아",
        "PG": "파푸아뉴기니",
        "PH": "필리핀",
        "PK": "파키스탄",
        "PL": "폴란드",
        "PM": "생피에르 미클롱",
        "PN": "핏케언 섬",
        "PR": "푸에르토리코",
        "PS": "팔레스타인 지구",
        "PT": "포르투갈",
        "PW": "팔라우",
        "PY": "파라과이",
        "QA": "카타르",
        "QO": "오세아니아 외곽",
        "RE": "리유니온",
        "RO": "루마니아",
        "RS": "세르비아",
        "RU": "러시아",
        "RW": "르완다",
        "SA": "사우디아라비아",
        "SB": "솔로몬 제도",
        "SC": "세이셸",
        "SD": "수단",
        "SE": "스웨덴",
        "SG": "싱가포르",
        "SH": "세인트헬레나",
        "SI": "슬로베니아",
        "SJ": "스발바르제도-얀마웬섬",
        "SK": "슬로바키아",
        "SL": "시에라리온",
        "SM": "산마리노",
        "SN": "세네갈",
        "SO": "소말리아",
        "SR": "수리남",
        "SS": "남수단",
        "ST": "상투메 프린시페",
        "SV": "엘살바도르",
        "SX": "신트마르턴",
        "SY": "시리아",
        "SZ": "스와질란드",
        "TA": "트리스탄다쿠나",
        "TC": "터크스 케이커스 제도",
        "TD": "차드",
        "TF": "프랑스 남부 지방",
        "TG": "토고",
        "TH": "태국",
        "TJ": "타지키스탄",
        "TK": "토켈라우",
        "TL": "동티모르",
        "TM": "투르크메니스탄",
        "TN": "튀니지",
        "TO": "통가",
        "TR": "터키",
        "TT": "트리니다드 토바고",
        "TV": "투발루",
        "TW": "대만",
        "TZ": "탄자니아",
        "UA": "우크라이나",
        "UG": "우간다",
        "UM": "미국령 해외 제도",
        "UN": "유엔",
        "US": "미국",
        "UY": "우루과이",
        "UZ": "우즈베키스탄",
        "VA": "바티칸 시국",
        "VC": "세인트빈센트그레나딘",
        "VE": "베네수엘라",
        "VG": "영국령 버진아일랜드",
        "VI": "미국령 버진아일랜드",
        "VN": "베트남",
        "VU": "바누아투",
        "WF": "왈리스-푸투나 제도",
        "WS": "사모아",
        "XK": "코소보",
        "YE": "예멘",
        "YT": "마요트",
        "ZA": "남아프리카",
        "ZM": "잠비아",
        "ZW": "짐바브웨",
        "ZZ": "알려지지 않은 지역"
    };
  }-*/;
}
