/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "he" locale.
 */
public class LocalizedNamesImpl_he extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IL",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "UG",
        "UZ",
        "AT",
        "AU",
        "UA",
        "UY",
        "AZ",
        "CX",
        "AE",
        "IT",
        "AX",
        "BS",
        "VG",
        "VI",
        "HM",
        "WF",
        "TC",
        "MP",
        "MH",
        "SC",
        "FO",
        "FK",
        "PN",
        "CK",
        "CC",
        "KY",
        "SB",
        "ID",
        "IS",
        "IR",
        "IE",
        "AL",
        "DZ",
        "SV",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "EE",
        "AF",
        "EC",
        "AR",
        "AW",
        "ER",
        "AM",
        "US",
        "ET",
        "BT",
        "BG",
        "BO",
        "BA",
        "BW",
        "BI",
        "BF",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BB",
        "BN",
        "BR",
        "GB",
        "BM",
        "GS",
        "DJ",
        "JM",
        "JE",
        "GE",
        "GH",
        "GA",
        "GT",
        "GU",
        "GP",
        "EZ",
        "GY",
        "GF",
        "GI",
        "GN",
        "GW",
        "GQ",
        "GM",
        "GL",
        "DE",
        "GD",
        "GG",
        "DM",
        "DG",
        "DK",
        "ZA",
        "SS",
        "UN",
        "AC",
        "BV",
        "EU",
        "HT",
        "MV",
        "UM",
        "IC",
        "BQ",
        "IM",
        "NF",
        "CP",
        "IN",
        "VA",
        "NL",
        "HK",
        "HU",
        "HN",
        "IO",
        "TF",
        "PH",
        "DO",
        "CF",
        "PS",
        "VN",
        "VU",
        "VE",
        "ZW",
        "ZM",
        "CI",
        "TJ",
        "TV",
        "TG",
        "TO",
        "TK",
        "TR",
        "TM",
        "TW",
        "TL",
        "TZ",
        "QO",
        "TT",
        "TA",
        "GR",
        "JP",
        "JO",
        "IL",
        "KW",
        "CV",
        "LA",
        "LB",
        "LY",
        "LU",
        "LV",
        "LR",
        "LT",
        "LI",
        "LS",
        "MR",
        "MU",
        "YT",
        "ML",
        "MG",
        "MZ",
        "MD",
        "MN",
        "ME",
        "MS",
        "MC",
        "MM",
        "FM",
        "MW",
        "MY",
        "MT",
        "EG",
        "MO",
        "MK",
        "MX",
        "MA",
        "MQ",
        "NR",
        "NO",
        "NG",
        "NU",
        "NZ",
        "NE",
        "NI",
        "NA",
        "NP",
        "EA",
        "ST",
        "SJ",
        "EH",
        "SD",
        "SZ",
        "SO",
        "SY",
        "SR",
        "SL",
        "CN",
        "SG",
        "SI",
        "SK",
        "WS",
        "AS",
        "SN",
        "BL",
        "SH",
        "VC",
        "LC",
        "SX",
        "PM",
        "KN",
        "MF",
        "SM",
        "ES",
        "RS",
        "LK",
        "OM",
        "IQ",
        "SA",
        "PR",
        "PL",
        "PF",
        "PT",
        "FJ",
        "FI",
        "PW",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "TD",
        "CL",
        "CZ",
        "FR",
        "CU",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CW",
        "KR",
        "KP",
        "KZ",
        "QA",
        "KG",
        "KI",
        "NC",
        "KH",
        "CM",
        "CA",
        "KE",
        "CY",
        "HR",
        "RE",
        "RW",
        "RO",
        "RU",
        "SE",
        "CH",
        "TH",
        "TN",
        "YE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "העולם");
    namesMap.put("002", "אפריקה");
    namesMap.put("003", "צפון אמריקה");
    namesMap.put("005", "דרום אמריקה");
    namesMap.put("009", "אוקיאניה");
    namesMap.put("011", "מערב אפריקה");
    namesMap.put("013", "מרכז אמריקה");
    namesMap.put("014", "מזרח אפריקה");
    namesMap.put("015", "צפון אפריקה");
    namesMap.put("017", "מרכז אפריקה");
    namesMap.put("018", "דרום יבשת אפריקה");
    namesMap.put("019", "אמריקה");
    namesMap.put("021", "אמריקה הצפונית");
    namesMap.put("029", "האיים הקריביים");
    namesMap.put("030", "מזרח אסיה");
    namesMap.put("034", "דרום אסיה");
    namesMap.put("035", "דרום־מזרח אסיה");
    namesMap.put("039", "דרום אירופה");
    namesMap.put("053", "אוסטרלאסיה");
    namesMap.put("054", "מלנזיה");
    namesMap.put("057", "אזור מיקרונזיה");
    namesMap.put("061", "פולינזיה");
    namesMap.put("142", "אסיה");
    namesMap.put("143", "מרכז אסיה");
    namesMap.put("145", "מערב אסיה");
    namesMap.put("150", "אירופה");
    namesMap.put("151", "מזרח אירופה");
    namesMap.put("154", "צפון אירופה");
    namesMap.put("155", "מערב אירופה");
    namesMap.put("202", "אפריקה שמדרום לסהרה");
    namesMap.put("419", "אמריקה הלטינית");
    namesMap.put("AC", "האי אסנשן");
    namesMap.put("AD", "אנדורה");
    namesMap.put("AE", "איחוד האמירויות הערביות");
    namesMap.put("AF", "אפגניסטן");
    namesMap.put("AG", "אנטיגואה וברבודה");
    namesMap.put("AI", "אנגווילה");
    namesMap.put("AL", "אלבניה");
    namesMap.put("AM", "ארמניה");
    namesMap.put("AO", "אנגולה");
    namesMap.put("AQ", "אנטארקטיקה");
    namesMap.put("AR", "ארגנטינה");
    namesMap.put("AS", "סמואה האמריקנית");
    namesMap.put("AT", "אוסטריה");
    namesMap.put("AU", "אוסטרליה");
    namesMap.put("AW", "ארובה");
    namesMap.put("AX", "איי אולנד");
    namesMap.put("AZ", "אזרבייג׳ן");
    namesMap.put("BA", "בוסניה והרצגובינה");
    namesMap.put("BB", "ברבדוס");
    namesMap.put("BD", "בנגלדש");
    namesMap.put("BE", "בלגיה");
    namesMap.put("BF", "בורקינה פאסו");
    namesMap.put("BG", "בולגריה");
    namesMap.put("BH", "בחריין");
    namesMap.put("BI", "בורונדי");
    namesMap.put("BJ", "בנין");
    namesMap.put("BL", "סנט ברתולומיאו");
    namesMap.put("BM", "ברמודה");
    namesMap.put("BN", "ברוניי");
    namesMap.put("BO", "בוליביה");
    namesMap.put("BQ", "האיים הקריביים ההולנדיים");
    namesMap.put("BR", "ברזיל");
    namesMap.put("BS", "איי בהאמה");
    namesMap.put("BT", "בהוטן");
    namesMap.put("BV", "האי בובה");
    namesMap.put("BW", "בוצוואנה");
    namesMap.put("BY", "בלארוס");
    namesMap.put("BZ", "בליז");
    namesMap.put("CA", "קנדה");
    namesMap.put("CC", "איי קוקוס (קילינג)");
    namesMap.put("CD", "קונגו - קינשאסה");
    namesMap.put("CF", "הרפובליקה המרכז-אפריקאית");
    namesMap.put("CG", "קונגו - ברזאויל");
    namesMap.put("CH", "שווייץ");
    namesMap.put("CI", "חוף השנהב");
    namesMap.put("CK", "איי קוק");
    namesMap.put("CL", "צ׳ילה");
    namesMap.put("CM", "קמרון");
    namesMap.put("CN", "סין");
    namesMap.put("CO", "קולומביה");
    namesMap.put("CP", "האי קליפרטון");
    namesMap.put("CR", "קוסטה ריקה");
    namesMap.put("CU", "קובה");
    namesMap.put("CV", "כף ורדה");
    namesMap.put("CW", "קוראסאו");
    namesMap.put("CX", "אי חג המולד");
    namesMap.put("CY", "קפריסין");
    namesMap.put("CZ", "צ׳כיה");
    namesMap.put("DE", "גרמניה");
    namesMap.put("DG", "דייגו גרסיה");
    namesMap.put("DJ", "ג׳יבוטי");
    namesMap.put("DK", "דנמרק");
    namesMap.put("DM", "דומיניקה");
    namesMap.put("DO", "הרפובליקה הדומיניקנית");
    namesMap.put("DZ", "אלג׳יריה");
    namesMap.put("EA", "סאוטה ומלייה");
    namesMap.put("EC", "אקוודור");
    namesMap.put("EE", "אסטוניה");
    namesMap.put("EG", "מצרים");
    namesMap.put("EH", "סהרה המערבית");
    namesMap.put("ER", "אריתריאה");
    namesMap.put("ES", "ספרד");
    namesMap.put("ET", "אתיופיה");
    namesMap.put("EU", "האיחוד האירופי");
    namesMap.put("EZ", "גוש האירו");
    namesMap.put("FI", "פינלנד");
    namesMap.put("FJ", "פיג׳י");
    namesMap.put("FK", "איי פוקלנד");
    namesMap.put("FM", "מיקרונזיה");
    namesMap.put("FO", "איי פארו");
    namesMap.put("FR", "צרפת");
    namesMap.put("GA", "גבון");
    namesMap.put("GB", "בריטניה");
    namesMap.put("GD", "גרנדה");
    namesMap.put("GE", "גאורגיה");
    namesMap.put("GF", "גיאנה הצרפתית");
    namesMap.put("GG", "גרנזי");
    namesMap.put("GH", "גאנה");
    namesMap.put("GI", "גיברלטר");
    namesMap.put("GL", "גרינלנד");
    namesMap.put("GM", "גמביה");
    namesMap.put("GN", "גינאה");
    namesMap.put("GP", "גוואדלופ");
    namesMap.put("GQ", "גינאה המשוונית");
    namesMap.put("GR", "יוון");
    namesMap.put("GS", "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים");
    namesMap.put("GT", "גואטמלה");
    namesMap.put("GU", "גואם");
    namesMap.put("GW", "גינאה-ביסאו");
    namesMap.put("GY", "גיאנה");
    namesMap.put("HK", "הונג קונג (אזור מנהלי מיוחד של סין)");
    namesMap.put("HM", "איי הרד ומקדונלד");
    namesMap.put("HN", "הונדורס");
    namesMap.put("HR", "קרואטיה");
    namesMap.put("HT", "האיטי");
    namesMap.put("HU", "הונגריה");
    namesMap.put("IC", "האיים הקנריים");
    namesMap.put("ID", "אינדונזיה");
    namesMap.put("IE", "אירלנד");
    namesMap.put("IL", "ישראל");
    namesMap.put("IM", "האי מאן");
    namesMap.put("IN", "הודו");
    namesMap.put("IO", "הטריטוריה הבריטית באוקיינוס ההודי");
    namesMap.put("IQ", "עיראק");
    namesMap.put("IR", "איראן");
    namesMap.put("IS", "איסלנד");
    namesMap.put("IT", "איטליה");
    namesMap.put("JE", "ג׳רזי");
    namesMap.put("JM", "ג׳מייקה");
    namesMap.put("JO", "ירדן");
    namesMap.put("JP", "יפן");
    namesMap.put("KE", "קניה");
    namesMap.put("KG", "קירגיזסטן");
    namesMap.put("KH", "קמבודיה");
    namesMap.put("KI", "קיריבאטי");
    namesMap.put("KM", "קומורו");
    namesMap.put("KN", "סנט קיטס ונוויס");
    namesMap.put("KP", "קוריאה הצפונית");
    namesMap.put("KR", "קוריאה הדרומית");
    namesMap.put("KW", "כווית");
    namesMap.put("KY", "איי קיימן");
    namesMap.put("KZ", "קזחסטן");
    namesMap.put("LA", "לאוס");
    namesMap.put("LB", "לבנון");
    namesMap.put("LC", "סנט לוסיה");
    namesMap.put("LI", "ליכטנשטיין");
    namesMap.put("LK", "סרי לנקה");
    namesMap.put("LR", "ליבריה");
    namesMap.put("LS", "לסוטו");
    namesMap.put("LT", "ליטא");
    namesMap.put("LU", "לוקסמבורג");
    namesMap.put("LV", "לטביה");
    namesMap.put("LY", "לוב");
    namesMap.put("MA", "מרוקו");
    namesMap.put("MC", "מונקו");
    namesMap.put("MD", "מולדובה");
    namesMap.put("ME", "מונטנגרו");
    namesMap.put("MF", "סן מרטן");
    namesMap.put("MG", "מדגסקר");
    namesMap.put("MH", "איי מרשל");
    namesMap.put("MK", "מקדוניה");
    namesMap.put("ML", "מאלי");
    namesMap.put("MM", "מיאנמר (בורמה)");
    namesMap.put("MN", "מונגוליה");
    namesMap.put("MO", "מקאו (אזור מנהלי מיוחד של סין)");
    namesMap.put("MP", "איי מריאנה הצפוניים");
    namesMap.put("MQ", "מרטיניק");
    namesMap.put("MR", "מאוריטניה");
    namesMap.put("MS", "מונסראט");
    namesMap.put("MT", "מלטה");
    namesMap.put("MU", "מאוריציוס");
    namesMap.put("MV", "האיים המלדיביים");
    namesMap.put("MW", "מלאווי");
    namesMap.put("MX", "מקסיקו");
    namesMap.put("MY", "מלזיה");
    namesMap.put("MZ", "מוזמביק");
    namesMap.put("NA", "נמיביה");
    namesMap.put("NC", "קלדוניה החדשה");
    namesMap.put("NE", "ניז׳ר");
    namesMap.put("NF", "האי נורפוק");
    namesMap.put("NG", "ניגריה");
    namesMap.put("NI", "ניקרגואה");
    namesMap.put("NL", "הולנד");
    namesMap.put("NO", "נורווגיה");
    namesMap.put("NP", "נפאל");
    namesMap.put("NR", "נאורו");
    namesMap.put("NU", "ניווה");
    namesMap.put("NZ", "ניו זילנד");
    namesMap.put("OM", "עומאן");
    namesMap.put("PA", "פנמה");
    namesMap.put("PE", "פרו");
    namesMap.put("PF", "פולינזיה הצרפתית");
    namesMap.put("PG", "פפואה גינאה החדשה");
    namesMap.put("PH", "הפיליפינים");
    namesMap.put("PK", "פקיסטן");
    namesMap.put("PL", "פולין");
    namesMap.put("PM", "סנט פייר ומיקלון");
    namesMap.put("PN", "איי פיטקרן");
    namesMap.put("PR", "פוארטו ריקו");
    namesMap.put("PS", "השטחים הפלסטיניים");
    namesMap.put("PT", "פורטוגל");
    namesMap.put("PW", "פלאו");
    namesMap.put("PY", "פרגוואי");
    namesMap.put("QA", "קטאר");
    namesMap.put("QO", "טריטוריות באוקיאניה");
    namesMap.put("RE", "ראוניון");
    namesMap.put("RO", "רומניה");
    namesMap.put("RS", "סרביה");
    namesMap.put("RU", "רוסיה");
    namesMap.put("RW", "רואנדה");
    namesMap.put("SA", "ערב הסעודית");
    namesMap.put("SB", "איי שלמה");
    namesMap.put("SC", "איי סיישל");
    namesMap.put("SD", "סודן");
    namesMap.put("SE", "שוודיה");
    namesMap.put("SG", "סינגפור");
    namesMap.put("SH", "סנט הלנה");
    namesMap.put("SI", "סלובניה");
    namesMap.put("SJ", "סבאלברד ויאן מאיין");
    namesMap.put("SK", "סלובקיה");
    namesMap.put("SL", "סיירה לאונה");
    namesMap.put("SM", "סן מרינו");
    namesMap.put("SN", "סנגל");
    namesMap.put("SO", "סומליה");
    namesMap.put("SR", "סורינאם");
    namesMap.put("SS", "דרום סודן");
    namesMap.put("ST", "סאו טומה ופרינסיפה");
    namesMap.put("SV", "אל סלבדור");
    namesMap.put("SX", "סנט מארטן");
    namesMap.put("SY", "סוריה");
    namesMap.put("SZ", "סווזילנד");
    namesMap.put("TA", "טריסטן דה קונה");
    namesMap.put("TC", "איי טרקס וקייקוס");
    namesMap.put("TD", "צ׳אד");
    namesMap.put("TF", "הטריטוריות הדרומיות של צרפת");
    namesMap.put("TG", "טוגו");
    namesMap.put("TH", "תאילנד");
    namesMap.put("TJ", "טג׳יקיסטן");
    namesMap.put("TK", "טוקלאו");
    namesMap.put("TL", "טימור-לסטה");
    namesMap.put("TM", "טורקמניסטן");
    namesMap.put("TN", "תוניסיה");
    namesMap.put("TO", "טונגה");
    namesMap.put("TR", "טורקיה");
    namesMap.put("TT", "טרינידד וטובגו");
    namesMap.put("TV", "טובאלו");
    namesMap.put("TW", "טייוואן");
    namesMap.put("TZ", "טנזניה");
    namesMap.put("UA", "אוקראינה");
    namesMap.put("UG", "אוגנדה");
    namesMap.put("UM", "האיים המרוחקים הקטנים של ארה״ב");
    namesMap.put("UN", "האומות המאוחדות");
    namesMap.put("US", "ארצות הברית");
    namesMap.put("UY", "אורוגוואי");
    namesMap.put("UZ", "אוזבקיסטן");
    namesMap.put("VA", "הוותיקן");
    namesMap.put("VC", "סנט וינסנט והגרנדינים");
    namesMap.put("VE", "ונצואלה");
    namesMap.put("VG", "איי הבתולה הבריטיים");
    namesMap.put("VI", "איי הבתולה של ארצות הברית");
    namesMap.put("VN", "וייטנאם");
    namesMap.put("VU", "ונואטו");
    namesMap.put("WF", "איי ווליס ופוטונה");
    namesMap.put("WS", "סמואה");
    namesMap.put("XK", "קוסובו");
    namesMap.put("YE", "תימן");
    namesMap.put("YT", "מאיוט");
    namesMap.put("ZA", "דרום אפריקה");
    namesMap.put("ZM", "זמביה");
    namesMap.put("ZW", "זימבבואה");
    namesMap.put("ZZ", "אזור לא ידוע");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "העולם",
        "002": "אפריקה",
        "003": "צפון אמריקה",
        "005": "דרום אמריקה",
        "009": "אוקיאניה",
        "011": "מערב אפריקה",
        "013": "מרכז אמריקה",
        "014": "מזרח אפריקה",
        "015": "צפון אפריקה",
        "017": "מרכז אפריקה",
        "018": "דרום יבשת אפריקה",
        "019": "אמריקה",
        "021": "אמריקה הצפונית",
        "029": "האיים הקריביים",
        "030": "מזרח אסיה",
        "034": "דרום אסיה",
        "035": "דרום־מזרח אסיה",
        "039": "דרום אירופה",
        "053": "אוסטרלאסיה",
        "054": "מלנזיה",
        "057": "אזור מיקרונזיה",
        "061": "פולינזיה",
        "142": "אסיה",
        "143": "מרכז אסיה",
        "145": "מערב אסיה",
        "150": "אירופה",
        "151": "מזרח אירופה",
        "154": "צפון אירופה",
        "155": "מערב אירופה",
        "202": "אפריקה שמדרום לסהרה",
        "419": "אמריקה הלטינית",
        "AC": "האי אסנשן",
        "AD": "אנדורה",
        "AE": "איחוד האמירויות הערביות",
        "AF": "אפגניסטן",
        "AG": "אנטיגואה וברבודה",
        "AI": "אנגווילה",
        "AL": "אלבניה",
        "AM": "ארמניה",
        "AO": "אנגולה",
        "AQ": "אנטארקטיקה",
        "AR": "ארגנטינה",
        "AS": "סמואה האמריקנית",
        "AT": "אוסטריה",
        "AU": "אוסטרליה",
        "AW": "ארובה",
        "AX": "איי אולנד",
        "AZ": "אזרבייג׳ן",
        "BA": "בוסניה והרצגובינה",
        "BB": "ברבדוס",
        "BD": "בנגלדש",
        "BE": "בלגיה",
        "BF": "בורקינה פאסו",
        "BG": "בולגריה",
        "BH": "בחריין",
        "BI": "בורונדי",
        "BJ": "בנין",
        "BL": "סנט ברתולומיאו",
        "BM": "ברמודה",
        "BN": "ברוניי",
        "BO": "בוליביה",
        "BQ": "האיים הקריביים ההולנדיים",
        "BR": "ברזיל",
        "BS": "איי בהאמה",
        "BT": "בהוטן",
        "BV": "האי בובה",
        "BW": "בוצוואנה",
        "BY": "בלארוס",
        "BZ": "בליז",
        "CA": "קנדה",
        "CC": "איי קוקוס (קילינג)",
        "CD": "קונגו - קינשאסה",
        "CF": "הרפובליקה המרכז-אפריקאית",
        "CG": "קונגו - ברזאויל",
        "CH": "שווייץ",
        "CI": "חוף השנהב",
        "CK": "איי קוק",
        "CL": "צ׳ילה",
        "CM": "קמרון",
        "CN": "סין",
        "CO": "קולומביה",
        "CP": "האי קליפרטון",
        "CR": "קוסטה ריקה",
        "CU": "קובה",
        "CV": "כף ורדה",
        "CW": "קוראסאו",
        "CX": "אי חג המולד",
        "CY": "קפריסין",
        "CZ": "צ׳כיה",
        "DE": "גרמניה",
        "DG": "דייגו גרסיה",
        "DJ": "ג׳יבוטי",
        "DK": "דנמרק",
        "DM": "דומיניקה",
        "DO": "הרפובליקה הדומיניקנית",
        "DZ": "אלג׳יריה",
        "EA": "סאוטה ומלייה",
        "EC": "אקוודור",
        "EE": "אסטוניה",
        "EG": "מצרים",
        "EH": "סהרה המערבית",
        "ER": "אריתריאה",
        "ES": "ספרד",
        "ET": "אתיופיה",
        "EU": "האיחוד האירופי",
        "EZ": "גוש האירו",
        "FI": "פינלנד",
        "FJ": "פיג׳י",
        "FK": "איי פוקלנד",
        "FM": "מיקרונזיה",
        "FO": "איי פארו",
        "FR": "צרפת",
        "GA": "גבון",
        "GB": "בריטניה",
        "GD": "גרנדה",
        "GE": "גאורגיה",
        "GF": "גיאנה הצרפתית",
        "GG": "גרנזי",
        "GH": "גאנה",
        "GI": "גיברלטר",
        "GL": "גרינלנד",
        "GM": "גמביה",
        "GN": "גינאה",
        "GP": "גוואדלופ",
        "GQ": "גינאה המשוונית",
        "GR": "יוון",
        "GS": "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים",
        "GT": "גואטמלה",
        "GU": "גואם",
        "GW": "גינאה-ביסאו",
        "GY": "גיאנה",
        "HK": "הונג קונג (אזור מנהלי מיוחד של סין)",
        "HM": "איי הרד ומקדונלד",
        "HN": "הונדורס",
        "HR": "קרואטיה",
        "HT": "האיטי",
        "HU": "הונגריה",
        "IC": "האיים הקנריים",
        "ID": "אינדונזיה",
        "IE": "אירלנד",
        "IL": "ישראל",
        "IM": "האי מאן",
        "IN": "הודו",
        "IO": "הטריטוריה הבריטית באוקיינוס ההודי",
        "IQ": "עיראק",
        "IR": "איראן",
        "IS": "איסלנד",
        "IT": "איטליה",
        "JE": "ג׳רזי",
        "JM": "ג׳מייקה",
        "JO": "ירדן",
        "JP": "יפן",
        "KE": "קניה",
        "KG": "קירגיזסטן",
        "KH": "קמבודיה",
        "KI": "קיריבאטי",
        "KM": "קומורו",
        "KN": "סנט קיטס ונוויס",
        "KP": "קוריאה הצפונית",
        "KR": "קוריאה הדרומית",
        "KW": "כווית",
        "KY": "איי קיימן",
        "KZ": "קזחסטן",
        "LA": "לאוס",
        "LB": "לבנון",
        "LC": "סנט לוסיה",
        "LI": "ליכטנשטיין",
        "LK": "סרי לנקה",
        "LR": "ליבריה",
        "LS": "לסוטו",
        "LT": "ליטא",
        "LU": "לוקסמבורג",
        "LV": "לטביה",
        "LY": "לוב",
        "MA": "מרוקו",
        "MC": "מונקו",
        "MD": "מולדובה",
        "ME": "מונטנגרו",
        "MF": "סן מרטן",
        "MG": "מדגסקר",
        "MH": "איי מרשל",
        "MK": "מקדוניה",
        "ML": "מאלי",
        "MM": "מיאנמר (בורמה)",
        "MN": "מונגוליה",
        "MO": "מקאו (אזור מנהלי מיוחד של סין)",
        "MP": "איי מריאנה הצפוניים",
        "MQ": "מרטיניק",
        "MR": "מאוריטניה",
        "MS": "מונסראט",
        "MT": "מלטה",
        "MU": "מאוריציוס",
        "MV": "האיים המלדיביים",
        "MW": "מלאווי",
        "MX": "מקסיקו",
        "MY": "מלזיה",
        "MZ": "מוזמביק",
        "NA": "נמיביה",
        "NC": "קלדוניה החדשה",
        "NE": "ניז׳ר",
        "NF": "האי נורפוק",
        "NG": "ניגריה",
        "NI": "ניקרגואה",
        "NL": "הולנד",
        "NO": "נורווגיה",
        "NP": "נפאל",
        "NR": "נאורו",
        "NU": "ניווה",
        "NZ": "ניו זילנד",
        "OM": "עומאן",
        "PA": "פנמה",
        "PE": "פרו",
        "PF": "פולינזיה הצרפתית",
        "PG": "פפואה גינאה החדשה",
        "PH": "הפיליפינים",
        "PK": "פקיסטן",
        "PL": "פולין",
        "PM": "סנט פייר ומיקלון",
        "PN": "איי פיטקרן",
        "PR": "פוארטו ריקו",
        "PS": "השטחים הפלסטיניים",
        "PT": "פורטוגל",
        "PW": "פלאו",
        "PY": "פרגוואי",
        "QA": "קטאר",
        "QO": "טריטוריות באוקיאניה",
        "RE": "ראוניון",
        "RO": "רומניה",
        "RS": "סרביה",
        "RU": "רוסיה",
        "RW": "רואנדה",
        "SA": "ערב הסעודית",
        "SB": "איי שלמה",
        "SC": "איי סיישל",
        "SD": "סודן",
        "SE": "שוודיה",
        "SG": "סינגפור",
        "SH": "סנט הלנה",
        "SI": "סלובניה",
        "SJ": "סבאלברד ויאן מאיין",
        "SK": "סלובקיה",
        "SL": "סיירה לאונה",
        "SM": "סן מרינו",
        "SN": "סנגל",
        "SO": "סומליה",
        "SR": "סורינאם",
        "SS": "דרום סודן",
        "ST": "סאו טומה ופרינסיפה",
        "SV": "אל סלבדור",
        "SX": "סנט מארטן",
        "SY": "סוריה",
        "SZ": "סווזילנד",
        "TA": "טריסטן דה קונה",
        "TC": "איי טרקס וקייקוס",
        "TD": "צ׳אד",
        "TF": "הטריטוריות הדרומיות של צרפת",
        "TG": "טוגו",
        "TH": "תאילנד",
        "TJ": "טג׳יקיסטן",
        "TK": "טוקלאו",
        "TL": "טימור-לסטה",
        "TM": "טורקמניסטן",
        "TN": "תוניסיה",
        "TO": "טונגה",
        "TR": "טורקיה",
        "TT": "טרינידד וטובגו",
        "TV": "טובאלו",
        "TW": "טייוואן",
        "TZ": "טנזניה",
        "UA": "אוקראינה",
        "UG": "אוגנדה",
        "UM": "האיים המרוחקים הקטנים של ארה״ב",
        "UN": "האומות המאוחדות",
        "US": "ארצות הברית",
        "UY": "אורוגוואי",
        "UZ": "אוזבקיסטן",
        "VA": "הוותיקן",
        "VC": "סנט וינסנט והגרנדינים",
        "VE": "ונצואלה",
        "VG": "איי הבתולה הבריטיים",
        "VI": "איי הבתולה של ארצות הברית",
        "VN": "וייטנאם",
        "VU": "ונואטו",
        "WF": "איי ווליס ופוטונה",
        "WS": "סמואה",
        "XK": "קוסובו",
        "YE": "תימן",
        "YT": "מאיוט",
        "ZA": "דרום אפריקה",
        "ZM": "זמביה",
        "ZW": "זימבבואה",
        "ZZ": "אזור לא ידוע"
    };
  }-*/;
}
