/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.perfdata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import sun.management.counter.ByteArrayCounter;
import sun.management.counter.LongArrayCounter;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

public abstract class JStatData {
    public static JStatData connect(long pid) {
        try {
            return new PerfIntr((int)pid);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Error e) {
            throw new RuntimeException("Cannot perf data for process " + pid + " - " + e.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot perf data for process " + pid + " - " + e.toString());
        }
    }

    public abstract int getMajorVersion();

    public abstract int getMinorVersion();

    public abstract long getModificationTimeStamp();

    public abstract Map<String, Counter<?>> getAllCounters();

    public abstract List<Counter<?>> findByPattern(String var1);

    private static class PerfIntr
    extends JStatData {
        private static sun.management.counter.Units U_TICKS = sun.management.counter.Units.TICKS;
        private static Map<Object, Units> UNIT_MAP = new HashMap<Object, Units>();
        private static Map<Object, Variability> VARIABILITY_MAP = new HashMap<Object, Variability>();
        final PerfInstrumentation instr;
        final double tick;

        public PerfIntr(int pid) throws IllegalArgumentException, IOException {
            ByteBuffer bb = Perf.getPerf().attach(pid, "r");
            this.instr = new PerfInstrumentation(bb);
            long hz = ((sun.management.counter.LongCounter)this.instr.findByPattern("sun.os.hrt.frequency").get(0)).longValue();
            this.tick = (double)TimeUnit.SECONDS.toNanos(1L) / (double)hz;
        }

        @Override
        public int getMajorVersion() {
            return this.instr.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.instr.getMinorVersion();
        }

        @Override
        public long getModificationTimeStamp() {
            return this.instr.getModificationTimeStamp();
        }

        @Override
        public Map<String, Counter<?>> getAllCounters() {
            LinkedHashMap result = new LinkedHashMap();
            for (sun.management.counter.Counter c : this.instr.getAllCounters()) {
                Counter<?> cc = this.convert(c);
                result.put(cc.getName(), cc);
            }
            return result;
        }

        @Override
        public List<Counter<?>> findByPattern(String pattern) {
            return this.convert(this.instr.findByPattern(pattern));
        }

        private List<Counter<?>> convert(List list) {
            ArrayList cl = new ArrayList(list.size());
            for (Object c : list) {
                cl.add(this.convert(c));
            }
            return cl;
        }

        private Counter<?> convert(Object c) {
            if (c instanceof sun.management.counter.LongCounter) {
                sun.management.counter.LongCounter lc = (sun.management.counter.LongCounter)c;
                if (U_TICKS.equals(lc.getUnits())) {
                    return new TickWrapper(this.tick, lc);
                }
                return new LongWrapper(lc);
            }
            if (c instanceof sun.management.counter.StringCounter) {
                sun.management.counter.StringCounter lc = (sun.management.counter.StringCounter)c;
                return new StringWrapper(lc);
            }
            if (c instanceof LongArrayCounter) {
                LongArrayCounter lc = (LongArrayCounter)c;
                return new CounterWrapper(lc);
            }
            if (c instanceof ByteArrayCounter) {
                ByteArrayCounter lc = (ByteArrayCounter)c;
                return new ByteArrayWrapper(lc);
            }
            return new CounterWrapper((sun.management.counter.Counter)c);
        }

        static {
            UNIT_MAP.put(sun.management.counter.Units.INVALID, Units.INVALID);
            UNIT_MAP.put(sun.management.counter.Units.NONE, Units.NONE);
            UNIT_MAP.put(sun.management.counter.Units.BYTES, Units.BYTES);
            UNIT_MAP.put(sun.management.counter.Units.TICKS, Units.TICKS);
            UNIT_MAP.put(sun.management.counter.Units.EVENTS, Units.EVENTS);
            UNIT_MAP.put(sun.management.counter.Units.STRING, Units.STRING);
            UNIT_MAP.put(sun.management.counter.Units.HERTZ, Units.HERTZ);
            VARIABILITY_MAP.put(sun.management.counter.Variability.INVALID, Variability.INVALID);
            VARIABILITY_MAP.put(sun.management.counter.Variability.CONSTANT, Variability.CONSTANT);
            VARIABILITY_MAP.put(sun.management.counter.Variability.MONOTONIC, Variability.MONOTONIC);
            VARIABILITY_MAP.put(sun.management.counter.Variability.VARIABLE, Variability.VARIABLE);
        }

        private static class TickWrapper
        extends LongWrapper
        implements TickCounter {
            private final double tick;

            public TickWrapper(double tick, sun.management.counter.LongCounter counter) {
                super(counter);
                this.tick = tick;
            }

            @Override
            public double getTick() {
                return this.tick;
            }

            @Override
            public long getTicks() {
                return this.getLong();
            }

            @Override
            public long geNanos() {
                return (long)(this.tick * (double)this.getLong());
            }
        }

        private static class LongWrapper
        extends CounterWrapper<Long>
        implements LongCounter {
            public LongWrapper(sun.management.counter.LongCounter counter) {
                super(counter);
            }

            @Override
            public long getLong() {
                return ((sun.management.counter.LongCounter)this.counter).longValue();
            }
        }

        private static class StringWrapper
        extends CounterWrapper<String>
        implements StringCounter {
            public StringWrapper(sun.management.counter.StringCounter counter) {
                super(counter);
            }

            @Override
            public String getString() {
                return ((sun.management.counter.StringCounter)this.counter).stringValue();
            }
        }

        private static class ByteArrayWrapper
        extends CounterWrapper<byte[]>
        implements Counter<byte[]> {
            public ByteArrayWrapper(ByteArrayCounter counter) {
                super(counter);
            }
        }

        private static class CounterWrapper<T>
        implements Counter<T> {
            protected final sun.management.counter.Counter counter;

            public CounterWrapper(sun.management.counter.Counter counter) {
                this.counter = counter;
            }

            @Override
            public String getName() {
                return this.counter.getName();
            }

            @Override
            public Units getUnits() {
                Units u = (Units)((Object)UNIT_MAP.get(this.counter.getUnits()));
                return u == null ? Units.INVALID : u;
            }

            @Override
            public Variability getVariability() {
                Variability v = (Variability)((Object)VARIABILITY_MAP.get(this.counter.getVariability()));
                return v == null ? Variability.INVALID : v;
            }

            @Override
            public T getValue() {
                return (T)this.counter.getValue();
            }

            public String toString() {
                return this.counter.toString();
            }
        }
    }

    public static interface TickCounter
    extends LongCounter {
        public long getTicks();

        public double getTick();

        public long geNanos();
    }

    public static interface LongCounter
    extends Counter<Long> {
        public long getLong();
    }

    public static interface StringCounter
    extends Counter<String> {
        public String getString();
    }

    public static interface Counter<T> {
        public String getName();

        public Units getUnits();

        public Variability getVariability();

        public T getValue();
    }

    public static enum Variability {
        INVALID,
        CONSTANT,
        MONOTONIC,
        VARIABLE;

    }

    public static enum Units {
        INVALID,
        NONE,
        BYTES,
        TICKS,
        EVENTS,
        STRING,
        HERTZ;

    }
}

