/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.event.ErrorHandler;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;

public class ShieldedEventReader<T extends Event>
implements EventReader<T> {
    private static final ErrorHandler THROW_HANDLER = new ErrorHandler(){

        @Override
        public void onException(Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    };
    private final EventReader<Event> nested;
    private final Class<T> classFilter;
    private final ErrorHandler errorHandler;
    private T nextEvent;

    public ShieldedEventReader(EventReader<Event> nested, Class<T> classFilter) {
        this(nested, classFilter, THROW_HANDLER);
    }

    public ShieldedEventReader(EventReader<Event> nested, Class<T> classFilter, ErrorHandler errorHandler) {
        this.nested = nested;
        this.classFilter = classFilter;
        this.errorHandler = errorHandler;
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<T, M> morpher) {
        return MorphingEventReader.morph(this, morpher);
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    private void seekNext() {
        try {
            while (this.nested.hasNext()) {
                Event e = (Event)this.nested.next();
                if (e instanceof SimpleErrorEvent) {
                    this.errorHandler.onException(((SimpleErrorEvent)e).exception());
                }
                if (!this.classFilter.isInstance(e)) continue;
                this.nextEvent = (Event)this.classFilter.cast(e);
                break;
            }
        }
        catch (Exception e) {
            this.errorHandler.onException(e);
            if (this.classFilter.isAssignableFrom(SimpleErrorEvent.class)) {
                this.nextEvent = (Event)this.classFilter.cast(new SimpleErrorEvent(e));
            }
            this.seekNext();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextEvent == null) {
            this.seekNext();
        }
        return this.nextEvent != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T event = this.nextEvent;
        this.nextEvent = null;
        return event;
    }

    @Override
    public T peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T event = this.nextEvent;
        return event;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        this.nested.dispose();
    }
}

