/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class FlameGraph {
    private static final StackFrame[] ROOT = new StackFrame[0];
    private static final FrameComparator FRAME_COMPARATOR = new FrameComparator();
    private Node root;
    private ColorPicker colorPicker = new SimpleColorPicker();

    public FlameGraph() {
        this.root = new Node(ROOT);
    }

    public void setColorPicker(ColorPicker cp) {
        this.colorPicker = cp;
    }

    public void feed(StackFrameList trace) {
        Node node = this.root;
        ++node.totalCount;
        for (int i = trace.depth(); i > 0; --i) {
            StackFrame f = trace.frameAt(i - 1).withoutSource();
            Node c = node.child(f);
            ++c.totalCount;
            node = c;
        }
        ++node.terminalCount;
    }

    public void renderSVG(String title, int width, Writer writer) throws IOException {
        int topm = 24;
        int bm = 0;
        int frameheight = 16;
        int threashold = (int)(1.5 * (double)this.root.totalCount / (double)width);
        int maxDepth = this.calculateMaxDepth(this.root, threashold);
        int height = maxDepth * frameheight + topm + bm;
        CharSequence line = null;
        this.appendHeader(width, height, writer);
        this.format(writer, "<rect x=\"0.0\" y=\"0\" width=\"%d\" height=\"%d\" fill=\"url(#background)\"/>", width, height);
        writer.append(line).append("\n");
        this.format(writer, "<text text-anchor=\"middle\" x=\"%d\" y=\"%d\" font-size=\"17\" font-family=\"Verdana\" fill=\"rgb(0,0,0)\"  >%s</text>", width / 2, topm, title);
        writer.append(line).append("\n");
        this.appendChildNodes(writer, this.root, 0, width, height - frameheight, frameheight, threashold);
        this.format(writer, "</svg>", new Object[0]);
    }

    private int calculateMaxDepth(Node node, int threshold) {
        if (node.totalCount < threshold) {
            return 0;
        }
        int max = 0;
        for (Node n : node.children.values()) {
            max = Math.max(max, this.calculateMaxDepth(n, threshold));
        }
        return max + 1;
    }

    private void appendChildNodes(Writer writer, Node node, int xoffs, int width, int height, int frameheight, int threshold) throws IOException {
        int x = xoffs;
        x += node.terminalCount / 2;
        for (Node child : node.children.values()) {
            if (child.totalCount > threshold) {
                this.renderNode(writer, child, x, height, width, frameheight);
                this.appendChildNodes(writer, child, x, width, height - frameheight, frameheight, threshold);
            }
            x += child.totalCount;
        }
    }

    private void renderNode(Writer writer, Node node, int x, int height, int width, int frameheight) throws IOException {
        double rx = (double)width * (double)x / (double)this.root.totalCount;
        double rw = (double)width * (double)node.totalCount / (double)this.root.totalCount;
        double ry = height;
        double rh = frameheight;
        int c = this.colorPicker.pickColor(node.path);
        int cr = 0xFF & c >> 16;
        int cg = 0xFF & c >> 8;
        int cb = 0xFF & c >> 0;
        this.format(writer, "<g class=\"fbar\">\n", new Object[0]);
        this.format(writer, "<title>%s (%d samples, %.2f%%)</title>\n", this.describe(node), node.totalCount, 100.0 * (double)node.totalCount / (double)this.root.totalCount);
        this.format(writer, "<rect x=\"%.1f\" y=\"%.1f\" width=\"%.1f\" height=\"%.1f\" fill=\"rgb(%d,%d,%d)\" rx=\"2\" ry=\"2\"/>\n", rx, ry, rw, rh, cr, cg, cb);
        this.format(writer, "<text text-anchor=\"\" x=\"%.1f\" y=\"%.1f\" fill=\"rgb(0,0,0)\">%s</text>\n", rx + 10.0, ry + (double)frameheight - 3.0, this.trimStr(this.describe(node), (int)(rw - 10.0) / 7));
        this.format(writer, "</g>\n", new Object[0]);
        if (node.terminalCount == node.totalCount) {
            this.format(writer, "<g class=\"func_g\">\n", new Object[0]);
            this.format(writer, "<rect x=\"%.1f\" y=\"%.1f\" width=\"%.1f\" height=\"%.1f\" fill=\"rgb(20,20,20)\" rx=\"1\" ry=\"1\"/>\n", rx, ry - rh / 2.0, rw, Float.valueOf(3.0f));
            this.format(writer, "</g>\n", new Object[0]);
        }
    }

    private String trimStr(String describe, int len) {
        if (len < 3) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = Math.min(describe.length(), len);
        boolean trimed = describe.length() > len;
        for (int i = 0; i != n; ++i) {
            if (trimed && i > n - 3) {
                sb.append('.');
                continue;
            }
            sb.append(describe.charAt(i));
        }
        return sb.toString();
    }

    private String describe(Node node) {
        StackFrame frame = node.path[node.path.length - 1];
        String line = frame.getClassName() + "." + frame.getMethodName();
        line = line.replace("<", "&lt;");
        line = line.replace(">", "&gt;");
        return line;
    }

    private void format(Writer writer, String format, Object ... args) throws IOException {
        writer.append(String.format(format, args));
    }

    protected void appendHeader(int width, int height, Writer writer) throws IOException {
        this.format(writer, "<?xml version=\"1.0\" standalone=\"no\"?>\n", new Object[0]);
        this.format(writer, "<svg version=\"1.1\" width=\"%d\" height=\"%d\" onload=\"init(evt)\" viewBox=\"0 0 %d %d\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n", width, height, width, height);
        this.format(writer, "<defs>", new Object[0]);
        this.format(writer, "  <linearGradient id=\"background\" y1=\"0\" y2=\"1\" x1=\"0\" x2=\"0\">\n", new Object[0]);
        this.format(writer, "      <stop stop-color=\"#eeeeee\" offset=\"5%%\"/>\n", new Object[0]);
        this.format(writer, "      <stop stop-color=\"#eeeeb0\" offset=\"95%%\"/>\n", new Object[0]);
        this.format(writer, "  </linearGradient>\n", new Object[0]);
        this.format(writer, "</defs>\n", new Object[0]);
        this.format(writer, "<style type=\"text/css\">\n", new Object[0]);
        this.format(writer, "  text { font-size:12px; font-family:Verdana }\n", new Object[0]);
        this.format(writer, "  .fbar:hover { stroke:black; stroke-width:0.5; cursor:pointer; }\n", new Object[0]);
        this.format(writer, "</style>\n", new Object[0]);
    }

    static /* synthetic */ FrameComparator access$100() {
        return FRAME_COMPARATOR;
    }

    public class SimpleColorPicker
    implements ColorPicker {
        @Override
        public int pickColor(StackFrame[] trace) {
            if (trace.length == 0) {
                return 0xFFFFFF;
            }
            StackFrame sf = trace[trace.length - 1];
            int hP = this.packageNameHash(sf.getClassName());
            int hC = this.classNameHash(sf.getClassName());
            int hM = sf.getMethodName().hashCode();
            int hue = 12 + hP % 20 - 10;
            int sat = 180 + hC % 20 - 10;
            int lum = 220 + hM % 20 - 10;
            int c = Color.HSBtoRGB((float)hue / 255.0f, (float)sat / 255.0f, (float)lum / 255.0f);
            return c;
        }

        private int packageNameHash(String className) {
            int c = className.lastIndexOf(46);
            if (c >= 0) {
                return className.substring(0, c).hashCode();
            }
            return 0;
        }

        private int classNameHash(String className) {
            int c = className.lastIndexOf(46);
            if (c >= 0) {
                className = className.substring(c + 1);
            }
            if ((c = className.indexOf(36)) >= 0) {
                int nhash = className.substring(0, c).hashCode();
                int shash = className.substring(c + 1).hashCode();
                return nhash + shash % 10;
            }
            return className.hashCode();
        }
    }

    public static interface ColorPicker {
        public int pickColor(StackFrame[] var1);
    }

    private static class FrameComparator
    implements Comparator<StackFrame> {
        private FrameComparator() {
        }

        @Override
        public int compare(StackFrame o1, StackFrame o2) {
            int n = this.compare(o1.getClassName(), o2.getClassName());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getLineNumber(), o2.getLineNumber());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getMethodName(), o2.getMethodName());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getSourceFile(), o2.getSourceFile());
            return 0;
        }

        @Override
        private int compare(int n1, int n2) {
            return Long.signum((long)n1 - (long)n2);
        }

        @Override
        private int compare(String str1, String str2) {
            if (str1 == str2) {
                return 0;
            }
            if (str1 == null) {
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }

    private static class Node {
        StackFrame[] path;
        int totalCount;
        int terminalCount;
        SortedMap<StackFrame, Node> children = new TreeMap<StackFrame, Node>(FlameGraph.access$100());

        public Node(StackFrame[] path) {
            this.path = path;
        }

        public Node child(StackFrame f) {
            Node c = (Node)this.children.get(f);
            if (c == null) {
                StackFrame[] npath = Arrays.copyOf(this.path, this.path.length + 1);
                npath[this.path.length] = f;
                c = new Node(npath);
                this.children.put(f, c);
            }
            return c;
        }

        public String toString() {
            return this.path.length == 0 ? "<root>" : this.path[this.path.length - 1].toString();
        }
    }
}

