/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gridkit.jvmtool.cli.ProcessSpawner;

public class CommandLauncher {
    @Parameter(names={"--help"}, help=true)
    private boolean help = false;
    @Parameter(names={"-X", "--verbose"}, description="Enable detailed diagnostics")
    private boolean verbose = false;
    @Parameter(names={"--commands"}, help=true)
    private boolean listCommands = false;
    private boolean suppressSystemExit;
    private Map<String, Runnable> commands = new HashMap<String, Runnable>();

    public boolean isVerbose() {
        return this.verbose;
    }

    public Error fail(String ... messages) {
        throw new CommandAbortedError(false, messages);
    }

    public Error fail(String message, Exception e) {
        throw new CommandAbortedError(false, new String[]{message}, e);
    }

    public Error failAndPrintUsage(String ... messages) {
        throw new CommandAbortedError(true, messages);
    }

    public void logError(String line) {
        System.err.println(line);
    }

    public void logTrace(Throwable e) {
        e.printStackTrace(System.err);
    }

    public void suppressSystemExit() {
        this.suppressSystemExit = true;
    }

    public boolean start(String[] args) {
        this.breakCage(args);
        JCommander parser = null;
        try {
            parser = new JCommander((Object)this);
            this.addCommands(parser);
            try {
                parser.parse(args);
            }
            catch (Exception e) {
                this.failAndPrintUsage(e.toString());
            }
            if (this.help) {
                String cmd = parser.getParsedCommand();
                if (cmd == null) {
                    parser.usage();
                } else {
                    parser.usage(cmd);
                }
            } else if (this.listCommands) {
                for (String cmd : this.commands.keySet()) {
                    System.out.println(String.format("%8s - %s", cmd, parser.getCommandDescription(cmd)));
                }
            } else {
                Runnable cmd = this.commands.get(parser.getParsedCommand());
                if (cmd == null) {
                    this.failAndPrintUsage(new String[0]);
                } else {
                    cmd.run();
                }
            }
            if (this.suppressSystemExit) {
                return true;
            }
            System.exit(0);
        }
        catch (CommandAbortedError error) {
            for (String m : error.messages) {
                this.logError(m);
            }
            if (this.verbose && error.getCause() != null) {
                this.logTrace(error.getCause());
            }
            if (error.printUsage && parser != null) {
                if (parser.getParsedCommand() != null) {
                    parser.usage(parser.getParsedCommand());
                } else {
                    parser.usage();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.suppressSystemExit) {
            return false;
        }
        System.exit(1);
        return false;
    }

    protected String[] getModulesUnlockCommand() {
        return new String[0];
    }

    protected List<String> getCommandPackages() {
        return Collections.singletonList(this.getClass().getPackage().getName() + ".cmd");
    }

    private void addCommands(JCommander parser) throws InstantiationException, IllegalAccessException {
        for (String pack : this.getCommandPackages()) {
            for (Class<?> c : this.findClasses(pack)) {
                if (!CmdRef.class.isAssignableFrom(c)) continue;
                CmdRef cmd = (CmdRef)c.newInstance();
                String cmdName = cmd.getCommandName();
                Runnable cmdTask = cmd.newCommand(this);
                if (this.commands.containsKey(cmdName)) {
                    this.fail("Ambiguous implementation for '" + cmdName + "'");
                }
                this.commands.put(cmdName, cmdTask);
                parser.addCommand(cmdName, (Object)cmdTask);
            }
        }
    }

    private List<Class<?>> findClasses(String packageName) {
        ArrayList result = new ArrayList();
        try {
            String path = packageName.replace('.', '/');
            for (String f : CommandLauncher.findFiles(path)) {
                if (!f.endsWith(".class") || f.indexOf(36) >= 0) continue;
                f = f.substring(0, f.length() - ".class".length());
                f = f.replace('/', '.');
                result.add(Class.forName(f));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static List<String> findFiles(String path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> en = cl.getResources(path);
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            CommandLauncher.listFiles(result, u, path);
        }
        return result;
    }

    static List<String> listFiles(List<String> results, URL packageURL, String path) throws IOException {
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(path)) continue;
                results.add(entryName);
            }
        } else {
            File dir = new File(packageURL.getFile());
            String cp = dir.getCanonicalPath();
            File root = dir;
            while (!cp.equals(new File(root, path).getCanonicalPath())) {
                root = root.getParentFile();
            }
            CommandLauncher.listFiles(results, root, dir);
        }
        return results;
    }

    static void listFiles(List<String> names, File root, File dir) {
        String rootPath = root.getAbsolutePath();
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    CommandLauncher.listFiles(names, root, file);
                    continue;
                }
                String name = file.getAbsolutePath().substring(rootPath.length() + 1);
                name = name.replace('\\', '/');
                names.add(name);
            }
        }
    }

    private void breakCage(String ... args) {
        if ("false".equalsIgnoreCase(System.getProperty("sjk.breakCage", "true"))) {
            return;
        }
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        String spec = rtBean.getSpecVersion();
        if (spec.startsWith("1.")) {
            return;
        }
        if (this.getModulesUnlockCommand().length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String a : rtBean.getInputArguments()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(a);
            }
            if (this.isUnlocked(sb.toString(), this.getModulesUnlockCommand())) {
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            File jhome = new File(System.getProperty("java.home"));
            File jbin = new File(jhome, "bin/java");
            command.add(jbin.getPath());
            for (String m : this.getModulesUnlockCommand()) {
                command.add("--add-exports");
                command.add(m);
            }
            command.add("-Dsjk.breakCage=false");
            command.add("-cp");
            command.add(rtBean.getClassPath());
            command.addAll(rtBean.getInputArguments());
            command.add(this.getClass().getName());
            command.addAll(Arrays.asList(args));
            System.err.println("Restarting java with unlocked package access");
            ProcessSpawner.start(command);
        }
    }

    private boolean isUnlocked(String cmd, String[] modules) {
        for (String m : modules) {
            String c1 = "--add-exports " + m;
            String c2 = "--add-exports=" + m;
            if (cmd.contains(c1) || cmd.contains(c2)) continue;
            return false;
        }
        return true;
    }

    public static class CommandAbortedError
    extends Error {
        public boolean printUsage;
        public String[] messages;

        public CommandAbortedError(boolean printUsage, String[] messages) {
            this.printUsage = printUsage;
            this.messages = messages;
        }

        public CommandAbortedError(boolean printUsage, String[] messages, Exception e) {
            super(e);
            this.printUsage = printUsage;
            this.messages = messages;
        }
    }

    public static interface CmdRef {
        public String getCommandName();

        public Runnable newCommand(CommandLauncher var1);
    }
}

