/*
 * Decompiled with CFR 0.152.
 */
package net.java.btrace.runtime;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import net.java.btrace.annotations.BTrace;
import net.java.btrace.annotations.Property;
import net.java.btrace.api.core.BTraceLogger;
import net.java.btrace.api.core.BTraceMBean;
import net.java.btrace.api.extensions.ExtensionsRepository;
import net.java.btrace.spi.core.MBeanDecoratorImpl;

final class BTraceMBeanImpl
extends BTraceMBean {
    private Class clazz;
    private Map<String, Field> attributes;
    private String beanName;
    private MBeanInfo cachedBeanInfo;
    private ExtensionsRepository repository;
    private static final Map<Class, OpenType> classToOpenTypes = new HashMap<Class, OpenType>();

    public BTraceMBeanImpl(Class clazz, ExtensionsRepository repository) {
        this.clazz = clazz;
        this.attributes = BTraceMBeanImpl.getJMXAttributes(clazz);
        this.beanName = BTraceMBeanImpl.getBeanName(clazz);
        this.repository = repository;
    }

    public synchronized Object getAttribute(String name) throws AttributeNotFoundException {
        Field field = this.attributes.get(name);
        if (field == null) {
            throw new AttributeNotFoundException("No such property: " + name);
        }
        return this.getFieldValue(field);
    }

    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList();
        for (String name : names) {
            Field field = this.attributes.get(name);
            Object value = null;
            if (field != null) {
                value = this.getFieldValue(field);
            }
            if (value == null) continue;
            list.add(new Attribute(name, value));
        }
        return list;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.cachedBeanInfo != null) {
            return this.cachedBeanInfo;
        }
        TreeSet<String> names = new TreeSet<String>();
        for (String name : this.attributes.keySet()) {
            names.add(name);
        }
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[names.size()];
        Iterator it = names.iterator();
        for (int i = 0; i < attrs.length; ++i) {
            String name = (String)it.next();
            Field field = this.attributes.get(name);
            Property attr = field.getAnnotation(Property.class);
            String description = attr.description();
            if (description.isEmpty()) {
                description = name;
            }
            DescriptorSupport descriptor = new DescriptorSupport();
            OpenType ot = this.typeToOpenType(field.getGenericType());
            if (ot != null) {
                descriptor.setField("openType", ot);
            }
            attrs[i] = new MBeanAttributeInfo(name, field.getType().getName(), description, true, false, false, descriptor);
        }
        BTrace info = this.clazz.getAnnotation(BTrace.class);
        String description = info.description();
        if (description.isEmpty()) {
            description = "BTrace MBean : " + this.beanName;
        }
        this.cachedBeanInfo = new MBeanInfo(this.beanName, description, attrs, null, null, null);
        return this.cachedBeanInfo;
    }

    public static void registerMBean(Class clazz, ExtensionsRepository repository) {
        if (BTraceMBeanImpl.isMBean(clazz)) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            BTraceMBeanImpl bean = new BTraceMBeanImpl(clazz, repository);
            try {
                ObjectName on = new ObjectName("btrace:name=" + bean.beanName);
                if (server.isRegistered(on)) {
                    server.unregisterMBean(on);
                }
                server.registerMBean((Object)bean, on);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
        }
    }

    private static String getBeanName(Class clazz) {
        BTrace info = clazz.getAnnotation(BTrace.class);
        String beanName = info.name();
        if (beanName.isEmpty()) {
            beanName = clazz.getName();
        }
        return beanName;
    }

    public static boolean isMBean(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            return true;
        }
        return false;
    }

    private Object getFieldValue(Field field) {
        try {
            Object value = field.get(null);
            OpenType ot = this.typeToOpenType(field.getGenericType());
            if (ot != null) {
                return this.convertToOpenTypeValue(ot, value);
            }
            return value;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static Map<String, Field> getJMXAttributes(Class clazz) {
        try {
            HashMap<String, Field> fields = new HashMap<String, Field>();
            for (Field field : clazz.getDeclaredFields()) {
                Property attr;
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Property.class) || (attr = field.getAnnotation(Property.class)) == null) continue;
                field.setAccessible(true);
                String attrName = attr.name();
                if (attrName.isEmpty()) {
                    attrName = field.getName();
                    attrName = attrName.substring(1);
                }
                fields.put(attrName, field);
            }
            return fields;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private Iterable<MBeanDecoratorImpl> listDecorators() {
        ServiceLoader<MBeanDecoratorImpl> decoratorLoader = ServiceLoader.load(MBeanDecoratorImpl.class, this.repository.getClassLoader(BTraceMBeanImpl.class.getClassLoader()));
        return new IterableServiceLoader<MBeanDecoratorImpl>(decoratorLoader);
    }

    public OpenType typeToOpenType(Type t) {
        OpenType ot = null;
        for (MBeanDecoratorImpl d : this.listDecorators()) {
            ot = d.toOpenType(t, (BTraceMBean)this);
            if (ot == null) continue;
            return ot;
        }
        try {
            ParameterizedType pt;
            Type rawType;
            if (t instanceof ParameterizedType && (rawType = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
                Class rt = (Class)rawType;
                Type[] argTypes = pt.getActualTypeArguments();
                if (Map.class.isAssignableFrom(rt)) {
                    OpenType keyType = this.typeToOpenType(argTypes[0]);
                    OpenType valueType = this.typeToOpenType(argTypes[1]);
                    if (keyType != null && valueType != null) {
                        CompositeType rowType = new CompositeType("Map", "Map of data", new String[]{"key", "value"}, new String[]{"key", "value"}, new OpenType[]{keyType, valueType});
                        return new ArrayType(1, rowType);
                    }
                }
            }
        }
        catch (OpenDataException ode) {
            BTraceLogger.debugPrint((Throwable)ode);
        }
        return null;
    }

    public Object convertToOpenTypeValue(OpenType ot, Object value) {
        Object val = null;
        for (MBeanDecoratorImpl d : this.listDecorators()) {
            val = d.toOpenTypeValue(ot, value, (BTraceMBean)this);
            if (val == null) continue;
            return val;
        }
        if (ot instanceof SimpleType) {
            if (value instanceof AtomicInteger) {
                return ((AtomicInteger)value).get();
            }
            if (value instanceof AtomicLong) {
                return ((AtomicLong)value).get();
            }
            return value;
        }
        if (ot instanceof ArrayType) {
            ArrayType at = (ArrayType)ot;
            OpenType<?> et = at.getElementOpenType();
            if (value instanceof Map && et instanceof CompositeType) {
                CompositeType ct = (CompositeType)et;
                HashMap map = new HashMap((Map)value);
                CompositeData[] array = new CompositeData[map.size()];
                OpenType<?> keyType = ct.getType("key");
                OpenType<?> valueType = ct.getType("value");
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("key", this.convertToOpenTypeValue(keyType, entry.getKey()));
                    row.put("value", this.convertToOpenTypeValue(valueType, entry.getValue()));
                    try {
                        array[index] = new CompositeDataSupport(ct, row);
                    }
                    catch (OpenDataException ode) {
                        BTraceLogger.debugPrint((Throwable)ode);
                    }
                    ++index;
                }
                return array;
            }
        }
        return value;
    }

    static {
        classToOpenTypes.put(Byte.TYPE, SimpleType.BYTE);
        classToOpenTypes.put(Byte.class, SimpleType.BYTE);
        classToOpenTypes.put(Short.TYPE, SimpleType.SHORT);
        classToOpenTypes.put(Short.class, SimpleType.SHORT);
        classToOpenTypes.put(Integer.TYPE, SimpleType.INTEGER);
        classToOpenTypes.put(Integer.class, SimpleType.INTEGER);
        classToOpenTypes.put(Long.TYPE, SimpleType.LONG);
        classToOpenTypes.put(Long.class, SimpleType.LONG);
        classToOpenTypes.put(Float.TYPE, SimpleType.FLOAT);
        classToOpenTypes.put(Float.class, SimpleType.FLOAT);
        classToOpenTypes.put(Double.TYPE, SimpleType.DOUBLE);
        classToOpenTypes.put(Double.class, SimpleType.DOUBLE);
        classToOpenTypes.put(Boolean.TYPE, SimpleType.BOOLEAN);
        classToOpenTypes.put(Boolean.class, SimpleType.BOOLEAN);
        classToOpenTypes.put(Character.TYPE, SimpleType.CHARACTER);
        classToOpenTypes.put(Character.class, SimpleType.CHARACTER);
        classToOpenTypes.put(AtomicInteger.class, SimpleType.INTEGER);
        classToOpenTypes.put(AtomicLong.class, SimpleType.LONG);
        classToOpenTypes.put(BigInteger.class, SimpleType.BIGINTEGER);
        classToOpenTypes.put(BigDecimal.class, SimpleType.BIGDECIMAL);
        classToOpenTypes.put(String.class, SimpleType.STRING);
        classToOpenTypes.put(ObjectName.class, SimpleType.OBJECTNAME);
        classToOpenTypes.put(Date.class, SimpleType.DATE);
    }

    private static class IterableServiceLoader<T>
    implements Iterable<T> {
        private ServiceLoader<T> loader;

        public IterableServiceLoader(ServiceLoader<T> l) {
            this.loader = l;
        }

        @Override
        public Iterator<T> iterator() {
            return this.loader.iterator();
        }
    }
}

