/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.mail;

import grails.artefact.Artefact;
import grails.artefact.Service;
import grails.config.Config;
import grails.core.support.GrailsConfigurationAware;
import grails.events.Events;
import grails.plugins.mail.MailMessageBuilder;
import grails.plugins.mail.MailMessageBuilderFactory;
import grails.plugins.metadata.GrailsPlugin;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.events.ClosureEventConsumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailMessage;
import reactor.bus.Bus;
import reactor.bus.Event;
import reactor.bus.EventBus;
import reactor.bus.registry.Registration;
import reactor.bus.selector.Selector;
import reactor.fn.Consumer;

@GrailsPlugin(name="mail", version="2.0.0.RC6")
@Artefact(value="Service")
public class MailService
implements InitializingBean,
DisposableBean,
GrailsConfigurationAware,
Service,
Events.Trait.FieldHelper,
GroovyObject {
    private static Object transactional;
    private Config configuration;
    private MailMessageBuilderFactory mailMessageBuilderFactory;
    private ThreadPoolExecutor mailExecutorService;
    private static final Integer DEFAULT_POOL_SIZE;
    private static Log log;
    @Autowired(required=true)
    private EventBus grails_events_Events__eventBus;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public MailService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Service.Trait.Helper.$init$((Service)this);
        Events.Trait.Helper.$init$((Events)this);
    }

    public MailMessage sendMail(Config config, @DelegatesTo(value=MailMessageBuilder.class, strategy=1) Closure callable) {
        if (this.isDisabled()) {
            log.warn((Object)"Sending emails disabled by configuration option");
            return (MailMessage)ScriptBytecodeAdapter.castToType(null, MailMessage.class);
        }
        MailMessageBuilder messageBuilder = this.mailMessageBuilderFactory.createBuilder(config);
        MailMessageBuilder mailMessageBuilder = messageBuilder;
        callable.setDelegate((Object)mailMessageBuilder);
        int n = Closure.DELEGATE_FIRST;
        callable.setResolveStrategy(n);
        callable.call((Object)messageBuilder);
        return messageBuilder.sendMessage(this.mailExecutorService);
    }

    public MailMessage sendMail(@DelegatesTo(value=MailMessageBuilder.class, strategy=1) Closure callable) {
        return this.sendMail(this.configuration, callable);
    }

    public boolean isDisabled() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.configuration.getProperty("grails.mail.disabled", Boolean.class, (Object)false));
    }

    public void setPoolSize(Integer poolSize) {
        Integer n = poolSize;
        this.mailExecutorService.setCorePoolSize(DefaultTypeTransformation.booleanUnbox((Object)n) ? n : DEFAULT_POOL_SIZE);
        Integer n2 = poolSize;
        this.mailExecutorService.setMaximumPoolSize(DefaultTypeTransformation.booleanUnbox((Object)n2) ? n2 : DEFAULT_POOL_SIZE);
    }

    public void destroy() throws Exception {
        this.mailExecutorService.shutdown();
        this.mailExecutorService.awaitTermination(10, TimeUnit.SECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        ThreadPoolExecutor threadPoolExecutor;
        this.mailExecutorService = threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Integer poolSize = (Integer)ScriptBytecodeAdapter.castToType((Object)this.configuration.getProperty("grails.mail.poolSize", Integer.class), Integer.class);
        try {
            this.mailExecutorService.allowCoreThreadTimeOut(true);
        }
        catch (MissingMethodException e) {
            log.info((Object)new GStringImpl(new Object[]{poolSize}, new String[]{"ThreadPoolExecutor.allowCoreThreadTimeOut method is missing; Java < 6 must be running. The thread pool size will never go below ", ", which isn't harmful, just a tiny bit wasteful of resources."}), (Throwable)e);
        }
        this.setPoolSize(poolSize);
    }

    static {
        Log log;
        int n = 5;
        DEFAULT_POOL_SIZE = n;
        boolean bl = false;
        transactional = bl;
        MailService.log = log = LogFactory.getLog((String)"grails.app.services.grails.plugins.mail.MailService");
        Service.Trait.Helper.$static$init$(MailService.class);
        Events.Trait.Helper.$static$init$(MailService.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;)Z", traitClass=Events.class)
    public boolean clearEventConsumers(Object arg1) {
        return Events.Trait.Helper.clearEventConsumers((Events)this, (Object)arg1);
    }

    public /* synthetic */ boolean grails_events_Eventstrait$super$clearEventConsumers(Object param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return DefaultTypeTransformation.booleanUnbox((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"clearEventConsumers", (Object)new Object[]{param0}));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"clearEventConsumers", (Object[])new Object[]{param0}));
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Lreactor/fn/Consumer;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Object arg1, Consumer<E> arg2) {
        return Events.Trait.Helper.on((Events)this, (Object)arg1, arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Object param0, Consumer<E> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Lgroovy/lang/Closure;Lgroovy/lang/Closure;)Lreactor/bus/Bus;", traitClass=Events.class)
    public <E> Bus sendAndReceive(Object arg1, Closure<E> arg2, @DelegatesTo(genericTypeIndex=-1, target="", value=ClosureEventConsumer.ReplyDecorator.class, strategy=1, type="") Closure arg3) {
        return Events.Trait.Helper.sendAndReceive((Events)this, (Object)arg1, arg2, (Closure)arg3);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Bus grails_events_Eventstrait$super$sendAndReceive(Object param0, Closure<E> param1, Closure param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Bus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"sendAndReceive", (Object)new Object[]{param0, param1, param2}), Bus.class);
        }
        return (Bus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"sendAndReceive", (Object[])new Object[]{param0, param1, param2}), Bus.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;)Lreactor/bus/Event;", traitClass=Events.class)
    public <T> Event<T> eventFor(T arg1) {
        return Events.Trait.Helper.eventFor((Events)this, arg1);
    }

    public /* synthetic */ <T> Event<T> grails_events_Eventstrait$super$eventFor(T param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Event)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"eventFor", (Object)new Object[]{param0}), Event.class);
        }
        return (Event)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"eventFor", (Object[])new Object[]{param0}), Event.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Ljava/lang/Object;)Lreactor/bus/Bus;", traitClass=Events.class)
    public Bus notify(Object arg1, Object arg2) {
        return Events.Trait.Helper.notify((Events)this, (Object)arg1, (Object)arg2);
    }

    public /* synthetic */ Bus grails_events_Eventstrait$super$notify(Object param0, Object param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Bus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"notify", (Object)new Object[]{param0, param1}), Bus.class);
        }
        return (Bus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"notify", (Object[])new Object[]{param0, param1}), Bus.class);
    }

    @Traits.TraitBridge(desc="(Lreactor/bus/selector/Selector;Lreactor/fn/Consumer;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Selector arg1, Consumer<E> arg2) {
        return Events.Trait.Helper.on((Events)this, (Selector)arg1, arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Selector param0, Consumer<E> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Class;Lgroovy/lang/Closure;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Class arg1, @DelegatesTo(genericTypeIndex=-1, target="", value=ClosureEventConsumer.ReplyDecorator.class, strategy=1, type="") Closure arg2) {
        return Events.Trait.Helper.on((Events)this, (Class)arg1, (Closure)arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Class param0, Closure param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Ljava/lang/Object;Lgroovy/lang/Closure;)Lreactor/bus/Bus;", traitClass=Events.class)
    public Bus sendAndReceive(Object arg1, Object arg2, @DelegatesTo(genericTypeIndex=-1, target="", value=ClosureEventConsumer.ReplyDecorator.class, strategy=1, type="") Closure arg3) {
        return Events.Trait.Helper.sendAndReceive((Events)this, (Object)arg1, (Object)arg2, (Closure)arg3);
    }

    public /* synthetic */ Bus grails_events_Eventstrait$super$sendAndReceive(Object param0, Object param1, Closure param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Bus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"sendAndReceive", (Object)new Object[]{param0, param1, param2}), Bus.class);
        }
        return (Bus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"sendAndReceive", (Object[])new Object[]{param0, param1, param2}), Bus.class);
    }

    @Traits.TraitBridge(desc="(Lreactor/bus/EventBus;)V", traitClass=Events.class)
    public void setEventBus(EventBus arg1) {
        Events.Trait.Helper.setEventBus((Events)this, (EventBus)arg1);
    }

    public /* synthetic */ void grails_events_Eventstrait$super$setEventBus(EventBus param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEventBus", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEventBus", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Lreactor/bus/Event;)Lreactor/bus/Bus;", traitClass=Events.class)
    public Bus notify(Object arg1, Event<? extends Object> arg2) {
        return Events.Trait.Helper.notify((Events)this, (Object)arg1, arg2);
    }

    public /* synthetic */ Bus grails_events_Eventstrait$super$notify(Object param0, Event<? extends Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Bus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"notify", (Object)new Object[]{param0, param1}), Bus.class);
        }
        return (Bus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"notify", (Object[])new Object[]{param0, param1}), Bus.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Lgroovy/lang/Closure;)Lreactor/bus/Bus;", traitClass=Events.class)
    public <E> Bus notify(Object arg1, Closure<E> arg2) {
        return Events.Trait.Helper.notify((Events)this, (Object)arg1, arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Bus grails_events_Eventstrait$super$notify(Object param0, Closure<E> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Bus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"notify", (Object)new Object[]{param0, param1}), Bus.class);
        }
        return (Bus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"notify", (Object[])new Object[]{param0, param1}), Bus.class);
    }

    @Traits.TraitBridge(desc="(Ljava/util/Map;Ljava/lang/Object;Lgroovy/lang/Closure;)Lreactor/bus/Event;", traitClass=Events.class)
    public <T> Event<T> eventFor(Map<String, Object> arg1, T arg2, Closure<Throwable> arg3) {
        return Events.Trait.Helper.eventFor((Events)this, arg1, arg2, arg3);
    }

    public /* synthetic */ <T> Event<T> grails_events_Eventstrait$super$eventFor(Map<String, Object> param0, T param1, Closure<Throwable> param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Event)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"eventFor", (Object)new Object[]{param0, param1, param2}), Event.class);
        }
        return (Event)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"eventFor", (Object[])new Object[]{param0, param1, param2}), Event.class);
    }

    @Traits.TraitBridge(desc="(Ljava/util/Map;Ljava/lang/Object;)Lreactor/bus/Event;", traitClass=Events.class)
    public <T> Event<T> eventFor(Map<String, Object> arg1, T arg2) {
        return Events.Trait.Helper.eventFor((Events)this, arg1, arg2);
    }

    public /* synthetic */ <T> Event<T> grails_events_Eventstrait$super$eventFor(Map<String, Object> param0, T param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Event)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"eventFor", (Object)new Object[]{param0, param1}), Event.class);
        }
        return (Event)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"eventFor", (Object[])new Object[]{param0, param1}), Event.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Object;Lgroovy/lang/Closure;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Object arg1, @DelegatesTo(genericTypeIndex=-1, target="", value=ClosureEventConsumer.ReplyDecorator.class, strategy=1, type="") Closure arg2) {
        return Events.Trait.Helper.on((Events)this, (Object)arg1, (Closure)arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Object param0, Closure param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="(Ljava/lang/Class;Lreactor/fn/Consumer;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Class arg1, Consumer<E> arg2) {
        return Events.Trait.Helper.on((Events)this, (Class)arg1, arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Class param0, Consumer<E> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="(Lreactor/bus/selector/Selector;Lgroovy/lang/Closure;)Lreactor/bus/registry/Registration;", traitClass=Events.class)
    public <E> Registration<Object, Consumer<E>> on(Selector arg1, @DelegatesTo(genericTypeIndex=-1, target="", value=ClosureEventConsumer.ReplyDecorator.class, strategy=1, type="") Closure arg2) {
        return Events.Trait.Helper.on((Events)this, (Selector)arg1, (Closure)arg2);
    }

    public /* synthetic */ <E extends Event<? extends Object>> Registration<Object, Consumer<E>> grails_events_Eventstrait$super$on(Selector param0, Closure param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Registration)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"on", (Object)new Object[]{param0, param1}), Registration.class);
        }
        return (Registration)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"on", (Object[])new Object[]{param0, param1}), Registration.class);
    }

    @Traits.TraitBridge(desc="()Lreactor/bus/EventBus;", traitClass=Events.class)
    public EventBus getEventBus() {
        return Events.Trait.Helper.getEventBus((Events)this);
    }

    public /* synthetic */ EventBus grails_events_Eventstrait$super$getEventBus() {
        if (this instanceof GeneratedGroovyProxy) {
            return (EventBus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEventBus", (Object)new Object[0]), EventBus.class);
        }
        return (EventBus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEventBus"), EventBus.class);
    }

    public EventBus grails_events_Events__eventBus$get() {
        return this.grails_events_Events__eventBus;
    }

    public EventBus grails_events_Events__eventBus$set(EventBus val) {
        EventBus eventBus;
        this.grails_events_Events__eventBus = eventBus = val;
        return eventBus;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MailService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static Object getTransactional() {
        return transactional;
    }

    public static void setTransactional(Object object) {
        transactional = object;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Config config) {
        this.configuration = config;
    }

    public MailMessageBuilderFactory getMailMessageBuilderFactory() {
        return this.mailMessageBuilderFactory;
    }

    public void setMailMessageBuilderFactory(MailMessageBuilderFactory mailMessageBuilderFactory) {
        this.mailMessageBuilderFactory = mailMessageBuilderFactory;
    }

    public ThreadPoolExecutor getMailExecutorService() {
        return this.mailExecutorService;
    }

    public void setMailExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        this.mailExecutorService = threadPoolExecutor;
    }
}

