/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import grails.plugin.cache.SimpleKeyGenerator;
import grails.plugins.GrailsVersionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.core.SpringVersion;

public class CustomCacheKeyGenerator
implements KeyGenerator {
    private final KeyGenerator innerKeyGenerator;

    public CustomCacheKeyGenerator(KeyGenerator innerKeyGenerator) {
        this.innerKeyGenerator = innerKeyGenerator;
    }

    public CustomCacheKeyGenerator() {
        if (SpringVersion.getVersion() == null || GrailsVersionUtils.isVersionGreaterThan((String)SpringVersion.getVersion(), (String)"4.0.3")) {
            this.innerKeyGenerator = new SimpleKeyGenerator();
        } else {
            try {
                this.innerKeyGenerator = (KeyGenerator)Class.forName("org.springframework.cache.interceptor.SimpleKeyGenerator").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object generate(Object target, Method method, Object ... params) {
        Class objClass = AopProxyUtils.ultimateTargetClass((Object)target);
        return new CacheKey(objClass.getName().intern(), method.toString().intern(), target.hashCode(), this.innerKeyGenerator.generate(target, method, params));
    }

    private static final class CacheKey
    implements Serializable {
        final String targetClassName;
        final String targetMethodName;
        final int targetObjectHashCode;
        final Object simpleKey;

        public CacheKey(String targetClassName, String targetMethodName, int targetObjectHashCode, Object simpleKey) {
            this.targetClassName = targetClassName;
            this.targetMethodName = targetMethodName;
            this.targetObjectHashCode = targetObjectHashCode;
            this.simpleKey = simpleKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.simpleKey == null ? 0 : this.simpleKey.hashCode());
            result = 31 * result + (this.targetClassName == null ? 0 : this.targetClassName.hashCode());
            result = 31 * result + (this.targetMethodName == null ? 0 : this.targetMethodName.hashCode());
            result = 31 * result + this.targetObjectHashCode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.simpleKey == null ? other.simpleKey != null : !this.simpleKey.equals(other.simpleKey)) {
                return false;
            }
            if (this.targetClassName == null ? other.targetClassName != null : !this.targetClassName.equals(other.targetClassName)) {
                return false;
            }
            if (this.targetMethodName == null ? other.targetMethodName != null : !this.targetMethodName.equals(other.targetMethodName)) {
                return false;
            }
            return this.targetObjectHashCode == other.targetObjectHashCode;
        }
    }
}

