/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.spring.BeanBuilder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.env.GrailsEnvironment;
import org.codehaus.groovy.grails.commons.spring.GrailsApplicationContext;
import org.codehaus.groovy.grails.commons.spring.OptimizedAutowireCapableBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.springframework.web.context.support.StandardServletEnvironment;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsWebApplicationContext
extends GrailsApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private String namespace;
    private ServletConfig servletConfig;
    private String[] configLocations = new String[0];
    private GrailsApplication grailsApplication;

    public GrailsWebApplicationContext() throws BeansException {
        super((DefaultListableBeanFactory)new OptimizedAutowireCapableBeanFactory());
    }

    public GrailsWebApplicationContext(GrailsApplication grailsApplication) {
        this();
        this.grailsApplication = grailsApplication;
    }

    public GrailsWebApplicationContext(ApplicationContext parent) throws BeansException {
        this((DefaultListableBeanFactory)new OptimizedAutowireCapableBeanFactory(), parent);
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory) {
        super(defaultListableBeanFactory);
    }

    public GrailsWebApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, ApplicationContext parent) {
        super(defaultListableBeanFactory, parent);
    }

    public ClassLoader getClassLoader() {
        GrailsApplication application = this.getGrailsApplication();
        return application == null ? super.getClassLoader() : application.getClassLoader();
    }

    private GrailsApplication getGrailsApplication() {
        if (this.grailsApplication == null) {
            ApplicationContext parent = this.getParent();
            if (parent != null) {
                if (parent instanceof GrailsWebApplicationContext) {
                    this.grailsApplication = ((GrailsWebApplicationContext)parent).getGrailsApplication();
                } else if (parent.containsBean("grailsApplication")) {
                    this.grailsApplication = (GrailsApplication)parent.getBean("grailsApplication", GrailsApplication.class);
                }
            }
            if (this.grailsApplication == null && this.containsBean("grailsApplication")) {
                this.grailsApplication = (GrailsApplication)this.getBean("grailsApplication", GrailsApplication.class);
            }
        }
        return this.grailsApplication;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocation(String configLocation) {
        Assert.notNull((Object)configLocation, (String)"Argument [configLocation] cannot be null");
        this.configLocations = new String[]{configLocation};
    }

    public void setConfigLocations(String[] configLocations) {
        Assert.notNull((Object)configLocations, (String)"Argument [configLocations] cannot be null");
        this.configLocations = configLocations;
    }

    public String[] getConfigLocations() {
        return this.configLocations;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.registerResolvableDependency(ServletContext.class, (Object)this.servletContext);
        WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory);
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver((ResourceLoader)this);
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.configLocations.length > 0) {
            for (String configLocation : this.configLocations) {
                BeanBuilder beanBuilder = new BeanBuilder(this.getParent(), this.getClassLoader());
                ServletContextResource resource = new ServletContextResource(this.getServletContext(), configLocation);
                beanBuilder.loadBeans((Resource)resource);
                beanBuilder.registerBeans((BeanDefinitionRegistry)this);
            }
        }
        super.prepareBeanFactory(beanFactory);
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    protected ConfigurableEnvironment createEnvironment() {
        GrailsApplication grailsApplication = this.getGrailsApplication();
        return grailsApplication == null ? new StandardServletEnvironment() : new GrailsEnvironment(grailsApplication);
    }

    public ConfigurableWebEnvironment getEnvironment() {
        ConfigurableEnvironment env = super.getEnvironment();
        Assert.isInstanceOf(ConfigurableWebEnvironment.class, (Object)env, (String)"ConfigurableWebApplication environment must be of type ConfigurableWebEnvironment");
        return (ConfigurableWebEnvironment)env;
    }
}

