/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.ext.jsp;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

class BodyContentImpl
extends BodyContent {
    static final char[] LINE_BREAK = System.getProperty("line.separator").toCharArray();
    private StreamCharBuffer streamBuffer;
    private Writer streamBufferWriter;

    BodyContentImpl(JspWriter out, boolean buffer) {
        super(out);
        if (buffer) {
            this.initBuffer();
        }
    }

    void initBuffer() {
        this.streamBuffer = new StreamCharBuffer();
        this.streamBufferWriter = this.streamBuffer.getWriter();
    }

    public void flush() throws IOException {
        if (this.streamBuffer == null) {
            this.getEnclosingWriter().flush();
        }
    }

    public void clear() throws IOException {
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        if (this.streamBuffer == null) {
            throw new IOException("Can't clear");
        }
        this.initBuffer();
    }

    public int getRemaining() {
        return Integer.MAX_VALUE;
    }

    public void newLine() throws IOException {
        this.write(LINE_BREAK);
    }

    public void close() throws IOException {
    }

    public void print(boolean b) throws IOException {
        this.write(b ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public void print(char c) throws IOException {
        this.write(c);
    }

    public void print(char[] chars) throws IOException {
        this.write(chars);
    }

    public void print(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public void print(float f) throws IOException {
        this.write(Float.toString(f));
    }

    public void print(int i) throws IOException {
        this.write(Integer.toString(i));
    }

    public void print(long l) throws IOException {
        this.write(Long.toString(l));
    }

    public void print(Object o) throws IOException {
        this.write(o == null ? "null" : o.toString());
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] chars) throws IOException {
        this.print(chars);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.newLine();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.newLine();
    }

    public void write(int c) throws IOException {
        if (this.streamBufferWriter != null) {
            this.streamBufferWriter.write(c);
        } else {
            this.getEnclosingWriter().write(c);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.streamBufferWriter != null) {
            this.streamBufferWriter.write(cbuf, off, len);
        } else {
            this.getEnclosingWriter().write(cbuf, off, len);
        }
    }

    public String getString() {
        return this.streamBuffer.toString();
    }

    public Reader getReader() {
        return this.streamBuffer.getReader();
    }

    public void writeOut(Writer out) throws IOException {
        this.streamBuffer.writeTo(out);
    }
}

