/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.json;

import groovy.lang.Writable;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.web.json.JSONException;
import org.codehaus.groovy.grails.web.json.JSONObject;
import org.codehaus.groovy.grails.web.json.JSONWriter;

public class PrettyPrintJSONWriter
extends JSONWriter {
    public static final String DEFAULT_INDENT_STR = "  ";
    public static final String NEWLINE;
    private int indentLevel = 0;
    private final String indentStr;

    public PrettyPrintJSONWriter(Writer w) {
        this(w, DEFAULT_INDENT_STR);
    }

    public PrettyPrintJSONWriter(Writer w, String indentStr) {
        super(w);
        this.indentStr = indentStr;
    }

    private void newline() {
        try {
            this.writer.write(NEWLINE);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private void indent() {
        try {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(this.indentStr);
            }
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    protected JSONWriter append(Writable writableValue) {
        if (this.mode == JSONWriter.Mode.OBJECT || this.mode == JSONWriter.Mode.ARRAY) {
            try {
                if (this.comma && this.mode == JSONWriter.Mode.ARRAY) {
                    this.comma();
                }
                if (this.mode == JSONWriter.Mode.ARRAY) {
                    this.newline();
                    this.indent();
                }
                writableValue.writeTo(this.writer);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == JSONWriter.Mode.OBJECT) {
                this.mode = JSONWriter.Mode.KEY;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence: expected mode to be OBJECT or ARRAY when writing '" + writableValue + "' but was " + (Object)((Object)this.mode));
    }

    @Override
    protected JSONWriter end(JSONWriter.Mode m, char c) {
        this.newline();
        this.indent();
        return super.end(m, c);
    }

    @Override
    public JSONWriter array() {
        super.array();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JSONWriter endArray() {
        --this.indentLevel;
        super.endArray();
        return this;
    }

    @Override
    public JSONWriter object() {
        super.object();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JSONWriter endObject() {
        --this.indentLevel;
        super.endObject();
        return this;
    }

    @Override
    public JSONWriter key(String s) {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == JSONWriter.Mode.KEY) {
            try {
                if (this.comma) {
                    this.comma();
                }
                this.newline();
                this.indent();
                this.writer.write(JSONObject.quote(s));
                this.writer.write(": ");
                this.comma = false;
                this.mode = JSONWriter.Mode.OBJECT;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key: expected mode of KEY but was " + (Object)((Object)this.mode));
    }

    static {
        String nl = System.getProperty("line.separator");
        NEWLINE = nl != null ? nl : "\n";
    }
}

