/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.web.taglib.GrailsTag;
import org.codehaus.groovy.grails.web.taglib.GroovyCollectTag;
import org.codehaus.groovy.grails.web.taglib.GroovyDefTag;
import org.codehaus.groovy.grails.web.taglib.GroovyEachTag;
import org.codehaus.groovy.grails.web.taglib.GroovyElseIfTag;
import org.codehaus.groovy.grails.web.taglib.GroovyElseTag;
import org.codehaus.groovy.grails.web.taglib.GroovyFindAllTag;
import org.codehaus.groovy.grails.web.taglib.GroovyGrepTag;
import org.codehaus.groovy.grails.web.taglib.GroovyIfTag;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.GroovyUnlessTag;
import org.codehaus.groovy.grails.web.taglib.GroovyWhileTag;
import org.codehaus.groovy.grails.web.taglib.RenderInputTag;
import org.codehaus.groovy.grails.web.taglib.RequestContextTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public class GrailsTagRegistry {
    private static GrailsTagRegistry instance = new GrailsTagRegistry();
    private static Map<String, Class<?>> tagRegistry = new ConcurrentHashMap();

    private GrailsTagRegistry() {
    }

    public static GrailsTagRegistry getInstance() {
        return instance;
    }

    public void registerTag(String tagName, Class<?> tag) {
        tagRegistry.put(tagName, tag);
    }

    public boolean tagSupported(String tagName) {
        return tagRegistry.containsKey(tagName);
    }

    public boolean isSyntaxTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            return GroovySyntaxTag.class.isAssignableFrom(tagRegistry.get(tagName));
        }
        return false;
    }

    public GrailsTag newTag(String tagName) {
        if (!tagRegistry.containsKey(tagName)) {
            throw new GrailsTagException("Tag [" + tagName + "] is not a a valid grails tag");
        }
        Class<?> tagClass = tagRegistry.get(tagName);
        try {
            return (GrailsTag)tagClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new GrailsTagException("Instantiation error loading tag [" + tagName + "]: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new GrailsTagException("Illegal access error loading tag [" + tagName + "]: " + e.getMessage(), e);
        }
    }

    public boolean isRequestContextTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            return RequestContextTag.class.isAssignableFrom(tagRegistry.get(tagName));
        }
        return false;
    }

    static {
        instance.registerTag("renderInput", RenderInputTag.class);
        instance.registerTag("each", GroovyEachTag.class);
        instance.registerTag("if", GroovyIfTag.class);
        instance.registerTag("unless", GroovyUnlessTag.class);
        instance.registerTag("else", GroovyElseTag.class);
        instance.registerTag("elseif", GroovyElseIfTag.class);
        instance.registerTag("findAll", GroovyFindAllTag.class);
        instance.registerTag("collect", GroovyCollectTag.class);
        instance.registerTag("grep", GroovyGrepTag.class);
        instance.registerTag("while", GroovyWhileTag.class);
        instance.registerTag("def", GroovyDefTag.class);
    }
}

