/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriterAdapter;
import org.codehaus.groovy.grails.web.util.StreamByteBuffer;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class IncludeResponseWrapper
extends HttpServletResponseWrapper {
    private StreamCharBuffer charBuffer;
    private PrintWriter pw;
    private StreamByteBuffer byteBuffer;
    private OutputStream os;
    private ServletOutputStream sos;
    private boolean usingStream;
    private boolean usingWriter;
    private int status;
    private String contentType;
    private boolean committed;
    private String redirectURL;

    public IncludeResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void sendRedirect(String s) throws IOException {
        this.committed = true;
        this.redirectURL = s;
        super.sendRedirect(s);
    }

    public int getStatus() {
        return this.status;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }

    public void setLocale(Locale locale) {
    }

    public void sendError(int i, String s) throws IOException {
        this.setStatus(i);
        this.flushBuffer();
    }

    public void sendError(int i) throws IOException {
        this.setStatus(i);
        this.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("Method getWriter() already called");
        }
        if (!this.usingStream) {
            this.usingStream = true;
            this.byteBuffer = new StreamByteBuffer();
            this.os = this.byteBuffer.getOutputStream();
            this.sos = new ServletOutputStream(){

                public void write(byte[] b, int off, int len) throws IOException {
                    IncludeResponseWrapper.this.os.write(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    IncludeResponseWrapper.this.os.write(b);
                }

                public void write(int b) throws IOException {
                    IncludeResponseWrapper.this.os.write(b);
                }
            };
        }
        return this.sos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingStream) {
            throw new IllegalStateException("Method getOutputStream() already called");
        }
        if (!this.usingWriter) {
            this.usingWriter = true;
            this.charBuffer = new StreamCharBuffer();
            this.charBuffer.setNotifyParentBuffersEnabled(false);
            this.pw = GrailsPrintWriterAdapter.newInstance(this.charBuffer.getWriter());
        }
        return this.pw;
    }

    public Object getContent() throws CharacterCodingException {
        return this.getContent("UTF-8");
    }

    public Object getContent(String encoding) throws CharacterCodingException {
        if (this.usingWriter) {
            return this.charBuffer;
        }
        if (this.usingStream) {
            return this.byteBuffer.readAsString(encoding);
        }
        return "";
    }
}

