/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import grails.util.GrailsWebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.StackTraceFilterer;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ErrorHandlingServlet
extends GrailsDispatcherServlet {
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";
    private static final long serialVersionUID = 8792197458391395589L;
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String TEXT_HTML = "text/html";
    public static final String UTF_8 = "UTF-8";
    private String defaultEncoding;

    protected void initFrameworkServlet() throws ServletException, BeansException {
        super.initFrameworkServlet();
        GrailsApplication grailsApplication = GrailsWebUtil.lookupApplication(this.getServletContext());
        String encoding = (String)grailsApplication.getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
        if (encoding != null) {
            this.defaultEncoding = encoding;
        }
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        UrlMappingInfo urlMappingInfo;
        if (response.isCommitted()) {
            return;
        }
        int statusCode = request.getAttribute("javax.servlet.error.status_code") != null ? Integer.parseInt(request.getAttribute("javax.servlet.error.status_code").toString()) : 500;
        Throwable t = null;
        if (request.getAttribute("javax.servlet.error.exception") != null && !((t = (Throwable)request.getAttribute("javax.servlet.error.exception")) instanceof GrailsWrappedRuntimeException) && request.getAttribute("exception") == null) {
            request.setAttribute("exception", (Object)new GrailsWrappedRuntimeException(this.getServletContext(), t));
        }
        UrlMappingsHolder urlMappingsHolder = (UrlMappingsHolder)this.getBean("grailsUrlMappingsHolder");
        UrlMappingInfo matchedInfo = null;
        if (t != null) {
            this.createStackTraceFilterer().filter(t, true);
            matchedInfo = urlMappingsHolder.matchStatusCode(statusCode, t);
            if (matchedInfo == null) {
                matchedInfo = urlMappingsHolder.matchStatusCode(statusCode, GrailsExceptionResolver.getRootCause(t));
            }
        }
        if (matchedInfo == null) {
            matchedInfo = urlMappingsHolder.matchStatusCode(statusCode);
        }
        if ((urlMappingInfo = matchedInfo) != null) {
            GrailsWebRequest webRequest;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            boolean restoreOriginalRequestAttributes = false;
            if (requestAttributes instanceof GrailsWebRequest) {
                webRequest = (GrailsWebRequest)requestAttributes;
                urlMappingInfo.configure(webRequest);
            } else {
                restoreOriginalRequestAttributes = true;
                webRequest = new GrailsWebRequest(request, response, this.getServletContext());
                RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
                urlMappingInfo.configure(webRequest);
            }
            HttpServletResponse originalResponse = WrappedResponseHolder.getWrappedResponse();
            try {
                WrappedResponseHolder.setWrappedResponse(response);
                String viewName = urlMappingInfo.getViewName();
                if (viewName == null || viewName.endsWith(GSP_SUFFIX) || viewName.endsWith(JSP_SUFFIX)) {
                    WebUtils.forwardRequestForUrlMappingInfo(request, response, urlMappingInfo, Collections.EMPTY_MAP);
                    return;
                }
                ViewResolver viewResolver = WebUtils.lookupViewResolver(this.getServletContext());
                if (viewResolver == null) return;
                try {
                    if (!response.isCommitted()) {
                        response.setContentType("text/html;charset=" + this.defaultEncoding);
                    }
                    View v = WebUtils.resolveView(request, urlMappingInfo, viewName, viewResolver);
                    v.render(Collections.EMPTY_MAP, request, response);
                    return;
                }
                catch (Throwable e) {
                    this.createStackTraceFilterer().filter(e);
                    this.renderDefaultResponse(response, statusCode, "Internal Server Error", e.getMessage());
                }
                return;
            }
            finally {
                WrappedResponseHolder.setWrappedResponse(originalResponse);
                if (restoreOriginalRequestAttributes) {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                }
            }
        } else {
            this.renderDefaultResponse(response, statusCode);
        }
    }

    private StackTraceFilterer createStackTraceFilterer() {
        try {
            GrailsApplication application = (GrailsApplication)this.getBean("grailsApplication");
            return (StackTraceFilterer)GrailsClassUtils.instantiateFromFlatConfig((Map)application.getFlatConfig(), (String)"grails.logging.stackTraceFiltererClass", (String)DefaultStackTraceFilterer.class.getName());
        }
        catch (Throwable t) {
            this.logger.error((Object)("Problem instantiating StackTraceFilterer class, using default: " + t.getMessage()));
            return new DefaultStackTraceFilterer();
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode) throws IOException {
        if (statusCode == 404) {
            this.renderDefaultResponse(response, statusCode, "Not Found", "Page not found.");
        } else {
            this.renderDefaultResponse(response, statusCode, "Internal Error", "Internal server error.");
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode, String title, String text) throws IOException {
        response.setStatus(404);
        response.setContentType(TEXT_HTML);
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<HTML>\n<HEAD>\n<TITLE>Error " + statusCode + " - " + title);
        ((Writer)writer).write("</TITLE>\n<BODY>\n<H2>Error " + statusCode + " - " + title + ".</H2>\n");
        ((Writer)writer).write(text + "<BR/>");
        for (int i = 0; i < 20; ++i) {
            ((Writer)writer).write("\n<!-- Padding for IE                  -->");
        }
        ((Writer)writer).write("\n</BODY>\n</HTML>\n");
        ((Writer)writer).flush();
    }

    private Object getBean(String name) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return wac.getBean(name);
    }
}

