/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.sitemesh.GrailsRoutablePrintWriter;
import org.codehaus.groovy.grails.web.util.BoundedCharsAsEncodedBytesCounter;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriterAdapter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class GSPResponseWriter
extends GrailsPrintWriterAdapter {
    protected static final Log LOG = LogFactory.getLog(GSPResponseWriter.class);
    private ServletResponse response;
    private BoundedCharsAsEncodedBytesCounter bytesCounter;
    public static final boolean CONTENT_LENGTH_COUNTING_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableContentLength");
    public static final boolean BUFFERING_ENABLED = Boolean.valueOf(System.getProperty("GSPResponseWriter.enableBuffering", "true"));
    public static final boolean AUTOFLUSH_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableAutoFlush");
    private static final int BUFFER_SIZE = Integer.getInteger("GSPResponseWriter.bufferSize", 8042);

    public static GSPResponseWriter getInstance(ServletResponse response) {
        return GSPResponseWriter.getInstance(response, BUFFER_SIZE);
    }

    private static GSPResponseWriter getInstance(final ServletResponse response, int max) {
        Writer target = null;
        StreamCharBuffer streamBuffer = null;
        BoundedCharsAsEncodedBytesCounter bytesCounter = null;
        if (!(response instanceof GrailsContentBufferingResponse) && (BUFFERING_ENABLED || CONTENT_LENGTH_COUNTING_ENABLED)) {
            streamBuffer = new StreamCharBuffer(max, 0, max);
            streamBuffer.setChunkMinSize(max / 2);
            target = streamBuffer.getWriter();
            if (CONTENT_LENGTH_COUNTING_ENABLED) {
                bytesCounter = new BoundedCharsAsEncodedBytesCounter(max * 2, response.getCharacterEncoding());
                streamBuffer.connectTo(bytesCounter.getCountingWriter(), AUTOFLUSH_ENABLED);
            }
            streamBuffer.connectTo(new StreamCharBuffer.LazyInitializingWriter(){

                public Writer getWriter() throws IOException {
                    return response.getWriter();
                }
            }, AUTOFLUSH_ENABLED);
        } else {
            try {
                target = response.getWriter();
            }
            catch (IOException e) {
                LOG.error((Object)"Problem getting writer from response", (Throwable)e);
                throw new RuntimeException("Problem getting writer from response", e);
            }
        }
        return new GSPResponseWriter(target, response, bytesCounter);
    }

    private static GSPResponseWriter getInstance(Writer target, int max) {
        if (BUFFERING_ENABLED && !(target instanceof GrailsRoutablePrintWriter) && !(target instanceof StreamCharBuffer.StreamCharBufferWriter)) {
            StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
            streamBuffer.connectTo(target, false);
            Writer writer = streamBuffer.getWriter();
            return new GSPResponseWriter(writer);
        }
        return new GSPResponseWriter(target);
    }

    private GSPResponseWriter(Writer activeWriter, ServletResponse response, BoundedCharsAsEncodedBytesCounter bytesCounter) {
        super(activeWriter);
        this.response = response;
        this.bytesCounter = bytesCounter;
    }

    private GSPResponseWriter(Writer activeWriter) {
        super(activeWriter);
    }

    public void close() {
        GrailsWebRequest webRequest;
        this.flush();
        if (this.canFlushContentLengthAwareResponse()) {
            int size = this.bytesCounter.size();
            if (size > 0) {
                this.response.setContentLength(size);
            }
            this.flushResponse();
        } else if (!this.isTrouble() && (webRequest = GrailsWebRequest.lookup()) != null && webRequest.getCurrentRequest().getAttribute("__sitemesh__page") != null) {
            this.flushResponse();
        }
    }

    private boolean canFlushContentLengthAwareResponse() {
        return CONTENT_LENGTH_COUNTING_ENABLED && this.bytesCounter != null && this.response != null && !this.response.isCommitted() && !this.isTrouble();
    }

    private void flushResponse() {
        try {
            this.response.getWriter().flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }
}

