/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.PluginBuildSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.StaticResourceLoader;
import org.codehaus.groovy.grails.web.pages.discovery.DefaultGroovyPageLocator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class GroovyPageResourceLoader
extends StaticResourceLoader {
    public static final String BEAN_ID = "groovyPageResourceLoader";
    private static final Log LOG = LogFactory.getLog(GroovyPageResourceLoader.class);
    private static final String PLUGINS_PATH = "/plugins/";
    private Resource localBaseResource;
    private PluginBuildSettings pluginSettings;

    public void setBaseResource(Resource baseResource) {
        this.localBaseResource = baseResource;
        super.setBaseResource(baseResource);
    }

    public void setPluginSettings(PluginBuildSettings settings) {
        this.pluginSettings = settings;
    }

    public Resource getResource(String location) {
        Assert.hasLength((String)location, (String)"Argument [location] cannot be null or blank");
        if (location.startsWith(PLUGINS_PATH)) {
            Resource[] inlinePluginDirectories;
            if (this.pluginSettings == null) {
                throw new RuntimeException("'pluginsettings' has not been initialised.");
            }
            List pluginBaseDirectories = this.pluginSettings.getPluginBaseDirectories();
            DefaultGroovyPageLocator.PluginViewPathInfo pluginViewPathInfo = DefaultGroovyPageLocator.getPluginViewPathInfo(location);
            String path = pluginViewPathInfo.basePath;
            String pluginName = pluginViewPathInfo.pluginName;
            String pathRelativeToPlugin = pluginViewPathInfo.path;
            for (String pluginBaseDirectory : pluginBaseDirectories) {
                String pathToResource = pluginBaseDirectory + File.separatorChar + path;
                Resource r = super.getResource("file:" + pathToResource);
                if (r.exists()) {
                    return r;
                }
                pathToResource = this.buildPluginViewPath(pluginBaseDirectory, pluginName, pathRelativeToPlugin);
                r = super.getResource(pathToResource);
                if (!r.exists()) continue;
                return r;
            }
            for (Resource inlinePluginDirectory : inlinePluginDirectories = this.pluginSettings.getInlinePluginDirectories()) {
                try {
                    File dirFile = inlinePluginDirectory.getFile();
                    File pageFile = new File(dirFile, pathRelativeToPlugin);
                    if (pageFile.exists()) {
                        return new FileSystemResource(pageFile);
                    }
                    String pathToInlinePluginView = this.buildPluginViewPathFromBase(dirFile.getAbsolutePath(), pathRelativeToPlugin, new StringBuilder("file:"));
                    Resource resource = super.getResource(pathToInlinePluginView);
                    if (resource.exists()) {
                        return resource;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        Resource resource = super.getResource(location);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved GSP location [" + location + "] to resource [" + resource + "] (exists? [" + resource.exists() + "]) using base resource [" + this.localBaseResource + "]"));
        }
        return resource;
    }

    protected String buildPluginViewPath(String pluginBaseDirectory, String pluginName, String pathRelativeToPlugin) {
        StringBuilder builder = new StringBuilder("file:").append(pluginBaseDirectory).append(File.separatorChar);
        return this.buildPluginViewPathFromBase(pluginName, pathRelativeToPlugin, builder);
    }

    protected String buildPluginViewPathFromBase(String pluginBase, String pathRelativeToPlugin, StringBuilder builder) {
        return builder.append(pluginBase).append(File.separatorChar).append("grails-app").append(File.separatorChar).append("views").append(pathRelativeToPlugin).toString();
    }
}

