/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.Closure;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsCodecClass;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;
import org.codehaus.groovy.runtime.GStringImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecPrintWriter
extends GrailsPrintWriter {
    private Closure<?> encodeClosure;

    public CodecPrintWriter(GrailsApplication grailsApplication, Writer out, Class<?> codecClass) {
        super(out);
        this.allowUnwrappingOut = false;
        this.initEncode(grailsApplication, codecClass);
    }

    @Override
    public void setOut(Writer newOut) {
        this.out = newOut;
    }

    @Override
    public boolean isUsed() {
        return this.usageFlag;
    }

    @Override
    protected Writer findStreamCharBufferTarget(boolean markUsed) {
        return this.unwrapWriter(this.getOut());
    }

    private void initEncode(GrailsApplication grailsApplication, Class<?> codecClass) {
        if (grailsApplication != null && codecClass != null) {
            GrailsCodecClass codecArtefact = (GrailsCodecClass)grailsApplication.getArtefact("Codec", codecClass.getName());
            this.encodeClosure = codecArtefact.getEncodeMethod();
        }
    }

    private Object encodeObject(Object o) {
        if (this.encodeClosure == null) {
            return o;
        }
        try {
            return this.encodeClosure.call(o);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling encode method " + this.encodeClosure, e);
        }
    }

    @Override
    public void print(Object obj) {
        this.encodeAndPrint(obj);
    }

    private void encodeAndPrint(Object obj) {
        if (this.trouble || obj == null) {
            this.usageFlag = true;
            return;
        }
        Object encoded = this.encodeObject(obj);
        if (encoded == null) {
            return;
        }
        Class<?> clazz = encoded.getClass();
        if (clazz == String.class) {
            super.write((String)encoded);
        } else if (clazz == StreamCharBuffer.class) {
            super.write((StreamCharBuffer)encoded);
        } else if (clazz == GStringImpl.class) {
            super.write((Writable)encoded);
        } else if (encoded instanceof Writable) {
            super.write((Writable)encoded);
        } else if (obj instanceof CharSequence) {
            try {
                this.usageFlag = true;
                this.out.append((CharSequence)encoded);
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        } else {
            super.write(String.valueOf(encoded));
        }
    }

    @Override
    public void print(String s) {
        this.encodeAndPrint(s);
    }

    @Override
    public void write(String s) {
        this.encodeAndPrint(s);
    }

    @Override
    public void write(int c) {
        this.encodeAndPrint(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.encodeAndPrint(new String(buf, off, len));
    }

    @Override
    public void write(String s, int off, int len) {
        this.encodeAndPrint(s.substring(off, off + len));
    }

    @Override
    public void write(char[] buf) {
        this.encodeAndPrint(new String(buf));
    }

    @Override
    public GrailsPrintWriter append(CharSequence csq, int start, int end) {
        this.encodeAndPrint(csq.subSequence(start, end));
        return this;
    }

    @Override
    public GrailsPrintWriter append(CharSequence csq) {
        this.encodeAndPrint(csq);
        return this;
    }

    @Override
    public GrailsPrintWriter append(Object obj) {
        this.print(obj);
        return this;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void write(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void print(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void append(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
    }

    @Override
    public void println(StreamCharBuffer otherBuffer) {
        this.encodeAndPrint(otherBuffer);
        this.println();
    }

    @Override
    public GrailsPrintWriter leftShift(StreamCharBuffer otherBuffer) {
        if (otherBuffer != null) {
            this.encodeAndPrint(otherBuffer);
        }
        return this;
    }

    @Override
    public void write(Writable writable) {
        this.usageFlag = true;
        if (this.trouble) {
            return;
        }
        try {
            writable.writeTo((Writer)this);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }
}

