/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.Environment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.pages.AbstractGroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPageRequestBinding
extends AbstractGroovyPageBinding {
    private static Log log = LogFactory.getLog(GroovyPageRequestBinding.class);
    private GrailsWebRequest webRequest;
    private Map<String, Class<?>> cachedDomainsWithoutPackage;
    private boolean developmentMode = Environment.isDevelopmentMode();
    private Set<String> requestAttributeVariables = new HashSet<String>();
    private static Map<String, LazyRequestBasedValue> lazyRequestBasedValuesMap;

    public GroovyPageRequestBinding(GrailsWebRequest webRequest) {
        GroovyPagesTemplateEngine templateEngine;
        this.webRequest = webRequest;
        if (webRequest != null && (templateEngine = webRequest.getAttributes().getPagesTemplateEngine()) != null) {
            this.setCachedDomainsWithoutPackage(templateEngine.getDomainClassMap());
        }
    }

    public boolean isRequestAttributeVariable(String name) {
        return this.requestAttributeVariables.contains(name);
    }

    public Object getVariable(String name) {
        Object val = this.getVariablesMap().get(name);
        if (val == null && !this.getVariablesMap().containsKey(name) && this.webRequest != null) {
            val = this.webRequest.getCurrentRequest().getAttribute(name);
            if (val != null) {
                this.requestAttributeVariables.add(name);
            } else {
                LazyRequestBasedValue lazyValue = lazyRequestBasedValuesMap.get(name);
                if (lazyValue != null) {
                    val = lazyValue.evaluate(this.webRequest);
                }
                if (val == null && this.cachedDomainsWithoutPackage != null) {
                    val = this.cachedDomainsWithoutPackage.get(name);
                }
                if (val == null && this.developmentMode && log.isDebugEnabled()) {
                    log.debug((Object)("Variable '" + name + "' not found in binding or the value is null."));
                }
            }
        }
        return val;
    }

    public void setCachedDomainsWithoutPackage(Map<String, Class<?>> cachedDomainsWithoutPackage) {
        this.cachedDomainsWithoutPackage = cachedDomainsWithoutPackage;
    }

    @Override
    public Set<String> getVariableNames() {
        if (this.getVariablesMap().isEmpty()) {
            return lazyRequestBasedValuesMap.keySet();
        }
        HashSet<String> variableNames = new HashSet<String>(lazyRequestBasedValuesMap.keySet());
        variableNames.addAll(this.getVariablesMap().keySet());
        return variableNames;
    }

    static {
        Map<String, LazyRequestBasedValue> m = lazyRequestBasedValuesMap = new HashMap<String, LazyRequestBasedValue>();
        m.put("webRequest", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest;
            }
        });
        m.put("request", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getCurrentRequest();
            }
        });
        m.put("response", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getCurrentResponse();
            }
        });
        m.put("flash", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getFlashScope();
            }
        });
        m.put("application", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getServletContext();
            }
        });
        m.put("applicationContext", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getAttributes().getApplicationContext();
            }
        });
        m.put("grailsApplication", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getAttributes().getGrailsApplication();
            }
        });
        m.put("session", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getSession();
            }
        });
        m.put("params", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getParams();
            }
        });
        m.put("actionName", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getActionName();
            }
        });
        m.put("controllerName", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getControllerName();
            }
        });
        m.put("org.codehaus.groovy.grails.CONTROLLER", new LazyRequestBasedValue(){

            public Object evaluate(GrailsWebRequest webRequest) {
                return webRequest.getAttributes().getController((ServletRequest)webRequest.getCurrentRequest());
            }
        });
    }

    private static interface LazyRequestBasedValue {
        public Object evaluate(GrailsWebRequest var1);
    }
}

