/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.DecoratorMapper2DecoratorSelector;
import com.opensymphony.sitemesh.compatability.HTMLPage2Content;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.errors.GrailsExceptionResolver;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequestFilter;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.grails.web.sitemesh.FactoryHolder;
import org.codehaus.groovy.grails.web.util.IncludedContent;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ErrorHandlingServlet
extends GrailsDispatcherServlet {
    private static final String TEXT_HTML = "text/html";
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        return request;
    }

    protected void doDispatch(final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        UrlMappingInfo urlMappingInfo;
        int statusCode = request.getAttribute("javax.servlet.error.status_code") != null ? Integer.parseInt(request.getAttribute("javax.servlet.error.status_code").toString()) : 500;
        Throwable t = null;
        if (request.getAttribute("javax.servlet.error.exception") != null && !((t = (Throwable)request.getAttribute("javax.servlet.error.exception")) instanceof GrailsWrappedRuntimeException) && request.getAttribute("exception") == null) {
            request.setAttribute("exception", (Object)new GrailsWrappedRuntimeException(this.getServletContext(), t));
        }
        UrlMappingsHolder urlMappingsHolder = this.lookupUrlMappings();
        UrlMappingInfo matchedInfo = null;
        if (t != null && (matchedInfo = urlMappingsHolder.matchStatusCode(statusCode, t)) == null) {
            matchedInfo = urlMappingsHolder.matchStatusCode(statusCode, GrailsExceptionResolver.getRootCause(t));
        }
        if (matchedInfo == null) {
            matchedInfo = urlMappingsHolder.matchStatusCode(statusCode);
        }
        if ((urlMappingInfo = matchedInfo) != null) {
            GrailsWebRequestFilter grailsWebRequestFilter = new GrailsWebRequestFilter();
            grailsWebRequestFilter.setServletContext(this.getServletContext());
            grailsWebRequestFilter.doFilter((ServletRequest)request, (ServletResponse)response, new FilterChain(){

                public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                    GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
                    urlMappingInfo.configure(webRequest);
                    String viewName = urlMappingInfo.getViewName();
                    if (viewName == null || viewName.endsWith(ErrorHandlingServlet.GSP_SUFFIX) || viewName.endsWith(ErrorHandlingServlet.JSP_SUFFIX)) {
                        IncludedContent includeResult = WebUtils.includeForUrlMappingInfo(request, response, urlMappingInfo, Collections.EMPTY_MAP);
                        if (includeResult.getRedirectURL() != null) {
                            response.sendRedirect(includeResult.getRedirectURL());
                        } else {
                            String layout;
                            Factory factory = FactoryHolder.getFactory();
                            PageParser parser = ErrorHandlingServlet.this.getPageParser(factory, response);
                            Page p = parser != null ? parser.parse(includeResult.getContentAsCharArray()) : null;
                            String string = layout = p != null ? p.getProperty("meta.layout") : null;
                            if (layout != null && p != null) {
                                SiteMeshWebAppContext webAppContext;
                                HTMLPage2Content content = new HTMLPage2Content((HTMLPage)p);
                                DecoratorMapper2DecoratorSelector decoratorSelector = new DecoratorMapper2DecoratorSelector(factory.getDecoratorMapper());
                                Decorator d = decoratorSelector.selectDecorator((Content)content, (SiteMeshContext)(webAppContext = new SiteMeshWebAppContext(request, response, webRequest.getServletContext())));
                                if (d != null) {
                                    response.setContentType(includeResult.getContentType());
                                    d.render((Content)content, (SiteMeshContext)webAppContext);
                                } else {
                                    ErrorHandlingServlet.this.writeOriginal(response, includeResult);
                                }
                            } else {
                                ErrorHandlingServlet.this.writeOriginal(response, includeResult);
                            }
                        }
                    } else {
                        ViewResolver viewResolver = WebUtils.lookupViewResolver(ErrorHandlingServlet.this.getServletContext());
                        if (viewResolver != null) {
                            try {
                                View v = WebUtils.resolveView(request, urlMappingInfo, viewName, viewResolver);
                                v.render(Collections.EMPTY_MAP, request, response);
                            }
                            catch (Exception e) {
                                throw new UrlMappingException("Error mapping onto view [" + viewName + "]: " + e.getMessage(), e);
                            }
                        }
                    }
                }
            });
        } else {
            this.renderDefaultResponse(response, statusCode);
        }
    }

    private void writeOriginal(HttpServletResponse response, IncludedContent includeResult) {
        try {
            PrintWriter printWriter;
            response.setContentType(includeResult.getContentType());
            try {
                printWriter = response.getWriter();
            }
            catch (IllegalStateException e) {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            }
            includeResult.writeTo(printWriter);
            printWriter.flush();
        }
        catch (IOException e) {
            throw new ControllerExecutionException("Error writing out error page: " + e.getMessage(), e);
        }
    }

    private PageParser getPageParser(Factory factory, HttpServletResponse response) {
        if (factory != null) {
            PageParser pageParser = factory.getPageParser(response.getContentType() != null ? response.getContentType() : TEXT_HTML);
            if (pageParser == null) {
                pageParser = factory.getPageParser("text/html;charset=UTF-8");
            }
            return pageParser;
        }
        return null;
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode) throws IOException {
        if (statusCode == 404) {
            this.renderDefaultResponse(response, statusCode, "Not Found", "Page not found.");
        } else {
            this.renderDefaultResponse(response, statusCode, "Internal Error", "Internal server error.");
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode, String title, String text) throws IOException {
        response.setStatus(404);
        response.setContentType(TEXT_HTML);
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<HTML>\n<HEAD>\n<TITLE>Error " + statusCode + " - " + title);
        ((Writer)writer).write("</TITLE>\n<BODY>\n<H2>Error " + statusCode + " - " + title + ".</H2>\n");
        ((Writer)writer).write(text + "<BR/>");
        for (int i = 0; i < 20; ++i) {
            ((Writer)writer).write("\n<!-- Padding for IE                  -->");
        }
        ((Writer)writer).write("\n</BODY>\n</HTML>\n");
        ((Writer)writer).flush();
    }

    private UrlMappingsHolder lookupUrlMappings() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (UrlMappingsHolder)wac.getBean("grailsUrlMappingsHolder");
    }
}

