/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.context;

import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.grape.Grape;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.security.AccessControlException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.codehaus.groovy.grails.web.context.GrailsConfigUtils;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsContextLoader
extends ContextLoader {
    public static final Log LOG = LogFactory.getLog(GrailsContextLoader.class);
    GrailsApplication application;

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        WebApplicationContext ctx;
        ExpandoMetaClass.enableGlobally();
        Metadata metadata = Metadata.getCurrent();
        if (metadata != null && metadata.isWarDeployed()) {
            Grape.setEnableAutoDownload((boolean)false);
            Grape.setEnableGrapes((boolean)false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"[GrailsContextLoader] Loading context. Creating parent application context");
        }
        try {
            ctx = super.createWebApplicationContext(servletContext, parent);
            this.application = (GrailsApplication)ctx.getBean("grailsApplication", GrailsApplication.class);
            ctx = GrailsConfigUtils.configureWebApplicationContext(servletContext, ctx);
            GrailsConfigUtils.executeGrailsBootstraps(this.application, ctx, servletContext);
        }
        catch (Throwable e) {
            GrailsUtil.deepSanitize(e);
            if (e instanceof BeansException) {
                throw (BeansException)e;
            }
            throw new BootstrapException("Error executing bootstraps", e);
        }
        return ctx;
    }

    public void closeWebApplicationContext(ServletContext servletContext) {
        if (this.application != null && this.application.isWarDeployed()) {
            WebApplicationContext ctx;
            GrailsPluginManager pluginManager;
            ClassLoader classLoader;
            if (this.application != null && (classLoader = this.application.getClassLoader()) instanceof GroovyClassLoader) {
                Class[] loadedClasses;
                MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
                for (Class loadedClass : loadedClasses = ((GroovyClassLoader)classLoader).getLoadedClasses()) {
                    metaClassRegistry.removeMetaClass(loadedClass);
                }
            }
            if ((pluginManager = PluginManagerHolder.getPluginManager()) != null) {
                try {
                    pluginManager.shutdown();
                }
                catch (Exception e) {
                    GrailsUtil.sanitize(e);
                    LOG.error((Object)("Error occurred shutting down plug-in manager: " + e.getMessage()), (Throwable)e);
                }
            }
            ConfigurableApplicationContext parent = (ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext)) != null ? (ConfigurableApplicationContext)ctx.getParent() : null;
            super.closeWebApplicationContext(servletContext);
            if (parent != null) {
                LOG.info((Object)("Destroying Spring parent WebApplicationContext " + parent.getDisplayName()));
                parent.close();
            }
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (AccessControlException e) {
                // empty catch block
            }
            ApplicationHolder.setApplication(null);
            ServletContextHolder.setServletContext(null);
            PluginManagerHolder.setPluginManager(null);
            ConfigurationHolder.setConfig(null);
            ExpandoMetaClass.disableGlobally();
            this.application = null;
        }
    }
}

