/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.view;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.factory.DefaultFactory;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.compatability.PageParser2ContentProcessor;
import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.grails.web.servlet.view.GrailsLayoutViewResolver;
import org.grails.web.sitemesh.FactoryHolder;
import org.grails.web.sitemesh.GroovyPageLayoutFinder;
import org.grails.web.sitemesh.SitemeshLayoutView;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class SitemeshLayoutViewResolver
extends GrailsLayoutViewResolver
implements GrailsApplicationAware,
DisposableBean,
Ordered,
ApplicationListener<ContextRefreshedEvent> {
    private static final String FACTORY_SERVLET_CONTEXT_ATTRIBUTE = "sitemesh.factory";
    private ContentProcessor contentProcessor;
    protected GrailsApplication grailsApplication;
    private boolean sitemeshConfigLoaded = false;
    private int order = 2147483597;

    public SitemeshLayoutViewResolver() {
    }

    public SitemeshLayoutViewResolver(ViewResolver innerViewResolver, GroovyPageLayoutFinder groovyPageLayoutFinder) {
        super(innerViewResolver, groovyPageLayoutFinder);
    }

    @Override
    protected View createLayoutView(View innerView) {
        return new SitemeshLayoutView(this.groovyPageLayoutFinder, innerView, this.contentProcessor);
    }

    public void init() {
        if (this.servletContext == null) {
            return;
        }
        Factory sitemeshFactory = (Factory)this.servletContext.getAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE);
        if (sitemeshFactory == null) {
            sitemeshFactory = this.loadSitemeshConfig();
        }
        this.contentProcessor = new PageParser2ContentProcessor(sitemeshFactory);
    }

    protected Factory loadSitemeshConfig() {
        FilterConfig filterConfig = new FilterConfig(){
            private Map<String, String> customConfig = Collections.singletonMap("configFile", "classpath:org/grails/web/sitemesh/sitemesh-default.xml");

            public ServletContext getServletContext() {
                return SitemeshLayoutViewResolver.this.servletContext;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(this.customConfig.keySet());
            }

            public String getInitParameter(String name) {
                return this.customConfig.get(name);
            }

            public String getFilterName() {
                return null;
            }
        };
        Config config = new Config(filterConfig);
        DefaultFactory sitemeshFactory = new DefaultFactory(config);
        if (this.servletContext != null) {
            this.servletContext.setAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE, (Object)sitemeshFactory);
        }
        sitemeshFactory.refresh();
        FactoryHolder.setFactory((Factory)sitemeshFactory);
        this.sitemeshConfigLoaded = true;
        return sitemeshFactory;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void destroy() throws Exception {
        this.clearSitemeshConfig();
    }

    protected void clearSitemeshConfig() {
        if (this.servletContext == null) {
            return;
        }
        if (this.sitemeshConfigLoaded) {
            FactoryHolder.setFactory(null);
            if (this.servletContext != null) {
                this.servletContext.removeAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE);
            }
            this.sitemeshConfigLoaded = false;
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.init();
    }
}

