/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.discovery;

import org.codehaus.groovy.grails.core.io.DefaultResourceLocator;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.core.io.Resource;

public class GroovyPageStaticResourceLocator
extends DefaultResourceLocator {
    public Resource findResourceForURI(String uri) {
        Resource resource = super.findResourceForURI(uri);
        if (resource == null || !resource.exists()) {
            GroovyPageBinding binding = this.findBindingInWebRequest();
            if (binding != null) {
                GrailsPlugin pagePlugin = binding.getPagePlugin();
                if (pagePlugin != null && this.pluginManager != null) {
                    resource = this.findResourceForPlugin(pagePlugin, uri);
                }
            } else if (this.pluginManager != null) {
                GrailsPlugin plugin;
                GrailsPlugin[] grailsPluginArray = this.pluginManager.getAllPlugins();
                int n = grailsPluginArray.length;
                for (int i = 0; i < n && (resource = this.findResourceForPlugin(plugin = grailsPluginArray[i], uri)) == null; ++i) {
                }
            }
        }
        return resource;
    }

    private Resource findResourceForPlugin(GrailsPlugin plugin, String uri) {
        String pluginPath = this.pluginManager.getPluginPath(plugin.getName());
        String pluginUri = GrailsResourceUtils.appendPiecesForUri((String[])new String[]{pluginPath, uri});
        Resource resource = super.findResourceForURI(pluginUri);
        return resource;
    }

    private GroovyPageBinding findBindingInWebRequest() {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            return (GroovyPageBinding)((Object)webRequest.getAttribute("org.codehaus.groovy.grails.PAGE_SCOPE", 0));
        }
        return null;
    }
}

