/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.view;

import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.view.AbstractGrailsView;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;

public class GroovyPageView
extends AbstractGrailsView {
    private static final Log LOG = LogFactory.getLog(GroovyPageView.class);
    protected GroovyPagesTemplateEngine templateEngine;
    private long createTimestamp = System.currentTimeMillis();
    private static final long LASTMODIFIED_CHECK_INTERVAL = Long.getLong("grails.gsp.reload.interval", 5000L);
    private ScriptSource scriptSource;
    protected Template template;
    public static final String EXCEPTION_MODEL_KEY = "exception";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTemplate(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("org.grails.rendering.view", (Object)Boolean.TRUE);
        GSPResponseWriter out = null;
        try {
            out = this.createResponseWriter(webRequest, response);
            this.template.make(model).writeTo((Writer)((Object)out));
        }
        catch (Exception e) {
            out.setError();
            this.handleException(e, this.templateEngine);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void handleException(Exception exception, GroovyPagesTemplateEngine engine) {
        LOG.debug((Object)("Error processing GroovyPageView: " + exception.getMessage()), (Throwable)exception);
        if (exception instanceof GroovyPagesException) {
            throw (GroovyPagesException)((Object)exception);
        }
        if (engine == null) {
            throw new GroovyPagesException("Error processing GroovyPageView: " + exception.getMessage(), exception, -1, this.getUrl());
        }
        throw GroovyPageView.createGroovyPageException(exception, engine, this.getUrl());
    }

    public static GroovyPagesException createGroovyPageException(Exception exception, GroovyPagesTemplateEngine engine, String pageUrl) {
        String file;
        int[] lineNumbers;
        GroovyPageTemplate t = (GroovyPageTemplate)engine.createTemplate(pageUrl);
        StackTraceElement[] stackTrace = exception.getStackTrace();
        String className = stackTrace[0].getClassName();
        int lineNumber = stackTrace[0].getLineNumber();
        if (className.contains("_gsp") && lineNumber < (lineNumbers = t.getMetaInfo().getLineNumbers()).length) {
            lineNumber = lineNumbers[lineNumber - 1];
        }
        Resource resource = pageUrl != null ? engine.getResourceForUri(pageUrl) : null;
        try {
            file = resource != null && resource.exists() ? resource.getFile().getAbsolutePath() : pageUrl;
        }
        catch (IOException e) {
            file = pageUrl;
        }
        return new GroovyPagesException("Error processing GroovyPageView: " + exception.getMessage(), exception, lineNumber, file);
    }

    protected GSPResponseWriter createResponseWriter(GrailsWebRequest webRequest, HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response);
        webRequest.setOut((Writer)((Object)out));
        return out;
    }

    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createTimestamp > LASTMODIFIED_CHECK_INTERVAL;
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        try {
            this.initTemplate();
        }
        catch (Exception e) {
            this.handleException(e, this.templateEngine);
        }
    }

    protected void initTemplate() throws IOException {
        this.template = this.scriptSource == null ? this.templateEngine.createTemplate(this.getUrl()) : this.templateEngine.createTemplate(this.scriptSource);
        if (this.template instanceof GroovyPageTemplate) {
            ((GroovyPageTemplate)this.template).setAllowSettingContentType(true);
        }
    }

    public void rethrowRenderException(Throwable ex, String message) {
        throw new GroovyPagesException(message, ex);
    }

    public Template getTemplate() {
        return this.template;
    }
}

