/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages.discovery;

import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.web.pages.GroovyPageBinding;
import org.codehaus.groovy.grails.web.pages.discovery.GrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageCompiledScriptSource;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageResourceScriptSource;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.util.CacheEntry;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class CachingGrailsConventionGroovyPageLocator
extends GrailsConventionGroovyPageLocator {
    private static final GroovyPageResourceScriptSource NULL_SCRIPT = new GroovyPageResourceScriptSource("/null", (Resource)new ByteArrayResource("".getBytes()));
    private Map<GroovyPageLocatorCacheKey, CacheEntry<GroovyPageScriptSource>> uriResolveCache = new ConcurrentHashMap<GroovyPageLocatorCacheKey, CacheEntry<GroovyPageScriptSource>>();
    private long cacheTimeout = -1L;

    @Override
    public GroovyPageScriptSource findPageInBinding(final String uri, final GroovyPageBinding binding) {
        if (uri == null) {
            return null;
        }
        PrivilegedAction<GroovyPageScriptSource> updater = new PrivilegedAction<GroovyPageScriptSource>(){

            @Override
            public GroovyPageScriptSource run() {
                GroovyPageScriptSource scriptSource = CachingGrailsConventionGroovyPageLocator.super.findPageInBinding(uri, binding);
                if (scriptSource == null) {
                    scriptSource = NULL_SCRIPT;
                }
                return scriptSource;
            }
        };
        return this.lookupCache(GroovyPageLocatorCacheKey.build(uri, null, binding), updater);
    }

    @Override
    public GroovyPageScriptSource findPageInBinding(final String pluginName, final String uri, final GroovyPageBinding binding) {
        if (uri == null || pluginName == null) {
            return null;
        }
        PrivilegedAction<GroovyPageScriptSource> updater = new PrivilegedAction<GroovyPageScriptSource>(){

            @Override
            public GroovyPageScriptSource run() {
                GroovyPageScriptSource scriptSource = CachingGrailsConventionGroovyPageLocator.super.findPageInBinding(pluginName, uri, binding);
                if (scriptSource == null) {
                    scriptSource = NULL_SCRIPT;
                }
                return scriptSource;
            }
        };
        return this.lookupCache(GroovyPageLocatorCacheKey.build(uri, pluginName, binding), updater);
    }

    @Override
    public GroovyPageScriptSource findPage(final String uri) {
        if (uri == null) {
            return null;
        }
        PrivilegedAction<GroovyPageScriptSource> updater = new PrivilegedAction<GroovyPageScriptSource>(){

            @Override
            public GroovyPageScriptSource run() {
                GroovyPageScriptSource scriptSource = CachingGrailsConventionGroovyPageLocator.super.findPage(uri);
                if (scriptSource == null) {
                    scriptSource = NULL_SCRIPT;
                }
                return scriptSource;
            }
        };
        return this.lookupCache(GroovyPageLocatorCacheKey.build(uri, null, null), updater);
    }

    protected GroovyPageScriptSource lookupCache(GroovyPageLocatorCacheKey cacheKey, PrivilegedAction<GroovyPageScriptSource> updater) {
        GroovyPageScriptSource scriptSource = null;
        if (this.cacheTimeout == 0L) {
            scriptSource = updater.run();
        } else {
            CacheEntry<GroovyPageScriptSource> entry = this.uriResolveCache.get(cacheKey);
            if (entry == null) {
                scriptSource = updater.run();
                this.uriResolveCache.put(cacheKey, new CustomCacheEntry<GroovyPageScriptSource>(scriptSource));
            } else {
                scriptSource = (GroovyPageScriptSource)entry.getValue(this.cacheTimeout, updater);
            }
        }
        return scriptSource == NULL_SCRIPT ? null : scriptSource;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    @Override
    public void removePrecompiledPage(GroovyPageCompiledScriptSource scriptSource) {
        super.removePrecompiledPage(scriptSource);
        for (Map.Entry<GroovyPageLocatorCacheKey, CacheEntry<GroovyPageScriptSource>> entry : new HashSet<Map.Entry<GroovyPageLocatorCacheKey, CacheEntry<GroovyPageScriptSource>>>(this.uriResolveCache.entrySet())) {
            GroovyPageScriptSource ss = (GroovyPageScriptSource)entry.getValue().getValue();
            if (ss != scriptSource && (!(ss instanceof GroovyPageCompiledScriptSource) || !scriptSource.getURI().equals(((GroovyPageCompiledScriptSource)ss).getURI()))) continue;
            this.uriResolveCache.remove(entry.getKey());
        }
    }

    private static class CustomCacheEntry<T>
    extends CacheEntry<T> {
        public CustomCacheEntry(T value) {
            super(value);
        }

        protected boolean shouldUpdate(long beforeLockingCreatedMillis) {
            boolean compiledScriptSourceInstance = this.getValue() instanceof GroovyPageCompiledScriptSource;
            if (compiledScriptSourceInstance) {
                this.resetTimestamp();
            }
            return !compiledScriptSourceInstance && super.shouldUpdate(beforeLockingCreatedMillis);
        }
    }

    private static final class GroovyPageLocatorCacheKey {
        private final String uri;
        private final String pluginName;
        private final String contextPath;

        private GroovyPageLocatorCacheKey(String uri, String pluginName, String contextPath) {
            this.uri = uri;
            this.pluginName = pluginName;
            this.contextPath = contextPath;
        }

        public static final GroovyPageLocatorCacheKey build(String uri, String pluginName, GroovyPageBinding binding) {
            String pluginNameInCacheKey = pluginName == null ? (binding != null ? (binding.getPagePlugin() != null ? binding.getPagePlugin().getName() : null) : null) : pluginName;
            return new GroovyPageLocatorCacheKey(uri, pluginNameInCacheKey, binding != null ? binding.getPluginContextPath() : null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroovyPageLocatorCacheKey that = (GroovyPageLocatorCacheKey)o;
            if (this.contextPath != null ? !this.contextPath.equals(that.contextPath) : that.contextPath != null) {
                return false;
            }
            if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
                return false;
            }
            return !(this.uri != null ? !this.uri.equals(that.uri) : that.uri != null);
        }

        public int hashCode() {
            int result = this.uri != null ? this.uri.hashCode() : 0;
            result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
            result = 31 * result + (this.contextPath != null ? this.contextPath.hashCode() : 0);
            return result;
        }
    }
}

