/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestContextHolder;

public class GrailsFlashScope
implements grails.web.mvc.FlashScope,
FlashScope {
    private static final long serialVersionUID = 1457772347769500476L;
    private Map current = new ConcurrentHashMap();
    private Map next = new ConcurrentHashMap();
    public static final String ERRORS_PREFIX = "org.codehaus.groovy.grails.ERRORS_";
    private static final String ERRORS_PROPERTY = "errors";

    @Override
    public void next() {
        this.current.clear();
        this.current = new ConcurrentHashMap(this.next);
        this.next.clear();
        this.reassociateObjectsWithErrors(this.current);
    }

    @Override
    public Map getNow() {
        return this.current;
    }

    private void reassociateObjectsWithErrors(Map scope) {
        for (Object key : scope.keySet()) {
            Object value = scope.get(key);
            if (value instanceof Map) {
                this.reassociateObjectsWithErrors((Map)value);
            }
            this.reassociateObjectWithErrors(scope, value);
        }
    }

    private void reassociateObjectWithErrors(Map scope, Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object val : values) {
                this.reassociateObjectWithErrors(scope, val);
            }
        } else {
            MetaClass mc;
            String errorsKey = ERRORS_PREFIX + System.identityHashCode(value);
            Object errors = scope.get(errorsKey);
            if (value != null && errors != null && (mc = GroovySystem.getMetaClassRegistry().getMetaClass(value.getClass())).hasProperty(value, ERRORS_PROPERTY) != null) {
                mc.setProperty(value, ERRORS_PROPERTY, errors);
            }
        }
    }

    @Override
    public int size() {
        return this.current.size() + this.next.size();
    }

    @Override
    public void clear() {
        this.current.clear();
        this.next.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.current.containsKey(key) || this.next.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.current.containsValue(value) || this.next.containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.addAll(this.current.values());
        c.addAll(this.next.values());
        return c;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        for (Map.Entry<? extends String, ? extends Object> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        entrySet.addAll(this.current.entrySet());
        entrySet.addAll(this.next.entrySet());
        return entrySet;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.current.keySet());
        keySet.addAll(this.next.keySet());
        return keySet;
    }

    @Override
    public Object get(Object key) {
        if (this.next.containsKey(key)) {
            return this.next.get(key);
        }
        if ("now".equals(key)) {
            return this.getNow();
        }
        return this.current.get(key);
    }

    @Override
    public Object remove(Object key) {
        if (this.current.containsKey(key)) {
            return this.current.remove(key);
        }
        return this.next.remove(key);
    }

    @Override
    public Object put(String key, Object value) {
        this.registerWithSessionIfNecessary();
        if (this.current.containsKey(key)) {
            this.current.remove(key);
        }
        this.storeErrorsIfPossible(this.next, value);
        if (value == null) {
            return this.next.remove(key);
        }
        return this.next.put(key, value);
    }

    private void storeErrorsIfPossible(Map scope, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object val : values) {
                this.storeErrorsIfPossible(scope, val);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            LinkedList keys = new LinkedList(map.keySet());
            for (Object key : keys) {
                Object val = map.get(key);
                this.storeErrorsIfPossible(map, val);
            }
        } else {
            Object errors;
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(value.getClass());
            if (mc.hasProperty(value, ERRORS_PROPERTY) != null && (errors = mc.getProperty(value, ERRORS_PROPERTY)) != null) {
                scope.put(ERRORS_PREFIX + System.identityHashCode(value), errors);
            }
        }
    }

    private void registerWithSessionIfNecessary() {
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        HttpSession session = webRequest.getCurrentRequest().getSession(true);
        if (session.getAttribute("org.grails.FLASH_SCOPE") == null) {
            session.setAttribute("org.grails.FLASH_SCOPE", (Object)this);
        }
    }
}

